/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import b.h.la;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchProfileBase;
import com.intellij.structuralsearch.XmlStructuralSearchProfile;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructuralSearchUtil {
    private static final String c = ".$|()[]{}^?*+\\";
    private static final Key<StructuralSearchProfile> a;
    private static LanguageFileType d;
    public static boolean ourUseUniversalMatchingAlgorithm;
    private static StructuralSearchProfile[] b;
    private static List<Configuration> e;
    private static final long f;

    private StructuralSearchUtil() {
    }

    @Nullable
    public static StructuralSearchProfile getProfileByPsiElement(@NotNull PsiElement element) {
        if (element == null) {
            StructuralSearchUtil.a(0);
        }
        return StructuralSearchUtil.getProfileByLanguage(element.getLanguage());
    }

    @Contract(value="null -> false")
    public static boolean isIdentifier(PsiElement element) {
        if (element == null) {
            return false;
        }
        StructuralSearchProfile structuralSearchProfile = StructuralSearchUtil.getProfileByPsiElement(element);
        return structuralSearchProfile != null && structuralSearchProfile.isIdentifier(element);
    }

    public static PsiElement getParentIfIdentifier(PsiElement element) {
        return !StructuralSearchUtil.isIdentifier(element) ? element : element.getParent();
    }

    @Contract(value="!null -> !null")
    public static PsiElement getPresentableElement(PsiElement element) {
        if (element == null) {
            return null;
        }
        StructuralSearchProfile structuralSearchProfile = StructuralSearchUtil.getProfileByPsiElement(element);
        return structuralSearchProfile == null ? element : structuralSearchProfile.getPresentableElement(element);
    }

    private static StructuralSearchProfile[] b() {
        if (b == null) {
            ArrayList<StructuralSearchProfile> arrayList = new ArrayList<StructuralSearchProfile>();
            for (StructuralSearchProfile structuralSearchProfile : (StructuralSearchProfile[])StructuralSearchProfile.EP_NAME.getExtensions()) {
                if (!(structuralSearchProfile instanceof StructuralSearchProfileBase)) continue;
                arrayList.add(structuralSearchProfile);
            }
            arrayList.add(new XmlStructuralSearchProfile());
            b = arrayList.toArray(new StructuralSearchProfile[0]);
        }
        return b;
    }

    private static StructuralSearchProfile[] a() {
        return ourUseUniversalMatchingAlgorithm ? StructuralSearchUtil.b() : (StructuralSearchProfile[])StructuralSearchProfile.EP_NAME.getExtensions();
    }

    public static FileType getDefaultFileType() {
        long l2 = f ^ 0x6FF8E4372C27L;
        if (d == null) {
            for (StructuralSearchProfile structuralSearchProfile : StructuralSearchUtil.a()) {
                d = structuralSearchProfile.getDefaultFileType(d);
            }
            if (d == null) {
                d = StdFileTypes.XML;
            }
        }
        assert (d instanceof LanguageFileType) : "file type not valid for structural search: " + d.getName();
        return d;
    }

    public static void clearProfileCache(@NotNull Language language) {
        if (language == null) {
            StructuralSearchUtil.a(1);
        }
        language.putUserData(a, null);
    }

    @Nullable
    public static StructuralSearchProfile getProfileByLanguage(@NotNull Language language) {
        StructuralSearchProfile structuralSearchProfile;
        if (language == null) {
            StructuralSearchUtil.a(2);
        }
        if ((structuralSearchProfile = (StructuralSearchProfile)language.getUserData(a)) != null) {
            return structuralSearchProfile;
        }
        for (StructuralSearchProfile structuralSearchProfile2 : StructuralSearchUtil.a()) {
            if (!structuralSearchProfile2.isMyLanguage(language)) continue;
            language.putUserData(a, (Object)structuralSearchProfile2);
            return structuralSearchProfile2;
        }
        return null;
    }

    public static boolean isTypedVariable(@NotNull String name) {
        if (name == null) {
            StructuralSearchUtil.a(3);
        }
        return name.length() > 1 && name.charAt(0) == '$' && name.charAt(name.length() - 1) == '$';
    }

    @Nullable
    public static StructuralSearchProfile getProfileByFileType(FileType fileType) {
        if (!(fileType instanceof LanguageFileType)) {
            return null;
        }
        LanguageFileType languageFileType = (LanguageFileType)fileType;
        return StructuralSearchUtil.getProfileByLanguage(languageFileType.getLanguage());
    }

    @NotNull
    public static FileType[] getSuitableFileTypes() {
        HashSet<LanguageFileType> hashSet = new HashSet<LanguageFileType>();
        Collections.addAll(hashSet, FileTypeManager.getInstance().getRegisteredFileTypes());
        for (Object object : Language.getRegisteredLanguages()) {
            LanguageFileType languageFileType = object.getAssociatedFileType();
            if (languageFileType == null) continue;
            hashSet.add(languageFileType);
        }
        ArrayList arrayList = new ArrayList();
        for (LanguageFileType languageFileType : hashSet) {
            if (!(languageFileType instanceof LanguageFileType)) continue;
            arrayList.add(languageFileType);
        }
        FileType[] fileTypeArray = arrayList.toArray(FileType.EMPTY_ARRAY);
        if (fileTypeArray == null) {
            StructuralSearchUtil.a(4);
        }
        return fileTypeArray;
    }

    public static boolean containsRegExpMetaChar(String s2) {
        return s2.chars().anyMatch(StructuralSearchUtil::isRegExpMetaChar);
    }

    public static boolean isRegExpMetaChar(int ch2) {
        long l2 = f ^ 0x31F464B4D633L;
        return c.indexOf(ch2) >= 0;
    }

    public static String shieldRegExpMetaChars(String word) {
        return StructuralSearchUtil.shieldRegExpMetaChars(word, new StringBuilder(word.length())).toString();
    }

    @NotNull
    public static StringBuilder shieldRegExpMetaChars(String word, StringBuilder out) {
        int n2 = word.length();
        for (int i10 = 0; i10 < n2; ++i10) {
            if (StructuralSearchUtil.isRegExpMetaChar(word.charAt(i10))) {
                out.append("\\");
            }
            out.append(word.charAt(i10));
        }
        StringBuilder stringBuilder = out;
        if (stringBuilder == null) {
            StructuralSearchUtil.a(5);
        }
        return stringBuilder;
    }

    public static List<Configuration> getPredefinedTemplates() {
        if (e == null) {
            ArrayList arrayList = new ArrayList();
            for (StructuralSearchProfile structuralSearchProfile : StructuralSearchUtil.a()) {
                Collections.addAll(arrayList, structuralSearchProfile.getPredefinedTemplates());
            }
            Collections.sort(arrayList);
            e = Collections.unmodifiableList(arrayList);
        }
        return e;
    }

    public static boolean isDocCommentOwner(PsiElement match) {
        StructuralSearchProfile structuralSearchProfile = StructuralSearchUtil.getProfileByPsiElement(match);
        return structuralSearchProfile != null && structuralSearchProfile.isDocCommentOwner(match);
    }

    static {
        f = la.a(5510670966939827537L, -3876376299035091344L, MethodHandles.lookup().lookupClass()).a(120917227395540L);
        long l2 = f ^ 0x3D31314125B1L;
        a = new Key("Structural Search Profile");
        d = null;
        ourUseUniversalMatchingAlgorithm = false;
        e = null;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = f ^ 0x7C40CD597CEL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/StructuralSearchUtil";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/StructuralSearchUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuitableFileTypes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "shieldRegExpMetaChars";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProfileByPsiElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "clearProfileCache";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getProfileByLanguage";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isTypedVariable";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

