/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons.model;

import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.model.RubyEntity;
import org.rubyforge.debugcommons.model.RubyFrameInfo;
import org.rubyforge.debugcommons.model.RubyThread;
import org.rubyforge.debugcommons.model.RubyVariable;

public final class RubyFrame
extends RubyEntity {
    private final RubyFrameInfo d;
    private final RubyThread c;
    private RubyVariable[] b;

    public RubyFrame(RubyThread thread, RubyFrameInfo info) {
        super(thread.getProxy());
        this.d = info;
        this.c = thread;
    }

    public String getFile() {
        return this.d.getFile();
    }

    public int getLine() {
        return this.d.getLine();
    }

    public int getIndex() {
        return this.d.getIndex();
    }

    public RubyThread getThread() {
        return this.c;
    }

    public RubyVariable[] getVariables() throws RubyDebuggerException {
        if (this.b == null) {
            this.b = this.getProxy().readVariables(this);
        }
        return this.b;
    }

    public void clearCachedVariables() {
        this.b = null;
    }

    public RubyVariable inspectExpression(String expression) throws RubyDebuggerException {
        return this.getProxy().inspectExpression(this, expression);
    }

    public String getName() {
        return this.getFile() + ':' + this.getLine();
    }

    public void stepOver(boolean forceNewLine) {
        this.c.resumeImpl();
        this.getProxy().sendStepOver(this, forceNewLine);
    }

    public void stepReturn() {
        this.c.resumeImpl();
        this.getProxy().sendStepReturnEnd(this);
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RubyFrame)) {
            return false;
        }
        RubyFrame rubyFrame = (RubyFrame)obj;
        return this.d == null ? rubyFrame.d == null : this.d.equals(rubyFrame.d);
    }

    public int hashCode() {
        int n2 = 3;
        n2 = 89 * n2 + (this.d != null ? this.d.hashCode() : 0);
        return n2;
    }
}

