/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.configuration.beans.v2;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeConfiguration;
import com.intellij.docker.compose.configuration.beans.v2.DockerComposeServiceV2;
import com.intellij.docker.compose.configuration.beans.v2.DockerComposeVolumeV2;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"version", "services", "volumes"})
public class DockerComposeConfigurationV2
implements DockerComposeConfiguration {
    public static final String VERSION_TAG = "version";
    public static final String VERSION_2 = "2";
    private String myVersion;
    private Map<String, DockerComposeServiceV2> myServices;
    private Map<String, DockerComposeVolumeV2> myVolumes;

    public DockerComposeConfigurationV2() {
    }

    public DockerComposeConfigurationV2(Map<String, DockerComposeServiceV2> services) {
        this(VERSION_2, services);
    }

    public DockerComposeConfigurationV2(@NotNull String version, Map<String, DockerComposeServiceV2> services) {
        if (version == null) {
            DockerComposeConfigurationV2.$$$reportNull$$$0(0);
        }
        this.myVersion = version;
        this.myServices = services;
    }

    @JsonProperty
    public String getVersion() {
        return this.myVersion;
    }

    @JsonProperty
    public void setVersion(String version) {
        this.myVersion = version;
    }

    @JsonProperty
    public Map<String, DockerComposeServiceV2> getServices() {
        if (this.myServices == null) {
            this.myServices = new LinkedHashMap<String, DockerComposeServiceV2>();
        }
        return this.myServices;
    }

    @JsonProperty
    public void setServices(Map<String, DockerComposeServiceV2> services) {
        this.myServices = services;
    }

    @JsonProperty
    public Map<String, DockerComposeVolumeV2> getVolumes() {
        return this.myVolumes;
    }

    @JsonProperty
    public void setVolumes(Map<String, DockerComposeVolumeV2> volumes) {
        this.myVolumes = volumes;
    }

    @Override
    public <T> T accept(DockerComposeConfiguration.Visitor<T> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return "DockerComposeConfigurationV2{myVersion='" + this.myVersion + '\'' + ", myServices=" + this.myServices + ", myVolumes=" + this.myVolumes + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DockerComposeConfigurationV2 v2 = (DockerComposeConfigurationV2)o;
        if (this.myVersion != null ? !this.myVersion.equals(v2.myVersion) : v2.myVersion != null) {
            return false;
        }
        if (this.myServices != null ? !this.myServices.equals(v2.myServices) : v2.myServices != null) {
            return false;
        }
        return !(this.myVolumes != null ? !this.myVolumes.equals(v2.myVolumes) : v2.myVolumes != null);
    }

    public int hashCode() {
        int result = this.myVersion != null ? this.myVersion.hashCode() : 0;
        result = 31 * result + (this.myServices != null ? this.myServices.hashCode() : 0);
        result = 31 * result + (this.myVolumes != null ? this.myVolumes.hashCode() : 0);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", VERSION_TAG, "com/intellij/docker/compose/configuration/beans/v2/DockerComposeConfigurationV2", "<init>"));
    }
}

