/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.composites;

import java.nio.ByteBuffer;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.db.composites.AbstractComposite;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.memory.AbstractAllocator;

public class SimpleSparseCellName
extends AbstractComposite
implements CellName {
    private static final long EMPTY_SIZE = ObjectSizes.measure(new SimpleSparseCellName(null));
    private final ColumnIdentifier columnName;

    SimpleSparseCellName(ColumnIdentifier columnName) {
        this.columnName = columnName;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public ByteBuffer get(int i) {
        if (i != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.columnName.bytes;
    }

    @Override
    public Composite withEOC(Composite.EOC newEoc) {
        return this;
    }

    @Override
    public ByteBuffer toByteBuffer() {
        return this.columnName.bytes;
    }

    @Override
    public int clusteringSize() {
        return 0;
    }

    @Override
    public ColumnIdentifier cql3ColumnName(CFMetaData metadata) {
        return this.columnName;
    }

    @Override
    public ByteBuffer collectionElement() {
        return null;
    }

    @Override
    public boolean isCollectionCell() {
        return false;
    }

    @Override
    public boolean isSameCQL3RowAs(CellNameType type, CellName other) {
        return true;
    }

    @Override
    public long unsharedHeapSizeExcludingData() {
        return EMPTY_SIZE + this.columnName.unsharedHeapSizeExcludingData();
    }

    @Override
    public long unsharedHeapSize() {
        return EMPTY_SIZE + this.columnName.unsharedHeapSize();
    }

    @Override
    public CellName copy(CFMetaData cfm, AbstractAllocator allocator) {
        return new SimpleSparseCellName(this.columnName.clone(allocator));
    }
}

