/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class ParseOptions {
    private final ArrayList<String> startText = new ArrayList();
    private final HashMap<String, Option<?>> optionsByFlag = new HashMap();
    private final HashMap<String, Option<?>> optionsByName = new HashMap();

    public ParseOptions() {
        this.addOption("-h", "Displays the help menu.", false);
        this.addOption("--help", "Displays the help menu.", false);
        this.addOption("--version", "Displays the version and build time.", false);
    }

    public void addStartTextLine(String text) {
        this.startText.add(text);
    }

    public <T> void addOption(String flag, String description, T defaultValue) {
        if (this.optionsByFlag.get(flag = this.parseFlag(flag)) != null) {
            return;
        }
        Option option = new Option(flag, description, defaultValue);
        this.optionsByFlag.put(flag, option);
        this.optionsByName.put(flag, option);
    }

    public <T> void setOptions(String flag, T defaultValue) {
        Option option = new Option(flag, ((Option)this.getFlag(flag)).description, defaultValue);
        this.optionsByFlag.put(flag, option);
        this.optionsByName.put(flag, option);
    }

    public <T> void addRequiredOption(String flag, String description, Class<T> objectClass) {
        flag = this.parseFlag(flag);
        Option option = new Option(flag, description, true, objectClass);
        this.optionsByFlag.put(flag, option);
        this.optionsByName.put(flag, option);
    }

    public String parseFlag(String flag) {
        return flag;
    }

    public boolean process(String[] args) {
        try {
            this.parse(args);
            if (this.needsHelp()) {
                System.out.println(this.helpMenuString());
                return false;
            }
            if (this.needsVersion()) {
                System.out.println("Version = " + ParseOptions.class.getPackage().getImplementationVersion());
                return false;
            }
            this.checkParameters();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.out.println(this.helpMenuString());
            return false;
        }
        return true;
    }

    public Option<?> get(String name) throws RuntimeException {
        Option<?> option = this.optionsByName.get(name);
        if (option == null) {
            throw new RuntimeException("Invalid option name \"" + name + "\".");
        }
        return option;
    }

    public Option<?> getFlag(String flag) throws RuntimeException {
        Option<?> option = this.optionsByFlag.get(flag);
        if (option == null) {
            throw new RuntimeException("Invalid flag \"" + flag + "\".");
        }
        return option;
    }

    public String toString() {
        StringBuilder menuString = new StringBuilder();
        ArrayList<String> list = new ArrayList<String>(this.optionsByFlag.keySet());
        Collections.sort(list);
        for (String key : list) {
            Option<?> currOption = this.optionsByFlag.get(key);
            menuString.append("" + ((Option)currOption).flag + " = ");
            menuString.append("" + ((Option)currOption).value);
            menuString.append("\n");
        }
        return menuString.toString();
    }

    public String helpMenuString() {
        StringBuilder menuString = new StringBuilder();
        for (String str : this.startText) {
            menuString.append(str + "\n");
        }
        ArrayList<String> list = new ArrayList<String>(this.optionsByFlag.keySet());
        Collections.sort(list);
        for (String key : list) {
            Option<?> currOption = this.optionsByFlag.get(key);
            menuString.append("\t\t" + ((Option)currOption).flag + ", ");
            if (currOption.isRequired()) {
                menuString.append("*required, ");
            } else if (currOption.isString()) {
                menuString.append("default = \"" + ((Option)currOption).value + "\"");
            } else {
                menuString.append("default = " + ((Option)currOption).value);
            }
            menuString.append("\n");
            menuString.append("\t\t\t" + ((Option)currOption).description);
            menuString.append("\n");
        }
        return menuString.toString();
    }

    public void checkParameters() {
        for (Option<?> option : this.optionsByFlag.values()) {
            if (!((Option)option).required || ((Option)option).wasSet) continue;
            throw new RuntimeException("Required option flag \"" + ((Option)option).flag + "\" was not set.");
        }
    }

    public boolean needsHelp() {
        return this.get("--help").getBoolean() || this.get("-h").getBoolean();
    }

    public boolean needsVersion() {
        return this.get("--version").getBoolean();
    }

    public void parse(String[] args) throws RuntimeException {
        for (int iter = 0; iter < args.length; ++iter) {
            String flag = args[iter].trim();
            if (!flag.startsWith("-")) {
                throw new RuntimeException("Unknown parameter in command line: " + flag);
            }
            Option<?> option = this.getFlag(flag = this.parseFlag(flag));
            if (option == null) {
                throw new RuntimeException("Unknown flag \"" + flag + "\".");
            }
            if (option.isBoolean()) {
                option.setValue(true);
                continue;
            }
            if (iter + 1 < args.length) {
                if (option.isDouble()) {
                    option.setValue(new Double(args[iter + 1]));
                    ++iter;
                    continue;
                }
                if (option.isInteger()) {
                    option.setValue(new Integer(args[iter + 1]));
                    ++iter;
                    continue;
                }
                if (option.isString()) {
                    option.setValue(args[iter + 1]);
                    ++iter;
                    continue;
                }
                throw new RuntimeException("Cannot parse flag \"" + option.getFlag() + "\" of type " + option.getType().getName() + ".");
            }
            throw new RuntimeException("Not value provided for flag \"" + option.getFlag() + "\" of type " + option.getType().getName() + ".");
        }
    }

    public class Option<T> {
        protected final Class<T> objectClass;
        private final String description;
        private final String flag;
        private Object value;
        private boolean wasSet;
        private boolean required;

        private Option(String flag, String description, T defaultValue) {
            this.flag = flag;
            this.description = description;
            this.value = defaultValue;
            this.wasSet = false;
            this.required = false;
            this.objectClass = defaultValue.getClass();
        }

        private Option(String flag, String description, boolean required, Class<T> objectClass) {
            this.flag = this.parseFlag(flag);
            this.description = description;
            this.value = null;
            this.wasSet = false;
            this.required = required;
            this.objectClass = objectClass;
        }

        private String parseFlag(String flag) {
            if ((flag = flag.trim()).startsWith("-")) {
                flag = flag.substring(1);
            }
            return flag;
        }

        public boolean isBoolean() {
            return Boolean.class.isAssignableFrom(this.objectClass);
        }

        public boolean isDouble() {
            return Double.class.isAssignableFrom(this.objectClass);
        }

        public boolean isInteger() {
            return Integer.class.isAssignableFrom(this.objectClass);
        }

        public boolean isString() {
            return String.class.isAssignableFrom(this.objectClass);
        }

        public boolean getBoolean() {
            return (Boolean)this.value;
        }

        public String getString() {
            if (this.value == null) {
                return "";
            }
            return (String)this.value;
        }

        public double getDouble() {
            return (Double)this.value;
        }

        public int getInteger() {
            return (Integer)this.value;
        }

        public void setValue(Object value) {
            if (!this.objectClass.isInstance(value)) {
                throw new RuntimeException("Incompatable value type for flag \"" + this.flag + "\" of type " + this.objectClass.getName() + ": " + value.getClass().getName());
            }
            this.value = value;
            this.wasSet = true;
        }

        public String getFlag() {
            return this.flag;
        }

        public boolean isSet() {
            return this.wasSet;
        }

        public boolean isRequired() {
            return this.required;
        }

        public Class<T> getType() {
            return this.objectClass;
        }
    }
}

