/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.activation;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingConstants;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.activation.ActiveDockableTracker;
import org.flexdock.util.DockingUtility;
import org.flexdock.util.SwingUtility;

public class ActiveDockableListener
implements DockingConstants,
PropertyChangeListener,
ChangeListener,
AWTEventListener {
    private static final ActiveDockableListener SINGLETON = new ActiveDockableListener();
    private static HashSet PROP_EVENTS = new HashSet();

    public static void prime() {
    }

    private static void primeImpl() {
        PROP_EVENTS.add("permanentFocusOwner");
        PROP_EVENTS.add("activeWindow");
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                focusManager.addPropertyChangeListener(SINGLETON);
            }
        });
        Toolkit.getDefaultToolkit().addAWTEventListener(SINGLETON, 16L);
    }

    public static ActiveDockableListener getInstance() {
        return SINGLETON;
    }

    private ActiveDockableListener() {
    }

    public void eventDispatched(AWTEvent event) {
        Container container;
        if (event.getID() != 501) {
            return;
        }
        MouseEvent evt = (MouseEvent)event;
        Component c = (Component)evt.getSource();
        Container container2 = container = c instanceof Container ? (Container)c : null;
        if (container != null && container.getComponentCount() > 1) {
            Point p = evt.getPoint();
            c = SwingUtilities.getDeepestComponentAt(c, p.x, p.y);
        }
        ActiveDockableTracker.requestDockableActivation(c);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        boolean switchTo;
        String pName = evt.getPropertyName();
        if (!PROP_EVENTS.contains(pName)) {
            return;
        }
        Component oldVal = SwingUtility.toComponent(evt.getOldValue());
        Component newVal = SwingUtility.toComponent(evt.getNewValue());
        boolean bl = switchTo = newVal != null;
        if ("activeWindow".equals(pName)) {
            this.handleWindowChange(evt, oldVal, newVal, switchTo);
        } else {
            this.handleFocusChange(evt, oldVal, newVal, switchTo);
        }
    }

    private void handleWindowChange(PropertyChangeEvent evt, Component oldVal, Component newVal, boolean activate) {
        ActiveDockableTracker.windowActivated(newVal);
        Component srcComponent = activate ? newVal : oldVal;
        ActiveDockableTracker tracker = ActiveDockableTracker.getTracker(srcComponent);
        if (tracker != null) {
            tracker.setActive(activate);
        }
    }

    private void handleFocusChange(PropertyChangeEvent evt, Component oldVal, Component newVal, boolean switchTo) {
        if (!switchTo) {
            return;
        }
        if (newVal instanceof JTabbedPane) {
            newVal = ((JTabbedPane)newVal).getSelectedComponent();
        }
        this.activateComponent(newVal);
    }

    private void activateComponent(Component c) {
        Dockable dockable = DockingUtility.getAncestorDockable(c);
        if (dockable == null) {
            return;
        }
        ActiveDockableTracker tracker = ActiveDockableTracker.getTracker(dockable.getComponent());
        if (tracker != null) {
            tracker.setActive(dockable);
        }
    }

    public void stateChanged(ChangeEvent e) {
        JTabbedPane pane;
        Component c;
        Dockable dockable;
        Object obj = e.getSource();
        if (obj instanceof JTabbedPane && (dockable = DockingManager.getDockable(c = (pane = (JTabbedPane)obj).getSelectedComponent())) != null) {
            this.activateComponent(dockable.getComponent());
            this.udpateTabChangeFocus(dockable);
        }
    }

    private void udpateTabChangeFocus(final Dockable dockable) {
        KeyboardFocusManager mgr = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Dockable focusParent = DockingUtility.getAncestorDockable(mgr.getFocusOwner());
        if (focusParent == null || focusParent == dockable) {
            return;
        }
        Component comp = dockable.getComponent();
        final Component deep = SwingUtilities.getDeepestComponentAt(comp, comp.getWidth() / 2, comp.getHeight() / 2);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ActiveDockableTracker.focusDockable(deep, dockable, true);
            }
        });
    }

    static {
        ActiveDockableListener.primeImpl();
    }
}

