/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.fast.visitor;

import java.util.List;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.fast.instruction.FastSynchronized;
import jd.core.model.instruction.fast.instruction.FastTry;
import jd.core.process.analyzer.classfile.visitor.CompareInstructionVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastCompareInstructionVisitor
extends CompareInstructionVisitor {
    public boolean visit(List<Instruction> list1, List<Instruction> list2, int index1, int index2, int length) {
        if (index1 + length <= list1.size() && index2 + length <= list2.size()) {
            while (length-- > 0) {
                if (this.visit(list1.get(index1++), list2.get(index2++))) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean visit(Instruction i1, Instruction i2) {
        if (i1.opcode != i2.opcode) {
            return false;
        }
        switch (i1.opcode) {
            case 318: {
                FastTry.FastCatch fc2;
                FastTry.FastCatch fc1;
                FastTry ft1 = (FastTry)i1;
                FastTry ft2 = (FastTry)i2;
                int i = ft1.catches.size();
                if (i != ft2.catches.size()) {
                    return false;
                }
                if (ft1.finallyInstructions == null ? ft2.finallyInstructions != null : (ft2.finallyInstructions == null ? ft1.finallyInstructions != null : !this.visit(ft1.finallyInstructions, ft2.finallyInstructions))) {
                    return false;
                }
                do {
                    if (i-- <= 0) {
                        return this.visit(ft1.instructions, ft2.instructions);
                    }
                    fc1 = ft1.catches.get(i);
                    fc2 = ft2.catches.get(i);
                } while (fc1.exceptionTypeIndex == fc2.exceptionTypeIndex && this.visit(fc1.instructions, fc2.instructions) && FastCompareInstructionVisitor.CompareExceptionTypeIndexes(fc1.otherExceptionTypeIndexes, fc2.otherExceptionTypeIndexes));
                return false;
            }
            case 319: {
                FastSynchronized fs1 = (FastSynchronized)i1;
                FastSynchronized fs2 = (FastSynchronized)i2;
                if (!this.visit(fs1.monitor, fs2.monitor)) {
                    return false;
                }
                return this.visit(fs1.instructions, fs2.instructions);
            }
        }
        return super.visit(i1, i2);
    }

    /*
     * Unable to fully structure code
     */
    private static boolean CompareExceptionTypeIndexes(int[] otherExceptionTypeIndexes1, int[] otherExceptionTypeIndexes2) {
        if (otherExceptionTypeIndexes1 == null) {
            return otherExceptionTypeIndexes2 == null;
        }
        if (otherExceptionTypeIndexes2 == null) {
            return false;
        }
        i = otherExceptionTypeIndexes1.length;
        if (i == otherExceptionTypeIndexes2.length) ** GOTO lbl10
        return false;
lbl-1000:
        // 1 sources

        {
            if (otherExceptionTypeIndexes1[i] == otherExceptionTypeIndexes2[i]) continue;
            return false;
lbl10:
            // 2 sources

            ** while (i-- > 0)
        }
lbl11:
        // 1 sources

        return true;
    }
}

