/*
 * Decompiled with CFR 0.152.
 */
package kafka.message;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import kafka.message.BaseMessageSetTestCases;
import kafka.message.ByteBufferMessageSet;
import kafka.message.CompressionCodec;
import kafka.message.DefaultCompressionCodec$;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.message.NoCompressionCodec$;
import kafka.utils.TestUtils$;
import org.junit.Assert;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function1;
import scala.Predef$;
import scala.collection.GenSet;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0001i3A!\u0001\u0002\u0001\u000f\tA\")\u001f;f\u0005V4g-\u001a:NKN\u001c\u0018mZ3TKR$Vm\u001d;\u000b\u0005\r!\u0011aB7fgN\fw-\u001a\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\t%A\u0011\u0011\u0002E\u0007\u0002\u0015)\u00111\u0002D\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u001b9\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003=\t1a\u001c:h\u0013\t\t\"B\u0001\u0006K+:LGoU;ji\u0016\u0004\"a\u0005\u000b\u000e\u0003\tI!!\u0006\u0002\u0003/\t\u000b7/Z'fgN\fw-Z*fiR+7\u000f^\"bg\u0016\u001c\b\"B\f\u0001\t\u0003A\u0012A\u0002\u001fj]&$h\bF\u0001\u001a!\t\u0019\u0002\u0001C\u0003\u001c\u0001\u0011\u0005C$\u0001\tde\u0016\fG/Z'fgN\fw-Z*fiR\u0011Q\u0004\t\t\u0003'yI!a\b\u0002\u0003)\tKH/\u001a\"vM\u001a,'/T3tg\u0006<WmU3u\u0011\u0015\t#\u00041\u0001#\u0003!iWm]:bO\u0016\u001c\bcA\u0012.a9\u0011AE\u000b\b\u0003K!j\u0011A\n\u0006\u0003O\u0019\ta\u0001\u0010:p_Rt\u0014\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-b\u0013a\u00029bG.\fw-\u001a\u0006\u0002S%\u0011af\f\u0002\u0004'\u0016\f(BA\u0016-!\t\u0019\u0012'\u0003\u00023\u0005\t9Q*Z:tC\u001e,\u0007\"\u0002\u001b\u0001\t\u0003)\u0014A\u0004;fgR4\u0016\r\\5e\u0005f$Xm\u001d\u000b\u0002mA\u0011q\u0007O\u0007\u0002Y%\u0011\u0011\b\f\u0002\u0005+:LG\u000f\u000b\u00024wA\u0011AHP\u0007\u0002{)\u00111BD\u0005\u0003\u007fu\u0012A\u0001V3ti\")\u0011\t\u0001C\u0001k\u0005iB/Z:u-\u0006d\u0017\u000e\u001a\"zi\u0016\u001cx+\u001b;i\u0007>l\u0007O]3tg&|g\u000e\u000b\u0002Aw!)A\t\u0001C\u0001k\u0005QA/Z:u\u000bF,\u0018\r\\:)\u0005\r[\u0004\"B$\u0001\t\u0003)\u0014\u0001\u0004;fgRLE/\u001a:bi>\u0014\bF\u0001$<\u0011\u0015Q\u0005\u0001\"\u00016\u0003\u0001\"Xm\u001d;NKN\u001c\u0018mZ3XSRD\u0007K]8wS\u0012,Gm\u00144gg\u0016$8+Z9)\u0005%[\u0004\"B'\u0001\t\u0003q\u0015\u0001D2iK\u000e\\wJ\u001a4tKR\u001cHc\u0001\u001cP!\")\u0011\u0005\u0014a\u0001;!)\u0011\u000b\u0014a\u0001%\u0006Q!-Y:f\u001f\u001a47/\u001a;\u0011\u0005]\u001a\u0016B\u0001+-\u0005\u0011auN\\4\t\u000bY\u0003A\u0011A,\u0002+Y,'/\u001b4z'\"\fG\u000e\\8x\u0013R,'/\u0019;peR\u0011a\u0007\u0017\u0005\u00063V\u0003\r!H\u0001\u000b[\u0016\u001c8/Y4f'\u0016$\b")
public class ByteBufferMessageSetTest
extends JUnitSuite
implements BaseMessageSetTestCases {
    private final Message[] messages;

    @Override
    @Test
    public void testWrittenEqualsRead() {
        BaseMessageSetTestCases.testWrittenEqualsRead$(this);
    }

    @Override
    @Test
    public void testIteratorIsConsistent() {
        BaseMessageSetTestCases.testIteratorIsConsistent$(this);
    }

    @Override
    @Test
    public void testSizeInBytes() {
        BaseMessageSetTestCases.testSizeInBytes$(this);
    }

    @Override
    @Test
    public void testWriteTo() {
        BaseMessageSetTestCases.testWriteTo$(this);
    }

    @Override
    @Test
    public void testWriteToChannelThatConsumesPartially() {
        BaseMessageSetTestCases.testWriteToChannelThatConsumesPartially$(this);
    }

    @Override
    public void checkWriteToWithMessageSet(MessageSet messageSet) {
        BaseMessageSetTestCases.checkWriteToWithMessageSet$(this, messageSet);
    }

    @Override
    public void checkWriteWithMessageSet(MessageSet set, Function1<GatheringByteChannel, Object> write) {
        BaseMessageSetTestCases.checkWriteWithMessageSet$(this, set, write);
    }

    @Override
    public Message[] messages() {
        return this.messages;
    }

    @Override
    public void kafka$message$BaseMessageSetTestCases$_setter_$messages_$eq(Message[] x$1) {
        this.messages = x$1;
    }

    public ByteBufferMessageSet createMessageSet(Seq<Message> messages) {
        return new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, messages);
    }

    @Test
    public void testValidBytes() {
        ByteBufferMessageSet messages = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello".getBytes()), new Message("there".getBytes())}));
        ByteBuffer buffer = ByteBuffer.allocate(messages.sizeInBytes() + 2);
        buffer.put(messages.buffer());
        buffer.putShort((short)4);
        ByteBufferMessageSet messagesPlus = new ByteBufferMessageSet(buffer);
        Assert.assertEquals((String)"Adding invalid bytes shouldn't change byte count", (long)messages.validBytes(), (long)messagesPlus.validBytes());
        Assert.assertEquals((String)"Valid bytes on an empty ByteBufferMessageSet should return 0", (long)0L, (long)MessageSet$.MODULE$.Empty().validBytes());
    }

    @Test
    public void testValidBytesWithCompression() {
        ByteBufferMessageSet messages = new ByteBufferMessageSet((CompressionCodec)DefaultCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello".getBytes()), new Message("there".getBytes())}));
        ByteBuffer buffer = ByteBuffer.allocate(messages.sizeInBytes() + 2);
        buffer.put(messages.buffer());
        buffer.putShort((short)4);
        ByteBufferMessageSet messagesPlus = new ByteBufferMessageSet(buffer);
        Assert.assertEquals((String)"Adding invalid bytes shouldn't change byte count", (long)messages.validBytes(), (long)messagesPlus.validBytes());
    }

    @Test
    public void testEquals() {
        ByteBufferMessageSet messages = new ByteBufferMessageSet((CompressionCodec)DefaultCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello".getBytes()), new Message("there".getBytes())}));
        ByteBufferMessageSet moreMessages = new ByteBufferMessageSet((CompressionCodec)DefaultCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello".getBytes()), new Message("there".getBytes())}));
        Assert.assertTrue((boolean)messages.equals((Object)moreMessages));
        messages = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello".getBytes()), new Message("there".getBytes())}));
        moreMessages = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello".getBytes()), new Message("there".getBytes())}));
        Assert.assertTrue((boolean)messages.equals((Object)moreMessages));
    }

    @Test
    public void testIterator() {
        List messageList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("msg1".getBytes()), new Message("msg2".getBytes()), new Message("msg3".getBytes())}));
        ByteBufferMessageSet messageSet = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)messageList);
        TestUtils$.MODULE$.checkEquals(messageList.iterator(), TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)messageSet.iterator()));
        TestUtils$.MODULE$.checkEquals(messageList.iterator(), TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)messageSet.iterator()));
        TestUtils$.MODULE$.checkEquals(TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)messageSet.shallowIterator()), TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)messageSet.iterator()));
        ByteBufferMessageSet messageSet2 = new ByteBufferMessageSet((CompressionCodec)DefaultCompressionCodec$.MODULE$, (Seq)messageList);
        TestUtils$.MODULE$.checkEquals(messageList.iterator(), TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)messageSet2.iterator()));
        TestUtils$.MODULE$.checkEquals(messageList.iterator(), TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)messageSet2.iterator()));
        this.verifyShallowIterator(messageSet2);
        Nil$ emptyMessageList = Nil$.MODULE$;
        ByteBufferMessageSet emptyMessageSet = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)emptyMessageList);
        ByteBufferMessageSet regularMessgeSet = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)messageList);
        ByteBuffer buffer = ByteBuffer.allocate(emptyMessageSet.buffer().limit() + regularMessgeSet.buffer().limit());
        buffer.put(emptyMessageSet.buffer());
        buffer.put(regularMessgeSet.buffer());
        buffer.rewind();
        ByteBufferMessageSet mixedMessageSet = new ByteBufferMessageSet(buffer);
        TestUtils$.MODULE$.checkEquals(messageList.iterator(), TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)mixedMessageSet.iterator()));
        TestUtils$.MODULE$.checkEquals(messageList.iterator(), TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)mixedMessageSet.iterator()));
        TestUtils$.MODULE$.checkEquals(TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)mixedMessageSet.shallowIterator()), TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)mixedMessageSet.iterator()));
        Nil$ emptyMessageList2 = Nil$.MODULE$;
        ByteBufferMessageSet emptyMessageSet2 = new ByteBufferMessageSet((CompressionCodec)DefaultCompressionCodec$.MODULE$, (Seq)emptyMessageList2);
        ByteBufferMessageSet regularMessgeSet2 = new ByteBufferMessageSet((CompressionCodec)DefaultCompressionCodec$.MODULE$, (Seq)messageList);
        ByteBuffer buffer2 = ByteBuffer.allocate(emptyMessageSet2.buffer().limit() + regularMessgeSet2.buffer().limit());
        buffer2.put(emptyMessageSet2.buffer());
        buffer2.put(regularMessgeSet2.buffer());
        buffer2.rewind();
        ByteBufferMessageSet mixedMessageSet2 = new ByteBufferMessageSet(buffer2);
        TestUtils$.MODULE$.checkEquals(messageList.iterator(), TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)mixedMessageSet2.iterator()));
        TestUtils$.MODULE$.checkEquals(messageList.iterator(), TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)mixedMessageSet2.iterator()));
        this.verifyShallowIterator(mixedMessageSet2);
    }

    @Test
    public void testMessageWithProvidedOffsetSeq() {
        Seq offsets = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 2L}));
        ByteBufferMessageSet messages = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, offsets, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello".getBytes()), new Message("goodbye".getBytes())}));
        Iterator iter = messages.iterator();
        Assert.assertEquals((String)"first offset should be 0", (long)0L, (long)((MessageAndOffset)iter.next()).offset());
        Assert.assertEquals((String)"second offset should be 2", (long)2L, (long)((MessageAndOffset)iter.next()).offset());
    }

    public void checkOffsets(ByteBufferMessageSet messages, long baseOffset) {
        Assert.assertTrue((String)"Message set should not be empty", (boolean)messages.nonEmpty());
        LongRef offset = LongRef.create((long)baseOffset);
        messages.foreach((Function1 & Serializable & scala.Serializable)entry -> {
            ByteBufferMessageSetTest.$anonfun$checkOffsets$1(offset, entry);
            return BoxedUnit.UNIT;
        });
    }

    public void verifyShallowIterator(ByteBufferMessageSet messageSet) {
        Set shallowOffsets = messageSet.shallowIterator().map((Function1 & Serializable & scala.Serializable)msgAndOff -> BoxesRunTime.boxToLong((long)msgAndOff.offset())).toSet();
        Set deepOffsets = messageSet.iterator().map((Function1 & Serializable & scala.Serializable)msgAndOff -> BoxesRunTime.boxToLong((long)msgAndOff.offset())).toSet();
        Assert.assertTrue((boolean)shallowOffsets.subsetOf((GenSet)deepOffsets));
    }

    public static final /* synthetic */ void $anonfun$checkOffsets$1(LongRef offset$1, MessageAndOffset entry) {
        Assert.assertEquals((String)"Unexpected offset in message set iterator", (long)offset$1.elem, (long)entry.offset());
        ++offset$1.elem;
    }

    public ByteBufferMessageSetTest() {
        BaseMessageSetTestCases.$init$(this);
    }
}

