/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public final class SimpleFileLogFormatter
extends Formatter {
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss.SSSZ");

    private synchronized String ts(Date date) {
        return this.formatter.format(date);
    }

    private String classNameOnly(String name) {
        int index = name.lastIndexOf(46) + 1;
        return name.substring(index);
    }

    @Override
    public String format(LogRecord record) {
        StringWriter sw = new StringWriter();
        try (PrintWriter pw = new PrintWriter(sw);){
            pw.print(this.ts(new Date(record.getMillis())));
            pw.print(' ');
            pw.print(record.getLevel().getName());
            pw.print(" t");
            pw.print(record.getThreadID());
            pw.print(' ');
            pw.print(this.classNameOnly(record.getSourceClassName()));
            pw.print('.');
            pw.print(record.getSourceMethodName());
            pw.print(": ");
            pw.print(this.formatMessage(record));
            pw.println();
            Throwable thrown = record.getThrown();
            if (thrown != null) {
                thrown.printStackTrace(pw);
            }
        }
        return sw.toString();
    }
}

