/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.history;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.history.Annotation;
import org.opensolaris.opengrok.history.ClearCaseHistoryParser;
import org.opensolaris.opengrok.history.History;
import org.opensolaris.opengrok.history.HistoryException;
import org.opensolaris.opengrok.history.Repository;
import org.opensolaris.opengrok.util.Executor;
import org.opensolaris.opengrok.util.IOUtils;

public class ClearCaseRepository
extends Repository {
    private static final long serialVersionUID = 1L;
    public static final String CMD_PROPERTY_KEY = "org.opensolaris.opengrok.history.ClearCase";
    public static final String CMD_FALLBACK = "cleartool";
    private boolean verbose;
    private static final ClearCaseRepository testRepo = new ClearCaseRepository();

    public ClearCaseRepository() {
        this.type = "ClearCase";
        this.datePattern = "yyyyMMdd.HHmmss";
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    Executor getHistoryLogExecutor(File file) throws IOException {
        String abs = file.getCanonicalPath();
        String filename = "";
        if (abs.length() > this.directoryName.length()) {
            filename = abs.substring(this.directoryName.length() + 1);
        }
        ArrayList<String> cmd = new ArrayList<String>();
        this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
        cmd.add(this.cmd);
        cmd.add("lshistory");
        if (file.isDirectory()) {
            cmd.add("-dir");
        }
        cmd.add("-fmt");
        cmd.add("%e\n%Nd\n%Fu (%u)\n%Vn\n%Nc\n.\n");
        cmd.add(filename);
        return new Executor(cmd, new File(this.getDirectoryName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getHistoryGet(String parent, String basename, String rev) {
        BufferedInputStream ret = null;
        File directory = new File(this.directoryName);
        Process process = null;
        try {
            String filename = new File(parent, basename).getCanonicalPath().substring(this.directoryName.length() + 1);
            final File tmp = File.createTempFile("opengrok", "tmp");
            String tmpName = tmp.getCanonicalPath();
            if (tmp.exists() && !tmp.delete()) {
                OpenGrokLogger.getLogger().log(Level.WARNING, "Failed to remove temporary file used by history cache");
            }
            String decorated = filename + "@@" + rev;
            this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
            String[] argv = new String[]{this.cmd, "get", "-to", tmpName, decorated};
            process = Runtime.getRuntime().exec(argv, null, directory);
            ClearCaseRepository.drainStream(process.getInputStream());
            if (this.waitFor(process) != 0) {
                InputStream inputStream = null;
                return inputStream;
            }
            ret = new BufferedInputStream(new FileInputStream(tmp)){

                @Override
                public void close() throws IOException {
                    super.close();
                    if (!tmp.delete()) {
                        tmp.deleteOnExit();
                    }
                }
            };
        }
        catch (Exception exp) {
            OpenGrokLogger.getLogger().log(Level.SEVERE, "Failed to get history: " + exp.getClass().toString(), exp);
        }
        finally {
            if (process != null) {
                try {
                    process.exitValue();
                }
                catch (IllegalThreadStateException exp) {
                    process.destroy();
                }
            }
        }
        return ret;
    }

    private static void drainStream(InputStream in) throws IOException {
        long skipped;
        do {
            skipped = 0L;
            try {
                skipped = in.skip(32768L);
            }
            catch (IOException ioe) {
                OpenGrokLogger.getLogger().log(Level.FINEST, "Stream not seekable", ioe);
            }
        } while (skipped != 0L || in.read() != -1);
        IOUtils.close(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Annotation annotate(File file, String revision) throws IOException {
        ArrayList<String> argv = new ArrayList<String>();
        this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
        argv.add(this.cmd);
        argv.add("annotate");
        argv.add("-nheader");
        argv.add("-out");
        argv.add("-");
        argv.add("-f");
        argv.add("-fmt");
        argv.add("%u|%Vn|");
        if (revision != null) {
            argv.add(revision);
        }
        argv.add(file.getName());
        ProcessBuilder pb = new ProcessBuilder(argv);
        pb.directory(file.getParentFile());
        Process process = null;
        try {
            process = pb.start();
            Annotation a = new Annotation(file.getName());
            try (BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = in.readLine()) != null) {
                    String[] parts = line.split("\\|");
                    String aAuthor = parts[0];
                    String aRevision = parts[1];
                    aRevision = aRevision.replace('\\', '/');
                    a.addLine(aRevision, aAuthor, true);
                }
            }
            Annotation annotation = a;
            return annotation;
        }
        finally {
            if (process != null) {
                try {
                    process.exitValue();
                }
                catch (IllegalThreadStateException e) {
                    process.destroy();
                }
            }
        }
    }

    @Override
    public boolean fileHasAnnotation(File file) {
        return true;
    }

    private int waitFor(Process process) {
        while (true) {
            try {
                return process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update() throws IOException {
        block44: {
            Process process = null;
            try {
                String line;
                File directory = new File(this.getDirectoryName());
                this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
                String[] argv = new String[]{this.cmd, "catcs"};
                process = Runtime.getRuntime().exec(argv, null, directory);
                boolean snapshot = false;
                try (BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    while (!snapshot && (line = in.readLine()) != null) {
                        snapshot = line.startsWith("load");
                    }
                    if (this.waitFor(process) != 0) {
                        return;
                    }
                }
                if (!snapshot) break block44;
                this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
                argv = new String[]{this.cmd, "update", "-overwrite", "-f"};
                process = Runtime.getRuntime().exec(argv, null, directory);
                in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                var7_8 = null;
                try {
                    while ((line = in.readLine()) != null) {
                    }
                }
                catch (Throwable throwable) {
                    var7_8 = throwable;
                    throw throwable;
                }
                finally {
                    if (in != null) {
                        if (var7_8 != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable) {
                                var7_8.addSuppressed(throwable);
                            }
                        } else {
                            in.close();
                        }
                    }
                }
                if (this.waitFor(process) != 0) {
                    return;
                }
            }
            finally {
                if (process != null) {
                    try {
                        process.exitValue();
                    }
                    catch (IllegalThreadStateException e) {
                        process.destroy();
                    }
                }
            }
        }
    }

    @Override
    public boolean fileHasHistory(File file) {
        return true;
    }

    @Override
    public boolean isWorking() {
        if (this.working == null) {
            this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
            this.working = ClearCaseRepository.checkCmd(this.cmd, "-version");
        }
        return this.working;
    }

    @Override
    boolean isRepositoryFor(File file) {
        File f = new File(file, "view.dat");
        if (f.exists()) {
            return true;
        }
        if (file.isDirectory() && file.getName().equalsIgnoreCase("vobs")) {
            return true;
        }
        if (this.isWorking()) {
            try {
                String canonicalPath = file.getCanonicalPath();
                for (String vob : ClearCaseRepository.getAllVobs()) {
                    if (!canonicalPath.equalsIgnoreCase(vob)) continue;
                    return true;
                }
            }
            catch (IOException e) {
                OpenGrokLogger.getLogger().log(Level.WARNING, "Could not get canonical path for \"" + file + "\"", e);
            }
        }
        return false;
    }

    private static String[] getAllVobs() {
        return VobsHolder.vobs;
    }

    private static String[] runLsvob() {
        if (testRepo.isWorking()) {
            Executor exec = new Executor(new String[]{ClearCaseRepository.testRepo.cmd, "lsvob", "-s"});
            int rc = exec.exec(true);
            if (rc == 0) {
                String output = exec.getOutputString();
                if (output == null) {
                    OpenGrokLogger.getLogger().log(Level.SEVERE, "\"cleartool lsvob -s\" output was null");
                    return new String[0];
                }
                String sep = System.getProperty("line.separator");
                String[] vobs = output.split(Pattern.quote(sep));
                OpenGrokLogger.getLogger().log(Level.CONFIG, "Found VOBs: {0}", Arrays.asList(vobs));
                return vobs;
            }
            OpenGrokLogger.getLogger().log(Level.SEVERE, "\"cleartool lsvob -s\" returned non-zero status: " + rc);
        }
        return new String[0];
    }

    @Override
    boolean hasHistoryForDirectories() {
        return true;
    }

    @Override
    History getHistory(File file) throws HistoryException {
        return new ClearCaseHistoryParser().parse(file, this);
    }

    static /* synthetic */ String[] access$000() {
        return ClearCaseRepository.runLsvob();
    }

    private static class VobsHolder {
        public static String[] vobs = ClearCaseRepository.access$000();

        private VobsHolder() {
        }
    }
}

