/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.aqua;

import apple.laf.AquaImageFactory;
import com.jidesoft.icons.IconsFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicPainter;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import sun.java2d.SunGraphics2D;

public class AquaPainter
extends BasicPainter {
    private static final Logger LOGGER = Logger.getLogger(AquaPainter.class.getName());
    private static AquaPainter _instance;
    private static final ImageIcon SELECTED;
    private static final ImageIcon ROLLOVER;
    private static final ImageIcon PRESSED;
    private static final Color ROLLOVER_BACKGROUND;
    private static final Color SELECTED_BACKGROUND;
    private static final Color PRESSED_BACKGROUND;
    private static boolean _errorOccurred;

    public static ThemePainter getInstance() {
        if (_instance == null) {
            _instance = new AquaPainter();
        }
        return _instance;
    }

    @Override
    public Color getCommandBarTitleBarBackground() {
        return UIDefaultsLookup.getColor("JideButton.background");
    }

    @Override
    public void paintButtonBackground(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        if (state == 0) {
            super.paintButtonBackground(c, g, rect, orientation, state);
        } else if (state == 2) {
            this.paintImageBorder(g, rect, ROLLOVER, ROLLOVER_BACKGROUND);
        } else if (state == 3) {
            this.paintImageBorder(g, rect, SELECTED, SELECTED_BACKGROUND);
        } else if (state == 1) {
            this.paintImageBorder(g, rect, PRESSED, PRESSED_BACKGROUND);
        }
    }

    private void paintImageBorder(Graphics g, Rectangle rect, ImageIcon icon, Color background) {
        JideSwingUtilities.drawImageBorder(g, icon, rect, new Insets(3, 3, 3, 3), false);
        if (background != null) {
            Color oldColor = g.getColor();
            g.setColor(background);
            g.fillRect(rect.x + 3, rect.y + 3, rect.width - 6, rect.height - 6);
            g.setColor(oldColor);
        }
    }

    @Override
    public void paintCollapsiblePaneTitlePaneBackgroundEmphasized(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        if (!_errorOccurred) {
            try {
                AquaImageFactory.drawFrameTitleBackground((SunGraphics2D)((SunGraphics2D)g), (int)rect.x, (int)rect.y, (int)rect.width, (int)rect.height, (boolean)true, (boolean)false, (boolean)false);
                return;
            }
            catch (Exception e) {
                _errorOccurred = true;
                LOGGER.warning(e.getLocalizedMessage());
            }
        }
        super.paintCollapsiblePaneTitlePaneBackgroundEmphasized(c, g, rect, orientation, state);
    }

    @Override
    public void paintCollapsiblePaneTitlePaneBackground(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        if (!_errorOccurred) {
            try {
                AquaImageFactory.drawFrameTitleBackground((SunGraphics2D)((SunGraphics2D)g), (int)rect.x, (int)rect.y, (int)rect.width, (int)rect.height, (boolean)false, (boolean)false, (boolean)false);
                return;
            }
            catch (Exception e) {
                _errorOccurred = true;
                LOGGER.warning(e.getLocalizedMessage());
            }
        }
        super.paintCollapsiblePaneTitlePaneBackground(c, g, rect, orientation, state);
    }

    @Override
    public void paintDockableFrameTitlePane(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        if (!_errorOccurred) {
            try {
                AquaImageFactory.drawFrameTitleBackground((SunGraphics2D)((SunGraphics2D)g), (int)rect.x, (int)rect.y, (int)rect.width, (int)rect.height, (state == 3 ? 1 : 0) != 0, (boolean)false, (boolean)false);
                return;
            }
            catch (Exception e) {
                _errorOccurred = true;
                LOGGER.warning(e.getLocalizedMessage());
            }
        }
        super.paintDockableFrameTitlePane(c, g, rect, orientation, state);
    }

    @Override
    public void paintCommandBarTitlePane(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        if (!_errorOccurred) {
            try {
                AquaImageFactory.drawFrameTitleBackground((SunGraphics2D)((SunGraphics2D)g), (int)rect.x, (int)rect.y, (int)rect.width, (int)rect.height, (boolean)true, (boolean)false, (boolean)false);
                return;
            }
            catch (Exception e) {
                _errorOccurred = true;
                LOGGER.warning(e.getLocalizedMessage());
            }
        }
        super.paintCommandBarTitlePane(c, g, rect, orientation, state);
    }

    static {
        SELECTED = IconsFactory.getImageIcon(AquaPainter.class, "icons/selected.gif");
        ROLLOVER = IconsFactory.getImageIcon(AquaPainter.class, "icons/rollover.gif");
        PRESSED = IconsFactory.getImageIcon(AquaPainter.class, "icons/pressed.gif");
        ROLLOVER_BACKGROUND = new Color(238, 238, 238);
        SELECTED_BACKGROUND = new Color(153, 153, 153);
        PRESSED_BACKGROUND = new Color(195, 195, 195);
    }
}

