/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph.xmlbeans;

import java.util.ArrayList;
import net.sourceforge.squirrel_sql.plugins.graph.Mode;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.ColumnInfoXmlBean;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.ConstraintDataXmlBean;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.ConstraintViewXmlBean;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.GraphControllerXmlBean;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.TableFrameControllerXmlBean;

public class Version32Converter {
    public static void convert(GraphControllerXmlBean ret) {
        if (ret.is32Converted()) {
            return;
        }
        if (Mode.DEFAULT == Mode.getForIndex(ret.getModeIndex()) && ret.getZoomerXmlBean().isEnabled()) {
            ret.setModeIndex(Mode.ZOOM_PRINT.getIndex());
        }
        for (TableFrameControllerXmlBean tfcXml : ret.getTableFrameControllerXmls()) {
            ArrayList<ConstraintViewXmlBean> remainConstXmls = new ArrayList<ConstraintViewXmlBean>();
            for (ConstraintViewXmlBean constXml : tfcXml.getConstraintViewXmlBeans()) {
                ConstraintDataXmlBean constDataXml = constXml.getConstraintDataXmlBean();
                ColumnInfoXmlBean[] pkCols = Version32Converter.getPkColumnsFor(constDataXml, ret);
                if (null == pkCols) continue;
                constDataXml.setPkColumns(Version32Converter.cleanColInfos(pkCols));
                constDataXml.setFkColumns(Version32Converter.cleanColInfos(constDataXml.getColumnInfoXmlBeans()));
                constDataXml.setColumnInfoXmlBeans(null);
                constXml.setConstraintDataXmlBean(constDataXml);
                remainConstXmls.add(constXml);
            }
            tfcXml.setConstraintViewXmlBeans(remainConstXmls.toArray(new ConstraintViewXmlBean[remainConstXmls.size()]));
        }
        for (TableFrameControllerXmlBean tfcXml : ret.getTableFrameControllerXmls()) {
            Version32Converter.cleanColInfos(tfcXml.getColumnIfoXmlBeans());
        }
    }

    private static ColumnInfoXmlBean[] getPkColumnsFor(ConstraintDataXmlBean constDataXml, GraphControllerXmlBean graphXml) {
        ColumnInfoXmlBean[] colXmls = constDataXml.getColumnInfoXmlBeans();
        ColumnInfoXmlBean[] ret = new ColumnInfoXmlBean[colXmls.length];
        for (int i = 0; i < colXmls.length; ++i) {
            ret[i] = Version32Converter.findCol(colXmls[i].getImportedFromTable(), colXmls[i].getImportedColumn(), graphXml.getTableFrameControllerXmls());
            if (null != ret[i]) continue;
            return null;
        }
        return ret;
    }

    private static ColumnInfoXmlBean findCol(String importedFromTable, String importedColumn, TableFrameControllerXmlBean[] tableFrameControllerXmls) {
        for (TableFrameControllerXmlBean tfcXml : tableFrameControllerXmls) {
            if (!tfcXml.getTablename().equalsIgnoreCase(importedFromTable)) continue;
            for (ColumnInfoXmlBean colXml : tfcXml.getColumnIfoXmlBeans()) {
                if (!colXml.getColumnName().equalsIgnoreCase(importedColumn)) continue;
                return colXml;
            }
        }
        return null;
    }

    private static ColumnInfoXmlBean[] cleanColInfos(ColumnInfoXmlBean[] colXmls) {
        for (ColumnInfoXmlBean colXml : colXmls) {
            if (!colXml.isNonDbConstraint()) continue;
            colXml.setImportedColumn(null);
            colXml.setImportedFromTable(null);
            colXml.setConstraintName(null);
        }
        return colXmls;
    }

    public static void markConverted(GraphControllerXmlBean xmlBean) {
        xmlBean.set32Converted(true);
    }
}

