/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.utils.StreamingHistogram;

public class ColumnStats {
    public final int columnCount;
    public final long minTimestamp;
    public final long maxTimestamp;
    public final int maxLocalDeletionTime;
    public final StreamingHistogram tombstoneHistogram;
    public final List<ByteBuffer> minColumnNames;
    public final List<ByteBuffer> maxColumnNames;
    public final boolean hasLegacyCounterShards;

    public ColumnStats(int columnCount, long minTimestamp, long maxTimestamp, int maxLocalDeletionTime, StreamingHistogram tombstoneHistogram, List<ByteBuffer> minColumnNames, List<ByteBuffer> maxColumnNames, boolean hasLegacyCounterShards) {
        this.minTimestamp = minTimestamp;
        this.maxTimestamp = maxTimestamp;
        this.maxLocalDeletionTime = maxLocalDeletionTime;
        this.columnCount = columnCount;
        this.tombstoneHistogram = tombstoneHistogram;
        this.minColumnNames = minColumnNames;
        this.maxColumnNames = maxColumnNames;
        this.hasLegacyCounterShards = hasLegacyCounterShards;
    }

    public static class MaxIntTracker {
        private final int defaultValue;
        private boolean isSet = false;
        private int value;

        public MaxIntTracker(int defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void update(int value) {
            if (!this.isSet) {
                this.value = value;
                this.isSet = true;
            } else if (value > this.value) {
                this.value = value;
            }
        }

        public int get() {
            if (this.isSet) {
                return this.value;
            }
            return this.defaultValue;
        }
    }

    public static class MaxLongTracker {
        private final long defaultValue;
        private boolean isSet = false;
        private long value;

        public MaxLongTracker(long defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void update(long value) {
            if (!this.isSet) {
                this.value = value;
                this.isSet = true;
            } else if (value > this.value) {
                this.value = value;
            }
        }

        public long get() {
            if (this.isSet) {
                return this.value;
            }
            return this.defaultValue;
        }
    }

    public static class MinLongTracker {
        private final long defaultValue;
        private boolean isSet = false;
        private long value;

        public MinLongTracker(long defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void update(long value) {
            if (!this.isSet) {
                this.value = value;
                this.isSet = true;
            } else if (value < this.value) {
                this.value = value;
            }
        }

        public long get() {
            if (this.isSet) {
                return this.value;
            }
            return this.defaultValue;
        }
    }
}

