/*
 * Decompiled with CFR 0.152.
 */
package com.gokgs.client.swing;

import com.gokgs.client.KCGame;
import com.gokgs.client.swing.KGamePanel;
import com.gokgs.shared.KRole;
import java.awt.BorderLayout;
import java.awt.Color;
import javax.swing.JCheckBox;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.igoweb.go.Game;
import org.igoweb.go.swing.GameLayout;
import org.igoweb.go.swing.GamePanel;
import org.igoweb.go.swing.GameWindow;
import org.igoweb.igoweb.shared.Role;
import org.igoweb.util.Defs;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;
import org.igoweb.util.swing.AFrame;
import org.igoweb.util.swing.Errout;
import org.igoweb.util.swing.Prefs;

public class KSimulWindow
extends GameWindow {
    private final String AUTO_NEXT_PREF = "ng,<[MI{";
    private final JTabbedPane tabPane = new JTabbedPane();
    private final JCheckBox skipIn = new JCheckBox(Defs.getString(-903340818));
    private boolean skipDelayed = false;

    public KSimulWindow(AFrame parent, KGamePanel gameP) {
        super(-903340719, parent, null);
        this.setTitle(Defs.getString(-903340816));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(this.tabPane);
        this.getContentPane().add("South", this.skipIn);
        this.tabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                KSimulWindow.this.skipDelayed = false;
            }
        });
        this.skipIn.setSelected(Prefs.getBoolean("ng,<[MI{", false));
        this.skipIn.setBorderPainted(true);
        this.skipIn.setBorderPaintedFlat(false);
        this.addGame(gameP);
        this.pack();
        this.setVisible(true);
    }

    public void addGame(KGamePanel gamePanel) {
        KCGame cGame = gamePanel.getCGame();
        gamePanel.setLayout(new GameLayout(gamePanel));
        this.tabPane.add(cGame.getPlayer((Role)KRole.opponent((Role)cGame.getRole())).name, gamePanel);
        this.addListeners(gamePanel);
    }

    @Override
    public void setGamePanel(GamePanel rawOldGamePanel, GamePanel rawNewGamePanel) {
        KGamePanel newGamePanel = (KGamePanel)rawNewGamePanel;
        if (rawOldGamePanel == null) {
            if (newGamePanel != null) {
                this.addGame(newGamePanel);
            }
        } else {
            KGamePanel oldGamePanel = (KGamePanel)rawOldGamePanel;
            oldGamePanel.removeListener(this.getListener());
            this.tabPane.setComponentAt(this.tabPane.indexOfComponent(oldGamePanel), newGamePanel);
            this.addListeners(newGamePanel);
            this.validate();
        }
    }

    private void addListeners(final KGamePanel gamePanel) {
        gamePanel.addListener(this.getListener());
        gamePanel.getGame().addListener(new EventListener(){

            @Override
            public void handleEvent(Event event) {
                if (event.type != 4) {
                    KSimulWindow.this.recolorTab(gamePanel);
                }
            }
        });
        gamePanel.getCGame().addListener(new EventListener(){

            @Override
            public void handleEvent(Event event) {
                if (event.type == 40) {
                    KSimulWindow.this.recolorTab(gamePanel);
                }
            }
        });
        this.recolorTab(gamePanel);
    }

    private void recolorTab(KGamePanel gamePanel) {
        int myIndex = this.tabPane.indexOfComponent(gamePanel);
        if (myIndex == -1) {
            return;
        }
        KCGame cGame = gamePanel.getCGame();
        if (!cGame.isJoined()) {
            return;
        }
        Role myRole = cGame.getRole();
        Game game = gamePanel.getGame();
        boolean isSelected = !cGame.isOver() && (myRole == KRole.BLACK || myRole == KRole.WHITE) && (game.isPlayOver() && cGame.isDoneSent(myRole.team) || game.getWhoseMove() == myRole.team);
        Color selColor = UIManager.getColor("org.igoweb.selTextBg");
        boolean wasSelected = selColor.equals(this.tabPane.getBackgroundAt(myIndex));
        this.tabPane.setBackgroundAt(myIndex, isSelected ? selColor : null);
        int curIndex = this.tabPane.getSelectedIndex();
        if (isSelected && this.skipDelayed) {
            if (myIndex != curIndex) {
                this.tabPane.setSelectedIndex(myIndex);
            }
            this.skipDelayed = false;
            return;
        }
        if (!isSelected && wasSelected && myIndex == curIndex && this.skipIn.isSelected()) {
            this.skipDelayed = false;
            int totalTabs = this.tabPane.getTabCount();
            int i = myIndex + 1;
            while (true) {
                if (i == totalTabs) {
                    i = 0;
                }
                if (i == myIndex) {
                    this.skipDelayed = true;
                    return;
                }
                if (selColor.equals(this.tabPane.getBackgroundAt(i))) {
                    this.tabPane.setSelectedIndex(i);
                    return;
                }
                ++i;
            }
        }
    }

    @Override
    protected void closePressed() {
        int i;
        for (i = this.tabPane.getTabCount() - 1; i >= 0; --i) {
            KGamePanel panel = (KGamePanel)this.tabPane.getComponentAt(i);
            if (panel.getGame().isPlayOver() || panel.getCGame().isOver()) continue;
            new Errout(Defs.getString(-903340788), this);
            return;
        }
        for (i = this.tabPane.getTabCount() - 1; i >= 0; --i) {
            ((KGamePanel)this.tabPane.getComponentAt(i)).closePressed();
        }
    }

    @Override
    protected void retitle(Object title) {
    }

    @Override
    protected void gameClosed(GamePanel gamePanel) {
        if (this.tabPane.indexOfComponent(gamePanel) >= 0) {
            if (this.tabPane.getTabCount() == 1) {
                this.dispose();
            } else {
                this.tabPane.remove(gamePanel);
            }
        }
    }

    @Override
    public void dispose() {
        if (this.skipIn != null) {
            Prefs.putBoolean("ng,<[MI{", this.skipIn.isSelected());
        }
        super.dispose();
    }
}

