require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_AARCH64_ARMREG_H_)) {
    eval 'sub _AARCH64_ARMREG_H_ () {1;}' unless defined(&_AARCH64_ARMREG_H_);
    require 'arm/cputypes.ph';
    require 'sys/types.ph';
    eval 'sub AARCH64REG_READ_INLINE2 {
        my($regname, $regdesc) = @_;
	    eval q( &static  &__inline  &uint64_t  &reg_$regname &_read( &void) {  &uint64_t  &__rv;  &__asm  &__volatile(\\"mrs %0, \\" $regdesc : \\"=r\\"( &__rv));  &return  &__rv; });
    }' unless defined(&AARCH64REG_READ_INLINE2);
    eval 'sub AARCH64REG_WRITE_INLINE2 {
        my($regname, $regdesc) = @_;
	    eval q( &static  &__inline  &void  &reg_$regname &_write( &uint64_t  &__val) {  &__asm  &__volatile(\\"msr \\" $regdesc \\", %0\\" :: \\"r\\"( &__val)); });
    }' unless defined(&AARCH64REG_WRITE_INLINE2);
    eval 'sub AARCH64REG_WRITEIMM_INLINE2 {
        my($regname, $regdesc) = @_;
	    eval q( &static  &__inline  &void  &reg_$regname &_write( &uint64_t  &__val) {  &__asm  &__volatile(\\"msr \\" $regdesc \\", %0\\" :: \\"n\\"( &__val)); });
    }' unless defined(&AARCH64REG_WRITEIMM_INLINE2);
    eval 'sub AARCH64REG_READ_INLINE {
        my($regname) = @_;
	    eval q( &AARCH64REG_READ_INLINE2($regname, $regname));
    }' unless defined(&AARCH64REG_READ_INLINE);
    eval 'sub AARCH64REG_WRITE_INLINE {
        my($regname) = @_;
	    eval q( &AARCH64REG_WRITE_INLINE2($regname, $regname));
    }' unless defined(&AARCH64REG_WRITE_INLINE);
    eval 'sub AARCH64REG_WRITEIMM_INLINE {
        my($regname) = @_;
	    eval q( &AARCH64REG_WRITEIMM_INLINE2($regname, $regname));
    }' unless defined(&AARCH64REG_WRITEIMM_INLINE);
    eval 'sub AARCH64REG_READWRITE_INLINE2 {
        my($regname, $regdesc) = @_;
	    eval q( &AARCH64REG_READ_INLINE2($regname, $regdesc)  &AARCH64REG_WRITE_INLINE2($regname, $regdesc));
    }' unless defined(&AARCH64REG_READWRITE_INLINE2);
    eval 'sub AARCH64REG_ATWRITE_INLINE2 {
        my($regname, $regdesc) = @_;
	    eval q( &static  &__inline  &void  &reg_$regname &_write( &uint64_t  &__val) {  &__asm  &__volatile(\\"at \\" $regdesc \\", %0\\" :: \\"r\\"( &__val)); });
    }' unless defined(&AARCH64REG_ATWRITE_INLINE2);
    eval 'sub AARCH64REG_ATWRITE_INLINE {
        my($regname) = @_;
	    eval q( &AARCH64REG_ATWRITE_INLINE2($regname, $regname));
    }' unless defined(&AARCH64REG_ATWRITE_INLINE);
    eval 'sub CTR_EL0_CWG_LINE () { &__BITS(27,24);}' unless defined(&CTR_EL0_CWG_LINE);
    eval 'sub CTR_EL0_ERG_LINE () { &__BITS(23,20);}' unless defined(&CTR_EL0_ERG_LINE);
    eval 'sub CTR_EL0_DMIN_LINE () { &__BITS(19,16);}' unless defined(&CTR_EL0_DMIN_LINE);
    eval 'sub CTR_EL0_L1IP_MASK () { &__BITS(15,14);}' unless defined(&CTR_EL0_L1IP_MASK);
    eval 'sub CTR_EL0_L1IP_AIVIVT () {1;}' unless defined(&CTR_EL0_L1IP_AIVIVT);
    eval 'sub CTR_EL0_L1IP_VIPT () {2;}' unless defined(&CTR_EL0_L1IP_VIPT);
    eval 'sub CTR_EL0_L1IP_PIPT () {3;}' unless defined(&CTR_EL0_L1IP_PIPT);
    eval 'sub CTR_EL0_IMIN_LINE () { &__BITS(3,0);}' unless defined(&CTR_EL0_IMIN_LINE);
    eval 'sub DCZID_DZP () { &__BIT(4);}' unless defined(&DCZID_DZP);
    eval 'sub DCZID_BS () { &__BITS(3,0);}' unless defined(&DCZID_BS);
    eval 'sub FPCR_AHP () { &__BIT(26);}' unless defined(&FPCR_AHP);
    eval 'sub FPCR_DN () { &__BIT(25);}' unless defined(&FPCR_DN);
    eval 'sub FPCR_FZ () { &__BIT(24);}' unless defined(&FPCR_FZ);
    eval 'sub FPCR_RMODE () { &__BITS(23,22);}' unless defined(&FPCR_RMODE);
    eval 'sub FPCR_RN () {0;}' unless defined(&FPCR_RN);
    eval 'sub FPCR_RP () {1;}' unless defined(&FPCR_RP);
    eval 'sub FPCR_RM () {2;}' unless defined(&FPCR_RM);
    eval 'sub FPCR_RZ () {3;}' unless defined(&FPCR_RZ);
    eval 'sub FPCR_STRIDE () { &__BITS(21,20);}' unless defined(&FPCR_STRIDE);
    eval 'sub FPCR_FZ16 () { &__BIT(19);}' unless defined(&FPCR_FZ16);
    eval 'sub FPCR_LEN () { &__BITS(18,16);}' unless defined(&FPCR_LEN);
    eval 'sub FPCR_IDE () { &__BIT(15);}' unless defined(&FPCR_IDE);
    eval 'sub FPCR_IXE () { &__BIT(12);}' unless defined(&FPCR_IXE);
    eval 'sub FPCR_UFE () { &__BIT(11);}' unless defined(&FPCR_UFE);
    eval 'sub FPCR_OFE () { &__BIT(10);}' unless defined(&FPCR_OFE);
    eval 'sub FPCR_DZE () { &__BIT(9);}' unless defined(&FPCR_DZE);
    eval 'sub FPCR_IOE () { &__BIT(8);}' unless defined(&FPCR_IOE);
    eval 'sub FPCR_ESUM () {0x1f00;}' unless defined(&FPCR_ESUM);
    eval 'sub FPSR_N32 () { &__BIT(31);}' unless defined(&FPSR_N32);
    eval 'sub FPSR_Z32 () { &__BIT(30);}' unless defined(&FPSR_Z32);
    eval 'sub FPSR_C32 () { &__BIT(29);}' unless defined(&FPSR_C32);
    eval 'sub FPSR_V32 () { &__BIT(28);}' unless defined(&FPSR_V32);
    eval 'sub FPSR_QC () { &__BIT(27);}' unless defined(&FPSR_QC);
    eval 'sub FPSR_IDC () { &__BIT(7);}' unless defined(&FPSR_IDC);
    eval 'sub FPSR_IXC () { &__BIT(4);}' unless defined(&FPSR_IXC);
    eval 'sub FPSR_UFC () { &__BIT(3);}' unless defined(&FPSR_UFC);
    eval 'sub FPSR_OFC () { &__BIT(2);}' unless defined(&FPSR_OFC);
    eval 'sub FPSR_DZC () { &__BIT(1);}' unless defined(&FPSR_DZC);
    eval 'sub FPSR_IOC () { &__BIT(0);}' unless defined(&FPSR_IOC);
    eval 'sub FPSR_CSUM () {0x1f;}' unless defined(&FPSR_CSUM);
    eval 'sub NZCV_N () { &__BIT(31);}' unless defined(&NZCV_N);
    eval 'sub NZCV_Z () { &__BIT(30);}' unless defined(&NZCV_Z);
    eval 'sub NZCV_C () { &__BIT(29);}' unless defined(&NZCV_C);
    eval 'sub NZCV_V () { &__BIT(28);}' unless defined(&NZCV_V);
    eval 'sub CBAR_PA () { &__BITS(47,18);}' unless defined(&CBAR_PA);
    eval 'sub CCSIDR_WT () { &__BIT(31);}' unless defined(&CCSIDR_WT);
    eval 'sub CCSIDR_WB () { &__BIT(30);}' unless defined(&CCSIDR_WB);
    eval 'sub CCSIDR_RA () { &__BIT(29);}' unless defined(&CCSIDR_RA);
    eval 'sub CCSIDR_WA () { &__BIT(28);}' unless defined(&CCSIDR_WA);
    eval 'sub CCSIDR_NUMSET () { &__BITS(27,13);}' unless defined(&CCSIDR_NUMSET);
    eval 'sub CCSIDR_ASSOC () { &__BITS(12,3);}' unless defined(&CCSIDR_ASSOC);
    eval 'sub CCSIDR_LINESIZE () { &__BITS(2,0);}' unless defined(&CCSIDR_LINESIZE);
    eval 'sub CLIDR_LOUU () { &__BITS(29,27);}' unless defined(&CLIDR_LOUU);
    eval 'sub CLIDR_LOC () { &__BITS(26,24);}' unless defined(&CLIDR_LOC);
    eval 'sub CLIDR_LOUIS () { &__BITS(23,21);}' unless defined(&CLIDR_LOUIS);
    eval 'sub CLIDR_CTYPE7 () { &__BITS(20,18);}' unless defined(&CLIDR_CTYPE7);
    eval 'sub CLIDR_CTYPE6 () { &__BITS(17,15);}' unless defined(&CLIDR_CTYPE6);
    eval 'sub CLIDR_CTYPE5 () { &__BITS(14,12);}' unless defined(&CLIDR_CTYPE5);
    eval 'sub CLIDR_CTYPE4 () { &__BITS(11,9);}' unless defined(&CLIDR_CTYPE4);
    eval 'sub CLIDR_CTYPE3 () { &__BITS(8,6);}' unless defined(&CLIDR_CTYPE3);
    eval 'sub CLIDR_CTYPE2 () { &__BITS(5,3);}' unless defined(&CLIDR_CTYPE2);
    eval 'sub CLIDR_CTYPE1 () { &__BITS(2,0);}' unless defined(&CLIDR_CTYPE1);
    eval 'sub CLIDR_TYPE_NOCACHE () {0;}' unless defined(&CLIDR_TYPE_NOCACHE);
    eval 'sub CLIDR_TYPE_ICACHE () {1;}' unless defined(&CLIDR_TYPE_ICACHE);
    eval 'sub CLIDR_TYPE_DCACHE () {2;}' unless defined(&CLIDR_TYPE_DCACHE);
    eval 'sub CLIDR_TYPE_IDCACHE () {3;}' unless defined(&CLIDR_TYPE_IDCACHE);
    eval 'sub CLIDR_TYPE_UNIFIEDCACHE () {4;}' unless defined(&CLIDR_TYPE_UNIFIEDCACHE);
    eval 'sub ID_AA64DFR0_EL1_CTX_CMPS () { &__BITS(31,28);}' unless defined(&ID_AA64DFR0_EL1_CTX_CMPS);
    eval 'sub ID_AA64DFR0_EL1_WRPS () { &__BITS(20,23);}' unless defined(&ID_AA64DFR0_EL1_WRPS);
    eval 'sub ID_AA64DFR0_EL1_BRPS () { &__BITS(12,15);}' unless defined(&ID_AA64DFR0_EL1_BRPS);
    eval 'sub ID_AA64DFR0_EL1_PMUVER () { &__BITS(8,11);}' unless defined(&ID_AA64DFR0_EL1_PMUVER);
    eval 'sub ID_AA64DFR0_EL1_PMUVER_NONE () {0;}' unless defined(&ID_AA64DFR0_EL1_PMUVER_NONE);
    eval 'sub ID_AA64DFR0_EL1_PMUVER_V3 () {1;}' unless defined(&ID_AA64DFR0_EL1_PMUVER_V3);
    eval 'sub ID_AA64DFR0_EL1_PMUVER_NOV3 () {2;}' unless defined(&ID_AA64DFR0_EL1_PMUVER_NOV3);
    eval 'sub ID_AA64DFR0_EL1_TRACEVER () { &__BITS(4,7);}' unless defined(&ID_AA64DFR0_EL1_TRACEVER);
    eval 'sub ID_AA64DFR0_EL1_TRACEVER_NONE () {0;}' unless defined(&ID_AA64DFR0_EL1_TRACEVER_NONE);
    eval 'sub ID_AA64DFR0_EL1_TRACEVER_IMPL () {1;}' unless defined(&ID_AA64DFR0_EL1_TRACEVER_IMPL);
    eval 'sub ID_AA64DFR0_EL1_DEBUGVER () { &__BITS(0,3);}' unless defined(&ID_AA64DFR0_EL1_DEBUGVER);
    eval 'sub ID_AA64DFR0_EL1_DEBUGVER_V8A () {6;}' unless defined(&ID_AA64DFR0_EL1_DEBUGVER_V8A);
    eval 'sub ID_AA64ISAR0_EL1_CRC32 () { &__BITS(19,16);}' unless defined(&ID_AA64ISAR0_EL1_CRC32);
    eval 'sub ID_AA64ISAR0_EL1_CRC32_NONE () {0;}' unless defined(&ID_AA64ISAR0_EL1_CRC32_NONE);
    eval 'sub ID_AA64ISAR0_EL1_CRC32_CRC32X () {1;}' unless defined(&ID_AA64ISAR0_EL1_CRC32_CRC32X);
    eval 'sub ID_AA64ISAR0_EL1_SHA2 () { &__BITS(15,12);}' unless defined(&ID_AA64ISAR0_EL1_SHA2);
    eval 'sub ID_AA64ISAR0_EL1_SHA2_NONE () {0;}' unless defined(&ID_AA64ISAR0_EL1_SHA2_NONE);
    eval 'sub ID_AA64ISAR0_EL1_SHA2_SHA256HSU () {1;}' unless defined(&ID_AA64ISAR0_EL1_SHA2_SHA256HSU);
    eval 'sub ID_AA64ISAR0_EL1_SHA1 () { &__BITS(11,8);}' unless defined(&ID_AA64ISAR0_EL1_SHA1);
    eval 'sub ID_AA64ISAR0_EL1_SHA1_NONE () {0;}' unless defined(&ID_AA64ISAR0_EL1_SHA1_NONE);
    eval 'sub ID_AA64ISAR0_EL1_SHA1_SHA1CPMHSU () {1;}' unless defined(&ID_AA64ISAR0_EL1_SHA1_SHA1CPMHSU);
    eval 'sub ID_AA64ISAR0_EL1_AES () { &__BITS(7,4);}' unless defined(&ID_AA64ISAR0_EL1_AES);
    eval 'sub ID_AA64ISAR0_EL1_AES_NONE () {0;}' unless defined(&ID_AA64ISAR0_EL1_AES_NONE);
    eval 'sub ID_AA64ISAR0_EL1_AES_AES () {1;}' unless defined(&ID_AA64ISAR0_EL1_AES_AES);
    eval 'sub ID_AA64ISAR0_EL1_AES_PMUL () {2;}' unless defined(&ID_AA64ISAR0_EL1_AES_PMUL);
    eval 'sub ID_AA64MMFR0_EL1_TGRAN4 () { &__BITS(31,28);}' unless defined(&ID_AA64MMFR0_EL1_TGRAN4);
    eval 'sub ID_AA64MMFR0_EL1_TGRAN4_4KB () {0;}' unless defined(&ID_AA64MMFR0_EL1_TGRAN4_4KB);
    eval 'sub ID_AA64MMFR0_EL1_TGRAN4_NONE () {15;}' unless defined(&ID_AA64MMFR0_EL1_TGRAN4_NONE);
    eval 'sub ID_AA64MMFR0_EL1_TGRAN64 () { &__BITS(24,27);}' unless defined(&ID_AA64MMFR0_EL1_TGRAN64);
    eval 'sub ID_AA64MMFR0_EL1_TGRAN64_64KB () {0;}' unless defined(&ID_AA64MMFR0_EL1_TGRAN64_64KB);
    eval 'sub ID_AA64MMFR0_EL1_TGRAN64_NONE () {15;}' unless defined(&ID_AA64MMFR0_EL1_TGRAN64_NONE);
    eval 'sub ID_AA64MMFR0_EL1_TGRAN16 () { &__BITS(20,23);}' unless defined(&ID_AA64MMFR0_EL1_TGRAN16);
    eval 'sub ID_AA64MMFR0_EL1_TGRAN16_NONE () {0;}' unless defined(&ID_AA64MMFR0_EL1_TGRAN16_NONE);
    eval 'sub ID_AA64MMFR0_EL1_TGRAN16_16KB () {1;}' unless defined(&ID_AA64MMFR0_EL1_TGRAN16_16KB);
    eval 'sub ID_AA64MMFR0_EL1_BIGENDEL0 () { &__BITS(16,19);}' unless defined(&ID_AA64MMFR0_EL1_BIGENDEL0);
    eval 'sub ID_AA64MMFR0_EL1_BIGENDEL0_NONE () {0;}' unless defined(&ID_AA64MMFR0_EL1_BIGENDEL0_NONE);
    eval 'sub ID_AA64MMFR0_EL1_BIGENDEL0_MIX () {1;}' unless defined(&ID_AA64MMFR0_EL1_BIGENDEL0_MIX);
    eval 'sub ID_AA64MMFR0_EL1_SNSMEM () { &__BITS(12,15);}' unless defined(&ID_AA64MMFR0_EL1_SNSMEM);
    eval 'sub ID_AA64MMFR0_EL1_SNSMEM_NONE () {0;}' unless defined(&ID_AA64MMFR0_EL1_SNSMEM_NONE);
    eval 'sub ID_AA64MMFR0_EL1_SNSMEM_SNSMEM () {1;}' unless defined(&ID_AA64MMFR0_EL1_SNSMEM_SNSMEM);
    eval 'sub ID_AA64MMFR0_EL1_BIGEND () { &__BITS(8,11);}' unless defined(&ID_AA64MMFR0_EL1_BIGEND);
    eval 'sub ID_AA64MMFR0_EL1_BIGEND_NONE () {0;}' unless defined(&ID_AA64MMFR0_EL1_BIGEND_NONE);
    eval 'sub ID_AA64MMFR0_EL1_BIGEND_MIX () {1;}' unless defined(&ID_AA64MMFR0_EL1_BIGEND_MIX);
    eval 'sub ID_AA64MMFR0_EL1_ASIDBITS () { &__BITS(4,7);}' unless defined(&ID_AA64MMFR0_EL1_ASIDBITS);
    eval 'sub ID_AA64MMFR0_EL1_ASIDBITS_8BIT () {0;}' unless defined(&ID_AA64MMFR0_EL1_ASIDBITS_8BIT);
    eval 'sub ID_AA64MMFR0_EL1_ASIDBITS_16BIT () {2;}' unless defined(&ID_AA64MMFR0_EL1_ASIDBITS_16BIT);
    eval 'sub ID_AA64MMFR0_EL1_PARANGE () { &__BITS(0,3);}' unless defined(&ID_AA64MMFR0_EL1_PARANGE);
    eval 'sub ID_AA64MMFR0_EL1_PARANGE_4G () {0;}' unless defined(&ID_AA64MMFR0_EL1_PARANGE_4G);
    eval 'sub ID_AA64MMFR0_EL1_PARANGE_64G () {1;}' unless defined(&ID_AA64MMFR0_EL1_PARANGE_64G);
    eval 'sub ID_AA64MMFR0_EL1_PARANGE_1T () {2;}' unless defined(&ID_AA64MMFR0_EL1_PARANGE_1T);
    eval 'sub ID_AA64MMFR0_EL1_PARANGE_4T () {3;}' unless defined(&ID_AA64MMFR0_EL1_PARANGE_4T);
    eval 'sub ID_AA64MMFR0_EL1_PARANGE_16T () {4;}' unless defined(&ID_AA64MMFR0_EL1_PARANGE_16T);
    eval 'sub ID_AA64MMFR0_EL1_PARANGE_256T () {5;}' unless defined(&ID_AA64MMFR0_EL1_PARANGE_256T);
    eval 'sub MIDR_EL1_IMPL () { &__BITS(31,24);}' unless defined(&MIDR_EL1_IMPL);
    eval 'sub MIDR_EL1_VARIANT () { &__BITS(23,20);}' unless defined(&MIDR_EL1_VARIANT);
    eval 'sub MIDR_EL1_ARCH () { &__BITS(19,16);}' unless defined(&MIDR_EL1_ARCH);
    eval 'sub MIDR_EL1_PARTNUM () { &__BITS(15,4);}' unless defined(&MIDR_EL1_PARTNUM);
    eval 'sub MIDR_EL1_REVISION () { &__BITS(3,0);}' unless defined(&MIDR_EL1_REVISION);
    eval 'sub MPIDR_AFF3 () { &__BITS(32,39);}' unless defined(&MPIDR_AFF3);
    eval 'sub MPIDR_U () { &__BIT(30);}' unless defined(&MPIDR_U);
    eval 'sub MPIDR_MT () { &__BIT(24);}' unless defined(&MPIDR_MT);
    eval 'sub MPIDR_AFF2 () { &__BITS(16,23);}' unless defined(&MPIDR_AFF2);
    eval 'sub MPIDR_AFF1 () { &__BITS(8,15);}' unless defined(&MPIDR_AFF1);
    eval 'sub MPIDR_AFF0 () { &__BITS(0,7);}' unless defined(&MPIDR_AFF0);
    eval 'sub MVFR0_FPROUND () { &__BITS(31,28);}' unless defined(&MVFR0_FPROUND);
    eval 'sub MVFR0_FPROUND_NEAREST () {0;}' unless defined(&MVFR0_FPROUND_NEAREST);
    eval 'sub MVFR0_FPROUND_ALL () {1;}' unless defined(&MVFR0_FPROUND_ALL);
    eval 'sub MVFR0_FPSHVEC () { &__BITS(27,24);}' unless defined(&MVFR0_FPSHVEC);
    eval 'sub MVFR0_FPSHVEC_NONE () {0;}' unless defined(&MVFR0_FPSHVEC_NONE);
    eval 'sub MVFR0_FPSHVEC_SHVEC () {1;}' unless defined(&MVFR0_FPSHVEC_SHVEC);
    eval 'sub MVFR0_FPSQRT () { &__BITS(23,20);}' unless defined(&MVFR0_FPSQRT);
    eval 'sub MVFR0_FPSQRT_NONE () {0;}' unless defined(&MVFR0_FPSQRT_NONE);
    eval 'sub MVFR0_FPSQRT_VSQRT () {1;}' unless defined(&MVFR0_FPSQRT_VSQRT);
    eval 'sub MVFR0_FPDIVIDE () { &__BITS(19,16);}' unless defined(&MVFR0_FPDIVIDE);
    eval 'sub MVFR0_FPDIVIDE_NONE () {0;}' unless defined(&MVFR0_FPDIVIDE_NONE);
    eval 'sub MVFR0_FPDIVIDE_VDIV () {1;}' unless defined(&MVFR0_FPDIVIDE_VDIV);
    eval 'sub MVFR0_FPTRAP () { &__BITS(15,12);}' unless defined(&MVFR0_FPTRAP);
    eval 'sub MVFR0_FPTRAP_NONE () {0;}' unless defined(&MVFR0_FPTRAP_NONE);
    eval 'sub MVFR0_FPTRAP_TRAP () {1;}' unless defined(&MVFR0_FPTRAP_TRAP);
    eval 'sub MVFR0_FPDP () { &__BITS(11,8);}' unless defined(&MVFR0_FPDP);
    eval 'sub MVFR0_FPDP_NONE () {0;}' unless defined(&MVFR0_FPDP_NONE);
    eval 'sub MVFR0_FPDP_VFPV2 () {1;}' unless defined(&MVFR0_FPDP_VFPV2);
    eval 'sub MVFR0_FPDP_VFPV3 () {2;}' unless defined(&MVFR0_FPDP_VFPV3);
    eval 'sub MVFR0_FPSP () { &__BITS(7,4);}' unless defined(&MVFR0_FPSP);
    eval 'sub MVFR0_FPSP_NONE () {0;}' unless defined(&MVFR0_FPSP_NONE);
    eval 'sub MVFR0_FPSP_VFPV2 () {1;}' unless defined(&MVFR0_FPSP_VFPV2);
    eval 'sub MVFR0_FPSP_VFPV3 () {2;}' unless defined(&MVFR0_FPSP_VFPV3);
    eval 'sub MVFR0_SIMDREG () { &__BITS(3,0);}' unless defined(&MVFR0_SIMDREG);
    eval 'sub MVFR0_SIMDREG_NONE () {0;}' unless defined(&MVFR0_SIMDREG_NONE);
    eval 'sub MVFR0_SIMDREG_16x64 () {1;}' unless defined(&MVFR0_SIMDREG_16x64);
    eval 'sub MVFR0_SIMDREG_32x64 () {2;}' unless defined(&MVFR0_SIMDREG_32x64);
    eval 'sub MVFR1_SIMDFMAC () { &__BITS(31,28);}' unless defined(&MVFR1_SIMDFMAC);
    eval 'sub MVFR1_SIMDFMAC_NONE () {0;}' unless defined(&MVFR1_SIMDFMAC_NONE);
    eval 'sub MVFR1_SIMDFMAC_FMAC () {1;}' unless defined(&MVFR1_SIMDFMAC_FMAC);
    eval 'sub MVFR1_FPHP () { &__BITS(27,24);}' unless defined(&MVFR1_FPHP);
    eval 'sub MVFR1_FPHP_NONE () {0;}' unless defined(&MVFR1_FPHP_NONE);
    eval 'sub MVFR1_FPHP_HALF_SINGLE () {1;}' unless defined(&MVFR1_FPHP_HALF_SINGLE);
    eval 'sub MVFR1_FPHP_HALF_DOUBLE () {2;}' unless defined(&MVFR1_FPHP_HALF_DOUBLE);
    eval 'sub MVFR1_FPHP_HALF_ARITH () {3;}' unless defined(&MVFR1_FPHP_HALF_ARITH);
    eval 'sub MVFR1_SIMDHP () { &__BITS(23,20);}' unless defined(&MVFR1_SIMDHP);
    eval 'sub MVFR1_SIMDHP_NONE () {0;}' unless defined(&MVFR1_SIMDHP_NONE);
    eval 'sub MVFR1_SIMDHP_HALF () {1;}' unless defined(&MVFR1_SIMDHP_HALF);
    eval 'sub MVFR1_SIMDHP_HALF_ARITH () {3;}' unless defined(&MVFR1_SIMDHP_HALF_ARITH);
    eval 'sub MVFR1_SIMDSP () { &__BITS(19,16);}' unless defined(&MVFR1_SIMDSP);
    eval 'sub MVFR1_SIMDSP_NONE () {0;}' unless defined(&MVFR1_SIMDSP_NONE);
    eval 'sub MVFR1_SIMDSP_SINGLE () {1;}' unless defined(&MVFR1_SIMDSP_SINGLE);
    eval 'sub MVFR1_SIMDINT () { &__BITS(15,12);}' unless defined(&MVFR1_SIMDINT);
    eval 'sub MVFR1_SIMDINT_NONE () {0;}' unless defined(&MVFR1_SIMDINT_NONE);
    eval 'sub MVFR1_SIMDINT_INTEGER () {1;}' unless defined(&MVFR1_SIMDINT_INTEGER);
    eval 'sub MVFR1_SIMDLS () { &__BITS(11,8);}' unless defined(&MVFR1_SIMDLS);
    eval 'sub MVFR1_SIMDLS_NONE () {0;}' unless defined(&MVFR1_SIMDLS_NONE);
    eval 'sub MVFR1_SIMDLS_LOADSTORE () {1;}' unless defined(&MVFR1_SIMDLS_LOADSTORE);
    eval 'sub MVFR1_FPDNAN () { &__BITS(7,4);}' unless defined(&MVFR1_FPDNAN);
    eval 'sub MVFR1_FPDNAN_NONE () {0;}' unless defined(&MVFR1_FPDNAN_NONE);
    eval 'sub MVFR1_FPDNAN_NAN () {1;}' unless defined(&MVFR1_FPDNAN_NAN);
    eval 'sub MVFR1_FPFTZ () { &__BITS(3,0);}' unless defined(&MVFR1_FPFTZ);
    eval 'sub MVFR1_FPFTZ_NONE () {0;}' unless defined(&MVFR1_FPFTZ_NONE);
    eval 'sub MVFR1_FPFTZ_DENORMAL () {1;}' unless defined(&MVFR1_FPFTZ_DENORMAL);
    eval 'sub MVFR2_FPMISC () { &__BITS(7,4);}' unless defined(&MVFR2_FPMISC);
    eval 'sub MVFR2_FPMISC_NONE () {0;}' unless defined(&MVFR2_FPMISC_NONE);
    eval 'sub MVFR2_FPMISC_SEL () {1;}' unless defined(&MVFR2_FPMISC_SEL);
    eval 'sub MVFR2_FPMISC_DROUND () {2;}' unless defined(&MVFR2_FPMISC_DROUND);
    eval 'sub MVFR2_FPMISC_ROUNDINT () {3;}' unless defined(&MVFR2_FPMISC_ROUNDINT);
    eval 'sub MVFR2_FPMISC_MAXMIN () {4;}' unless defined(&MVFR2_FPMISC_MAXMIN);
    eval 'sub MVFR2_SIMDMISC () { &__BITS(3,0);}' unless defined(&MVFR2_SIMDMISC);
    eval 'sub MVFR2_SIMDMISC_NONE () {0;}' unless defined(&MVFR2_SIMDMISC_NONE);
    eval 'sub MVFR2_SIMDMISC_DROUND () {1;}' unless defined(&MVFR2_SIMDMISC_DROUND);
    eval 'sub MVFR2_SIMDMISC_ROUNDINT () {2;}' unless defined(&MVFR2_SIMDMISC_ROUNDINT);
    eval 'sub MVFR2_SIMDMISC_MAXMIN () {3;}' unless defined(&MVFR2_SIMDMISC_MAXMIN);
    eval 'sub CPACR_TTA () { &__BIT(28);}' unless defined(&CPACR_TTA);
    eval 'sub CPACR_FPEN () { &__BITS(21,20);}' unless defined(&CPACR_FPEN);
    eval 'sub CPACR_FPEN_NONE () { &__SHIFTIN(0,  &CPACR_FPEN);}' unless defined(&CPACR_FPEN_NONE);
    eval 'sub CPACR_FPEN_EL1 () { &__SHIFTIN(1,  &CPACR_FPEN);}' unless defined(&CPACR_FPEN_EL1);
    eval 'sub CPACR_FPEN_NONE_2 () { &__SHIFTIN(2,  &CPACR_FPEN);}' unless defined(&CPACR_FPEN_NONE_2);
    eval 'sub CPACR_FPEN_ALL () { &__SHIFTIN(3,  &CPACR_FPEN);}' unless defined(&CPACR_FPEN_ALL);
    eval 'sub CSSELR_LEVEL () { &__BITS(3,1);}' unless defined(&CSSELR_LEVEL);
    eval 'sub CSSELR_IND () { &__BIT(0);}' unless defined(&CSSELR_IND);
    eval 'sub DAIF_D () { &__BIT(9);}' unless defined(&DAIF_D);
    eval 'sub DAIF_A () { &__BIT(8);}' unless defined(&DAIF_A);
    eval 'sub DAIF_I () { &__BIT(7);}' unless defined(&DAIF_I);
    eval 'sub DAIF_F () { &__BIT(6);}' unless defined(&DAIF_F);
    eval 'sub DAIF_SETCLR_SHIFT () {6;}' unless defined(&DAIF_SETCLR_SHIFT);
    eval 'sub ESR_EC () { &__BITS(31,26);}' unless defined(&ESR_EC);
    eval 'sub ESR_EC_UNKNOWN () {0x;}' unless defined(&ESR_EC_UNKNOWN);
    eval 'sub ESR_EC_WFX () {0x1;}' unless defined(&ESR_EC_WFX);
    eval 'sub ESR_EC_CP15_RT () {0x3;}' unless defined(&ESR_EC_CP15_RT);
    eval 'sub ESR_EC_CP15_RRT () {0x4;}' unless defined(&ESR_EC_CP15_RRT);
    eval 'sub ESR_EC_CP14_RT () {0x5;}' unless defined(&ESR_EC_CP14_RT);
    eval 'sub ESR_EC_CP14_DT () {0x6;}' unless defined(&ESR_EC_CP14_DT);
    eval 'sub ESR_EC_FP_ACCESS () {0x7;}' unless defined(&ESR_EC_FP_ACCESS);
    eval 'sub ESR_EC_FPID () {0x8;}' unless defined(&ESR_EC_FPID);
    eval 'sub ESR_EC_CP14_RRT () {0xc;}' unless defined(&ESR_EC_CP14_RRT);
    eval 'sub ESR_EC_ILL_STATE () {0xe;}' unless defined(&ESR_EC_ILL_STATE);
    eval 'sub ESR_EC_SVC_A32 () {0x11;}' unless defined(&ESR_EC_SVC_A32);
    eval 'sub ESR_EC_HVC_A32 () {0x12;}' unless defined(&ESR_EC_HVC_A32);
    eval 'sub ESR_EC_SMC_A32 () {0x13;}' unless defined(&ESR_EC_SMC_A32);
    eval 'sub ESR_EC_SVC_A64 () {0x15;}' unless defined(&ESR_EC_SVC_A64);
    eval 'sub ESR_EC_HVC_A64 () {0x16;}' unless defined(&ESR_EC_HVC_A64);
    eval 'sub ESR_EC_SMC_A64 () {0x17;}' unless defined(&ESR_EC_SMC_A64);
    eval 'sub ESR_EC_SYS_REG () {0x18;}' unless defined(&ESR_EC_SYS_REG);
    eval 'sub ESR_EC_INSN_ABT_EL0 () {0x20;}' unless defined(&ESR_EC_INSN_ABT_EL0);
    eval 'sub ESR_EC_INSN_ABT_EL1 () {0x21;}' unless defined(&ESR_EC_INSN_ABT_EL1);
    eval 'sub ESR_EC_PC_ALIGNMENT () {0x22;}' unless defined(&ESR_EC_PC_ALIGNMENT);
    eval 'sub ESR_EC_DATA_ABT_EL0 () {0x24;}' unless defined(&ESR_EC_DATA_ABT_EL0);
    eval 'sub ESR_EC_DATA_ABT_EL1 () {0x25;}' unless defined(&ESR_EC_DATA_ABT_EL1);
    eval 'sub ESR_EC_SP_ALIGNMENT () {0x26;}' unless defined(&ESR_EC_SP_ALIGNMENT);
    eval 'sub ESR_EC_FP_TRAP_A32 () {0x28;}' unless defined(&ESR_EC_FP_TRAP_A32);
    eval 'sub ESR_EC_FP_TRAP_A64 () {0x2c;}' unless defined(&ESR_EC_FP_TRAP_A64);
    eval 'sub ESR_EC_SERROR () {0x2f;}' unless defined(&ESR_EC_SERROR);
    eval 'sub ESR_EC_BRKPNT_EL0 () {0x30;}' unless defined(&ESR_EC_BRKPNT_EL0);
    eval 'sub ESR_EC_BRKPNT_EL1 () {0x31;}' unless defined(&ESR_EC_BRKPNT_EL1);
    eval 'sub ESR_EC_SW_STEP_EL0 () {0x32;}' unless defined(&ESR_EC_SW_STEP_EL0);
    eval 'sub ESR_EC_SW_STEP_EL1 () {0x33;}' unless defined(&ESR_EC_SW_STEP_EL1);
    eval 'sub ESR_EC_WTCHPNT_EL0 () {0x34;}' unless defined(&ESR_EC_WTCHPNT_EL0);
    eval 'sub ESR_EC_WTCHPNT_EL1 () {0x35;}' unless defined(&ESR_EC_WTCHPNT_EL1);
    eval 'sub ESR_EC_BKPT_INSN_A32 () {0x38;}' unless defined(&ESR_EC_BKPT_INSN_A32);
    eval 'sub ESR_EC_VECTOR_CATCH () {0x3a;}' unless defined(&ESR_EC_VECTOR_CATCH);
    eval 'sub ESR_EC_BKPT_INSN_A64 () {0x3c;}' unless defined(&ESR_EC_BKPT_INSN_A64);
    eval 'sub ESR_IL () { &__BIT(25);}' unless defined(&ESR_IL);
    eval 'sub ESR_ISS () { &__BITS(24,0);}' unless defined(&ESR_ISS);
    eval 'sub ESR_ISS_CV () { &__BIT(24);}' unless defined(&ESR_ISS_CV);
    eval 'sub ESR_ISS_COND () { &__BITS(23,20);}' unless defined(&ESR_ISS_COND);
    eval 'sub ESR_ISS_WFX_TRAP_INSN () { &__BIT(0);}' unless defined(&ESR_ISS_WFX_TRAP_INSN);
    eval 'sub ESR_ISS_MRC_OPC2 () { &__BITS(19,17);}' unless defined(&ESR_ISS_MRC_OPC2);
    eval 'sub ESR_ISS_MRC_OPC1 () { &__BITS(16,14);}' unless defined(&ESR_ISS_MRC_OPC1);
    eval 'sub ESR_ISS_MRC_CRN () { &__BITS(13,10);}' unless defined(&ESR_ISS_MRC_CRN);
    eval 'sub ESR_ISS_MRC_RT () { &__BITS(9,5);}' unless defined(&ESR_ISS_MRC_RT);
    eval 'sub ESR_ISS_MRC_CRM () { &__BITS(4,1);}' unless defined(&ESR_ISS_MRC_CRM);
    eval 'sub ESR_ISS_MRC_DIRECTION () { &__BIT(0);}' unless defined(&ESR_ISS_MRC_DIRECTION);
    eval 'sub ESR_ISS_MCRR_OPC1 () { &__BITS(19,16);}' unless defined(&ESR_ISS_MCRR_OPC1);
    eval 'sub ESR_ISS_MCRR_RT2 () { &__BITS(14,10);}' unless defined(&ESR_ISS_MCRR_RT2);
    eval 'sub ESR_ISS_MCRR_RT () { &__BITS(9,5);}' unless defined(&ESR_ISS_MCRR_RT);
    eval 'sub ESR_ISS_MCRR_CRM () { &__BITS(4,1);}' unless defined(&ESR_ISS_MCRR_CRM);
    eval 'sub ESR_ISS_MCRR_DIRECTION () { &__BIT(0);}' unless defined(&ESR_ISS_MCRR_DIRECTION);
    eval 'sub ESR_ISS_HVC_IMM16 () { &__BITS(15,0);}' unless defined(&ESR_ISS_HVC_IMM16);
    eval 'sub ESR_ISS_INSNABORT_EA () { &__BIT(9);}' unless defined(&ESR_ISS_INSNABORT_EA);
    eval 'sub ESR_ISS_INSNABORT_S1PTW () { &__BIT(7);}' unless defined(&ESR_ISS_INSNABORT_S1PTW);
    eval 'sub ESR_ISS_INSNABORT_IFSC () { &__BITS(0,5);}' unless defined(&ESR_ISS_INSNABORT_IFSC);
    eval 'sub ESR_ISS_DATAABORT_ISV () { &__BIT(24);}' unless defined(&ESR_ISS_DATAABORT_ISV);
    eval 'sub ESR_ISS_DATAABORT_SAS () { &__BITS(23,22);}' unless defined(&ESR_ISS_DATAABORT_SAS);
    eval 'sub ESR_ISS_DATAABORT_SSE () { &__BIT(21);}' unless defined(&ESR_ISS_DATAABORT_SSE);
    eval 'sub ESR_ISS_DATAABORT_SRT () { &__BITS(19,16);}' unless defined(&ESR_ISS_DATAABORT_SRT);
    eval 'sub ESR_ISS_DATAABORT_SF () { &__BIT(15);}' unless defined(&ESR_ISS_DATAABORT_SF);
    eval 'sub ESR_ISS_DATAABORT_AR () { &__BIT(14);}' unless defined(&ESR_ISS_DATAABORT_AR);
    eval 'sub ESR_ISS_DATAABORT_EA () { &__BIT(9);}' unless defined(&ESR_ISS_DATAABORT_EA);
    eval 'sub ESR_ISS_DATAABORT_CM () { &__BIT(8);}' unless defined(&ESR_ISS_DATAABORT_CM);
    eval 'sub ESR_ISS_DATAABORT_S1PTW () { &__BIT(7);}' unless defined(&ESR_ISS_DATAABORT_S1PTW);
    eval 'sub ESR_ISS_DATAABORT_WnR () { &__BIT(6);}' unless defined(&ESR_ISS_DATAABORT_WnR);
    eval 'sub ESR_ISS_DATAABORT_DFSC () { &__BITS(0,5);}' unless defined(&ESR_ISS_DATAABORT_DFSC);
    eval 'sub ESR_ISS_FSC_ADDRESS_SIZE_FAULT_0 () {0x;}' unless defined(&ESR_ISS_FSC_ADDRESS_SIZE_FAULT_0);
    eval 'sub ESR_ISS_FSC_ADDRESS_SIZE_FAULT_1 () {0x1;}' unless defined(&ESR_ISS_FSC_ADDRESS_SIZE_FAULT_1);
    eval 'sub ESR_ISS_FSC_ADDRESS_SIZE_FAULT_2 () {0x2;}' unless defined(&ESR_ISS_FSC_ADDRESS_SIZE_FAULT_2);
    eval 'sub ESR_ISS_FSC_ADDRESS_SIZE_FAULT_3 () {0x3;}' unless defined(&ESR_ISS_FSC_ADDRESS_SIZE_FAULT_3);
    eval 'sub ESR_ISS_FSC_TRANSLATION_FAULT_0 () {0x4;}' unless defined(&ESR_ISS_FSC_TRANSLATION_FAULT_0);
    eval 'sub ESR_ISS_FSC_TRANSLATION_FAULT_1 () {0x5;}' unless defined(&ESR_ISS_FSC_TRANSLATION_FAULT_1);
    eval 'sub ESR_ISS_FSC_TRANSLATION_FAULT_2 () {0x6;}' unless defined(&ESR_ISS_FSC_TRANSLATION_FAULT_2);
    eval 'sub ESR_ISS_FSC_TRANSLATION_FAULT_3 () {0x7;}' unless defined(&ESR_ISS_FSC_TRANSLATION_FAULT_3);
    eval 'sub ESR_ISS_FSC_ACCESS_FAULT_0 () {0x8;}' unless defined(&ESR_ISS_FSC_ACCESS_FAULT_0);
    eval 'sub ESR_ISS_FSC_ACCESS_FAULT_1 () {0x9;}' unless defined(&ESR_ISS_FSC_ACCESS_FAULT_1);
    eval 'sub ESR_ISS_FSC_ACCESS_FAULT_2 () {0xa;}' unless defined(&ESR_ISS_FSC_ACCESS_FAULT_2);
    eval 'sub ESR_ISS_FSC_ACCESS_FAULT_3 () {0xb;}' unless defined(&ESR_ISS_FSC_ACCESS_FAULT_3);
    eval 'sub ESR_ISS_FSC_PERM_FAULT_0 () {0xc;}' unless defined(&ESR_ISS_FSC_PERM_FAULT_0);
    eval 'sub ESR_ISS_FSC_PERM_FAULT_1 () {0xd;}' unless defined(&ESR_ISS_FSC_PERM_FAULT_1);
    eval 'sub ESR_ISS_FSC_PERM_FAULT_2 () {0xe;}' unless defined(&ESR_ISS_FSC_PERM_FAULT_2);
    eval 'sub ESR_ISS_FSC_PERM_FAULT_3 () {0xf;}' unless defined(&ESR_ISS_FSC_PERM_FAULT_3);
    eval 'sub ESR_ISS_FSC_SYNC_EXTERNAL_ABORT () {0x10;}' unless defined(&ESR_ISS_FSC_SYNC_EXTERNAL_ABORT);
    eval 'sub ESR_ISS_FSC_SYNC_EXTERNAL_ABORT_TTWALK_0 () {0x14;}' unless defined(&ESR_ISS_FSC_SYNC_EXTERNAL_ABORT_TTWALK_0);
    eval 'sub ESR_ISS_FSC_SYNC_EXTERNAL_ABORT_TTWALK_1 () {0x15;}' unless defined(&ESR_ISS_FSC_SYNC_EXTERNAL_ABORT_TTWALK_1);
    eval 'sub ESR_ISS_FSC_SYNC_EXTERNAL_ABORT_TTWALK_2 () {0x16;}' unless defined(&ESR_ISS_FSC_SYNC_EXTERNAL_ABORT_TTWALK_2);
    eval 'sub ESR_ISS_FSC_SYNC_EXTERNAL_ABORT_TTWALK_3 () {0x17;}' unless defined(&ESR_ISS_FSC_SYNC_EXTERNAL_ABORT_TTWALK_3);
    eval 'sub ESR_ISS_FSC_SYNC_PARITY_ERROR () {0x18;}' unless defined(&ESR_ISS_FSC_SYNC_PARITY_ERROR);
    eval 'sub ESR_ISS_FSC_SYNC_PARITY_ERROR_ON_TTWALK_0 () {0x1c;}' unless defined(&ESR_ISS_FSC_SYNC_PARITY_ERROR_ON_TTWALK_0);
    eval 'sub ESR_ISS_FSC_SYNC_PARITY_ERROR_ON_TTWALK_1 () {0x1d;}' unless defined(&ESR_ISS_FSC_SYNC_PARITY_ERROR_ON_TTWALK_1);
    eval 'sub ESR_ISS_FSC_SYNC_PARITY_ERROR_ON_TTWALK_2 () {0x1e;}' unless defined(&ESR_ISS_FSC_SYNC_PARITY_ERROR_ON_TTWALK_2);
    eval 'sub ESR_ISS_FSC_SYNC_PARITY_ERROR_ON_TTWALK_3 () {0x1f;}' unless defined(&ESR_ISS_FSC_SYNC_PARITY_ERROR_ON_TTWALK_3);
    eval 'sub ESR_ISS_FSC_ALIGNMENT_FAULT () {0x21;}' unless defined(&ESR_ISS_FSC_ALIGNMENT_FAULT);
    eval 'sub ESR_ISS_FSC_TLB_CONFLICT_FAULT () {0x30;}' unless defined(&ESR_ISS_FSC_TLB_CONFLICT_FAULT);
    eval 'sub ESR_ISS_FSC_LOCKDOWN_ABORT () {0x34;}' unless defined(&ESR_ISS_FSC_LOCKDOWN_ABORT);
    eval 'sub ESR_ISS_FSC_UNSUPPORTED_EXCLUSIVE () {0x35;}' unless defined(&ESR_ISS_FSC_UNSUPPORTED_EXCLUSIVE);
    eval 'sub ESR_ISS_FSC_FIRST_LEVEL_DOMAIN_FAULT () {0x3d;}' unless defined(&ESR_ISS_FSC_FIRST_LEVEL_DOMAIN_FAULT);
    eval 'sub ESR_ISS_FSC_SECOND_LEVEL_DOMAIN_FAULT () {0x3e;}' unless defined(&ESR_ISS_FSC_SECOND_LEVEL_DOMAIN_FAULT);
    eval 'sub L2CTLR_NUMOFCORE () { &__BITS(25,24);}' unless defined(&L2CTLR_NUMOFCORE);
    eval 'sub L2CTLR_CPUCACHEPROT () { &__BIT(22);}' unless defined(&L2CTLR_CPUCACHEPROT);
    eval 'sub L2CTLR_SCUL2CACHEPROT () { &__BIT(21);}' unless defined(&L2CTLR_SCUL2CACHEPROT);
    eval 'sub L2CTLR_L2_INPUT_LATENCY () { &__BIT(5);}' unless defined(&L2CTLR_L2_INPUT_LATENCY);
    eval 'sub L2CTLR_L2_OUTPUT_LATENCY () { &__BIT(0);}' unless defined(&L2CTLR_L2_OUTPUT_LATENCY);
    eval 'sub MAIR_ATTR0 () { &__BITS(7,0);}' unless defined(&MAIR_ATTR0);
    eval 'sub MAIR_ATTR1 () { &__BITS(15,8);}' unless defined(&MAIR_ATTR1);
    eval 'sub MAIR_ATTR2 () { &__BITS(23,16);}' unless defined(&MAIR_ATTR2);
    eval 'sub MAIR_ATTR3 () { &__BITS(31,24);}' unless defined(&MAIR_ATTR3);
    eval 'sub MAIR_ATTR4 () { &__BITS(39,32);}' unless defined(&MAIR_ATTR4);
    eval 'sub MAIR_ATTR5 () { &__BITS(47,40);}' unless defined(&MAIR_ATTR5);
    eval 'sub MAIR_ATTR6 () { &__BITS(55,48);}' unless defined(&MAIR_ATTR6);
    eval 'sub MAIR_ATTR7 () { &__BITS(63,56);}' unless defined(&MAIR_ATTR7);
    eval 'sub MAIR_DEVICE_nGnRnE () {0x;}' unless defined(&MAIR_DEVICE_nGnRnE);
    eval 'sub MAIR_DEVICE_nGnRE () {0x4;}' unless defined(&MAIR_DEVICE_nGnRE);
    eval 'sub MAIR_NORMAL_NC () {0x44;}' unless defined(&MAIR_NORMAL_NC);
    eval 'sub MAIR_NORMAL_WT () {0xbb;}' unless defined(&MAIR_NORMAL_WT);
    eval 'sub MAIR_NORMAL_WB () {0xff;}' unless defined(&MAIR_NORMAL_WB);
    eval 'sub PAR_ATTR () { &__BITS(63,56);}' unless defined(&PAR_ATTR);
    eval 'sub PAR_PA () { &__BITS(47,12);}' unless defined(&PAR_PA);
    eval 'sub PAR_NS () { &__BIT(9);}' unless defined(&PAR_NS);
    eval 'sub PAR_S () { &__BIT(9);}' unless defined(&PAR_S);
    eval 'sub PAR_SHA () { &__BITS(8,7);}' unless defined(&PAR_SHA);
    eval 'sub PAR_SHA_NONE () {0;}' unless defined(&PAR_SHA_NONE);
    eval 'sub PAR_SHA_OUTER () {2;}' unless defined(&PAR_SHA_OUTER);
    eval 'sub PAR_SHA_INNER () {3;}' unless defined(&PAR_SHA_INNER);
    eval 'sub PAR_PTW () { &__BIT(8);}' unless defined(&PAR_PTW);
    eval 'sub PAR_FST () { &__BITS(6,1);}' unless defined(&PAR_FST);
    eval 'sub PAR_F () { &__BIT(0);}' unless defined(&PAR_F);
    eval 'sub SCTLR_RES0 () {0xc8222400;}' unless defined(&SCTLR_RES0);
    eval 'sub SCTLR_RES1 () {0x30d00800;}' unless defined(&SCTLR_RES1);
    eval 'sub SCTLR_M () { &__BIT(0);}' unless defined(&SCTLR_M);
    eval 'sub SCTLR_A () { &__BIT(1);}' unless defined(&SCTLR_A);
    eval 'sub SCTLR_C () { &__BIT(2);}' unless defined(&SCTLR_C);
    eval 'sub SCTLR_SA () { &__BIT(3);}' unless defined(&SCTLR_SA);
    eval 'sub SCTLR_SA0 () { &__BIT(4);}' unless defined(&SCTLR_SA0);
    eval 'sub SCTLR_CP15BEN () { &__BIT(5);}' unless defined(&SCTLR_CP15BEN);
    eval 'sub SCTLR_THEE () { &__BIT(6);}' unless defined(&SCTLR_THEE);
    eval 'sub SCTLR_ITD () { &__BIT(7);}' unless defined(&SCTLR_ITD);
    eval 'sub SCTLR_SED () { &__BIT(8);}' unless defined(&SCTLR_SED);
    eval 'sub SCTLR_UMA () { &__BIT(9);}' unless defined(&SCTLR_UMA);
    eval 'sub SCTLR_I () { &__BIT(12);}' unless defined(&SCTLR_I);
    eval 'sub SCTLR_DZE () { &__BIT(14);}' unless defined(&SCTLR_DZE);
    eval 'sub SCTLR_UCT () { &__BIT(15);}' unless defined(&SCTLR_UCT);
    eval 'sub SCTLR_nTWI () { &__BIT(16);}' unless defined(&SCTLR_nTWI);
    eval 'sub SCTLR_nTWE () { &__BIT(18);}' unless defined(&SCTLR_nTWE);
    eval 'sub SCTLR_WXN () { &__BIT(19);}' unless defined(&SCTLR_WXN);
    eval 'sub SCTLR_IESB () { &__BIT(21);}' unless defined(&SCTLR_IESB);
    eval 'sub SCTLR_SPAN () { &__BIT(23);}' unless defined(&SCTLR_SPAN);
    eval 'sub SCTLR_EOE () { &__BIT(24);}' unless defined(&SCTLR_EOE);
    eval 'sub SCTLR_EE () { &__BIT(25);}' unless defined(&SCTLR_EE);
    eval 'sub SCTLR_UCI () { &__BIT(26);}' unless defined(&SCTLR_UCI);
    eval 'sub SCTLR_nTLSMD () { &__BIT(28);}' unless defined(&SCTLR_nTLSMD);
    eval 'sub SCTLR_LSMAOE () { &__BIT(29);}' unless defined(&SCTLR_LSMAOE);
    eval 'sub reg_sp_read {
        my($void) = @_;
	    eval q({  &uint64_t  &__rv;  &__asm  &__volatile (\\"mov %0, sp\\" : \\"=r\\"( &__rv));  &__rv; });
    }' unless defined(&reg_sp_read);
    eval 'sub SPSEL_SP () { &__BIT(0);;}' unless defined(&SPSEL_SP);
    eval 'sub SPSR_NZCV () { &__BITS(31,28);}' unless defined(&SPSR_NZCV);
    eval 'sub SPSR_N () { &__BIT(31);}' unless defined(&SPSR_N);
    eval 'sub SPSR_Z () { &__BIT(30);}' unless defined(&SPSR_Z);
    eval 'sub SPSR_C () { &__BIT(29);}' unless defined(&SPSR_C);
    eval 'sub SPSR_V () { &__BIT(28);}' unless defined(&SPSR_V);
    eval 'sub SPSR_A32_Q () { &__BIT(27);}' unless defined(&SPSR_A32_Q);
    eval 'sub SPSR_A32_J () { &__BIT(24);}' unless defined(&SPSR_A32_J);
    eval 'sub SPSR_A32_IT1 () { &__BIT(23);}' unless defined(&SPSR_A32_IT1);
    eval 'sub SPSR_A32_IT0 () { &__BIT(22);}' unless defined(&SPSR_A32_IT0);
    eval 'sub SPSR_SS () { &__BIT(21);}' unless defined(&SPSR_SS);
    eval 'sub SPSR_SS_SHIFT () {21;}' unless defined(&SPSR_SS_SHIFT);
    eval 'sub SPSR_IL () { &__BIT(20);}' unless defined(&SPSR_IL);
    eval 'sub SPSR_GE () { &__BITS(19,16);}' unless defined(&SPSR_GE);
    eval 'sub SPSR_IT7 () { &__BIT(15);}' unless defined(&SPSR_IT7);
    eval 'sub SPSR_IT6 () { &__BIT(14);}' unless defined(&SPSR_IT6);
    eval 'sub SPSR_IT5 () { &__BIT(13);}' unless defined(&SPSR_IT5);
    eval 'sub SPSR_IT4 () { &__BIT(12);}' unless defined(&SPSR_IT4);
    eval 'sub SPSR_IT3 () { &__BIT(11);}' unless defined(&SPSR_IT3);
    eval 'sub SPSR_IT2 () { &__BIT(10);}' unless defined(&SPSR_IT2);
    eval 'sub SPSR_A64_D () { &__BIT(9);}' unless defined(&SPSR_A64_D);
    eval 'sub SPSR_A32_E () { &__BIT(9);}' unless defined(&SPSR_A32_E);
    eval 'sub SPSR_A () { &__BIT(8);}' unless defined(&SPSR_A);
    eval 'sub SPSR_I () { &__BIT(7);}' unless defined(&SPSR_I);
    eval 'sub SPSR_F () { &__BIT(6);}' unless defined(&SPSR_F);
    eval 'sub SPSR_A32_T () { &__BIT(5);}' unless defined(&SPSR_A32_T);
    eval 'sub SPSR_A32 () { &__BIT(4);}' unless defined(&SPSR_A32);
    eval 'sub SPSR_M () { &__BITS(4,0);}' unless defined(&SPSR_M);
    eval 'sub SPSR_M_EL3H () {0xd;}' unless defined(&SPSR_M_EL3H);
    eval 'sub SPSR_M_EL3T () {0xc;}' unless defined(&SPSR_M_EL3T);
    eval 'sub SPSR_M_EL2H () {0x9;}' unless defined(&SPSR_M_EL2H);
    eval 'sub SPSR_M_EL2T () {0x8;}' unless defined(&SPSR_M_EL2T);
    eval 'sub SPSR_M_EL1H () {0x5;}' unless defined(&SPSR_M_EL1H);
    eval 'sub SPSR_M_EL1T () {0x4;}' unless defined(&SPSR_M_EL1T);
    eval 'sub SPSR_M_EL0T () {0x;}' unless defined(&SPSR_M_EL0T);
    eval 'sub SPSR_M_SYS32 () {0x1f;}' unless defined(&SPSR_M_SYS32);
    eval 'sub SPSR_M_UND32 () {0x1b;}' unless defined(&SPSR_M_UND32);
    eval 'sub SPSR_M_ABT32 () {0x17;}' unless defined(&SPSR_M_ABT32);
    eval 'sub SPSR_M_SVC32 () {0x13;}' unless defined(&SPSR_M_SVC32);
    eval 'sub SPSR_M_IRQ32 () {0x12;}' unless defined(&SPSR_M_IRQ32);
    eval 'sub SPSR_M_FIQ32 () {0x11;}' unless defined(&SPSR_M_FIQ32);
    eval 'sub SPSR_M_USR32 () {0x10;}' unless defined(&SPSR_M_USR32);
    eval 'sub TCR_PAGE_SIZE1 {
        my($tcr) = @_;
	    eval q((1 << ((1 <<  &__SHIFTOUT($tcr,  &TCR_TG1)) + 8)));
    }' unless defined(&TCR_PAGE_SIZE1);
    eval 'sub DBGBCR_BT () { &__BITS(23,20);}' unless defined(&DBGBCR_BT);
    eval 'sub DBGBCR_LBN () { &__BITS(19,16);}' unless defined(&DBGBCR_LBN);
    eval 'sub DBGBCR_SSC () { &__BITS(15,14);}' unless defined(&DBGBCR_SSC);
    eval 'sub DBGBCR_HMC () { &__BIT(13);}' unless defined(&DBGBCR_HMC);
    eval 'sub DBGBCR_BAS () { &__BITS(8,5);}' unless defined(&DBGBCR_BAS);
    eval 'sub DBGBCR_PMC () { &__BITS(2,1);}' unless defined(&DBGBCR_PMC);
    eval 'sub DBGBCR_E () { &__BIT(0);}' unless defined(&DBGBCR_E);
    eval 'sub DBGWCR_MASK () { &__BITS(28,24);}' unless defined(&DBGWCR_MASK);
    eval 'sub DBGWCR_WT () { &__BIT(20);}' unless defined(&DBGWCR_WT);
    eval 'sub DBGWCR_LBN () { &__BITS(19,16);}' unless defined(&DBGWCR_LBN);
    eval 'sub DBGWCR_SSC () { &__BITS(15,14);}' unless defined(&DBGWCR_SSC);
    eval 'sub DBGWCR_HMC () { &__BIT(13);}' unless defined(&DBGWCR_HMC);
    eval 'sub DBGWCR_BAS () { &__BITS(12,5);}' unless defined(&DBGWCR_BAS);
    eval 'sub DBGWCR_LSC () { &__BITS(4,3);}' unless defined(&DBGWCR_LSC);
    eval 'sub DBGWCR_PAC () { &__BITS(2,1);}' unless defined(&DBGWCR_PAC);
    eval 'sub DBGWCR_E () { &__BIT(0);}' unless defined(&DBGWCR_E);
    eval 'sub DBGWVR_MASK () { &__BITS(64,3);}' unless defined(&DBGWVR_MASK);
    eval 'sub MDSCR_RXFULL () { &__BIT(30);}' unless defined(&MDSCR_RXFULL);
    eval 'sub MDSCR_TXFULL () { &__BIT(29);}' unless defined(&MDSCR_TXFULL);
    eval 'sub MDSCR_RXO () { &__BIT(27);}' unless defined(&MDSCR_RXO);
    eval 'sub MDSCR_TXU () { &__BIT(26);}' unless defined(&MDSCR_TXU);
    eval 'sub MDSCR_INTDIS () { &__BITS(32,22);}' unless defined(&MDSCR_INTDIS);
    eval 'sub MDSCR_TDA () { &__BIT(21);}' unless defined(&MDSCR_TDA);
    eval 'sub MDSCR_MDE () { &__BIT(15);}' unless defined(&MDSCR_MDE);
    eval 'sub MDSCR_HDE () { &__BIT(14);}' unless defined(&MDSCR_HDE);
    eval 'sub MDSCR_KDE () { &__BIT(13);}' unless defined(&MDSCR_KDE);
    eval 'sub MDSCR_TDCC () { &__BIT(12);}' unless defined(&MDSCR_TDCC);
    eval 'sub MDSCR_ERR () { &__BIT(6);}' unless defined(&MDSCR_ERR);
    eval 'sub MDSCR_SS () { &__BIT(0);}' unless defined(&MDSCR_SS);
    eval 'sub PMCCFILTR_P () { &__BIT(31);}' unless defined(&PMCCFILTR_P);
    eval 'sub PMCCFILTR_U () { &__BIT(30);}' unless defined(&PMCCFILTR_U);
    eval 'sub PMCCFILTR_NSK () { &__BIT(29);}' unless defined(&PMCCFILTR_NSK);
    eval 'sub PMCCFILTR_NSU () { &__BIT(28);}' unless defined(&PMCCFILTR_NSU);
    eval 'sub PMCCFILTR_NSH () { &__BIT(27);}' unless defined(&PMCCFILTR_NSH);
    eval 'sub PMCCFILTR_M () { &__BIT(26);}' unless defined(&PMCCFILTR_M);
    eval 'sub PMCR_IMP () { &__BITS(31,24);}' unless defined(&PMCR_IMP);
    eval 'sub PMCR_IDCODE () { &__BITS(23,16);}' unless defined(&PMCR_IDCODE);
    eval 'sub PMCR_N () { &__BITS(15,11);}' unless defined(&PMCR_N);
    eval 'sub PMCR_LC () { &__BIT(6);}' unless defined(&PMCR_LC);
    eval 'sub PMCR_DP () { &__BIT(5);}' unless defined(&PMCR_DP);
    eval 'sub PMCR_X () { &__BIT(4);}' unless defined(&PMCR_X);
    eval 'sub PMCR_D () { &__BIT(3);}' unless defined(&PMCR_D);
    eval 'sub PMCR_C () { &__BIT(2);}' unless defined(&PMCR_C);
    eval 'sub PMCR_P () { &__BIT(1);}' unless defined(&PMCR_P);
    eval 'sub PMCR_E () { &__BIT(0);}' unless defined(&PMCR_E);
    eval 'sub PMEVTYPER_P () { &__BIT(31);}' unless defined(&PMEVTYPER_P);
    eval 'sub PMEVTYPER_U () { &__BIT(30);}' unless defined(&PMEVTYPER_U);
    eval 'sub PMEVTYPER_NSK () { &__BIT(29);}' unless defined(&PMEVTYPER_NSK);
    eval 'sub PMEVTYPER_NSU () { &__BIT(28);}' unless defined(&PMEVTYPER_NSU);
    eval 'sub PMEVTYPER_NSH () { &__BIT(27);}' unless defined(&PMEVTYPER_NSH);
    eval 'sub PMEVTYPER_M () { &__BIT(26);}' unless defined(&PMEVTYPER_M);
    eval 'sub PMEVTYPER_MT () { &__BIT(25);}' unless defined(&PMEVTYPER_MT);
    eval 'sub PMEVTYPER_EVTCOUNT () { &__BITS(15,0);}' unless defined(&PMEVTYPER_EVTCOUNT);
    eval 'sub CNTHCTL_EVNTDIR () { &__BIT(3);}' unless defined(&CNTHCTL_EVNTDIR);
    eval 'sub CNTHCTL_EVNTEN () { &__BIT(2);}' unless defined(&CNTHCTL_EVNTEN);
    eval 'sub CNTHCTL_EL1PCEN () { &__BIT(1);}' unless defined(&CNTHCTL_EL1PCEN);
    eval 'sub CNTHCTL_EL1PCTEN () { &__BIT(0);}' unless defined(&CNTHCTL_EL1PCTEN);
    eval 'sub CNTKCTL_EL0PTEN () { &__BIT(9);}' unless defined(&CNTKCTL_EL0PTEN);
    eval 'sub CNTKCTL_PL0PTEN () { &CNTKCTL_EL0PTEN;}' unless defined(&CNTKCTL_PL0PTEN);
    eval 'sub CNTKCTL_EL0VTEN () { &__BIT(8);}' unless defined(&CNTKCTL_EL0VTEN);
    eval 'sub CNTKCTL_PL0VTEN () { &CNTKCTL_EL0VTEN;}' unless defined(&CNTKCTL_PL0VTEN);
    eval 'sub CNTKCTL_ELNTI () { &__BITS(7,4);}' unless defined(&CNTKCTL_ELNTI);
    eval 'sub CNTKCTL_EVNTDIR () { &__BIT(3);}' unless defined(&CNTKCTL_EVNTDIR);
    eval 'sub CNTKCTL_EVNTEN () { &__BIT(2);}' unless defined(&CNTKCTL_EVNTEN);
    eval 'sub CNTKCTL_EL0VCTEN () { &__BIT(1);}' unless defined(&CNTKCTL_EL0VCTEN);
    eval 'sub CNTKCTL_PL0VCTEN () { &CNTKCTL_EL0VCTEN;}' unless defined(&CNTKCTL_PL0VCTEN);
    eval 'sub CNTKCTL_EL0PCTEN () { &__BIT(0);}' unless defined(&CNTKCTL_EL0PCTEN);
    eval 'sub CNTKCTL_PL0PCTEN () { &CNTKCTL_EL0PCTEN;}' unless defined(&CNTKCTL_PL0PCTEN);
    eval 'sub CNTCTL_ISTATUS () { &__BIT(2);}' unless defined(&CNTCTL_ISTATUS);
    eval 'sub CNTCTL_IMASK () { &__BIT(1);}' unless defined(&CNTCTL_IMASK);
    eval 'sub CNTCTL_ENABLE () { &__BIT(0);}' unless defined(&CNTCTL_ENABLE);
    eval 'sub ID_AA64PFR0_EL1_GIC () { &__BITS(24,27);}' unless defined(&ID_AA64PFR0_EL1_GIC);
    eval 'sub ID_AA64PFR0_EL1_GIC_SHIFT () {24;}' unless defined(&ID_AA64PFR0_EL1_GIC_SHIFT);
    eval 'sub ID_AA64PFR0_EL1_GIC_CPUIF_EN () {1;}' unless defined(&ID_AA64PFR0_EL1_GIC_CPUIF_EN);
    eval 'sub ID_AA64PFR0_EL1_GIC_CPUIF_NONE () {0;}' unless defined(&ID_AA64PFR0_EL1_GIC_CPUIF_NONE);
    eval 'sub ID_AA64PFR0_EL1_ADVSIMD () { &__BITS(23,20);}' unless defined(&ID_AA64PFR0_EL1_ADVSIMD);
    eval 'sub ID_AA64PFR0_EL1_ADV_SIMD_IMPL () {0x;}' unless defined(&ID_AA64PFR0_EL1_ADV_SIMD_IMPL);
    eval 'sub ID_AA64PFR0_EL1_ADV_SIMD_NONE () {0xf;}' unless defined(&ID_AA64PFR0_EL1_ADV_SIMD_NONE);
    eval 'sub ID_AA64PFR0_EL1_FP () { &__BITS(19,16);}' unless defined(&ID_AA64PFR0_EL1_FP);
    eval 'sub ID_AA64PFR0_EL1_FP_IMPL () {0x;}' unless defined(&ID_AA64PFR0_EL1_FP_IMPL);
    eval 'sub ID_AA64PFR0_EL1_FP_NONE () {0xf;}' unless defined(&ID_AA64PFR0_EL1_FP_NONE);
    eval 'sub ID_AA64PFR0_EL1_EL3 () { &__BITS(15,12);}' unless defined(&ID_AA64PFR0_EL1_EL3);
    eval 'sub ID_AA64PFR0_EL1_EL3_NONE () {0;}' unless defined(&ID_AA64PFR0_EL1_EL3_NONE);
    eval 'sub ID_AA64PFR0_EL1_EL3_64 () {1;}' unless defined(&ID_AA64PFR0_EL1_EL3_64);
    eval 'sub ID_AA64PFR0_EL1_EL3_64_32 () {2;}' unless defined(&ID_AA64PFR0_EL1_EL3_64_32);
    eval 'sub ID_AA64PFR0_EL1_EL2 () { &__BITS(11,8);}' unless defined(&ID_AA64PFR0_EL1_EL2);
    eval 'sub ID_AA64PFR0_EL1_EL2_NONE () {0;}' unless defined(&ID_AA64PFR0_EL1_EL2_NONE);
    eval 'sub ID_AA64PFR0_EL1_EL2_64 () {1;}' unless defined(&ID_AA64PFR0_EL1_EL2_64);
    eval 'sub ID_AA64PFR0_EL1_EL2_64_32 () {2;}' unless defined(&ID_AA64PFR0_EL1_EL2_64_32);
    eval 'sub ID_AA64PFR0_EL1_EL1 () { &__BITS(7,4);}' unless defined(&ID_AA64PFR0_EL1_EL1);
    eval 'sub ID_AA64PFR0_EL1_EL1_64 () {1;}' unless defined(&ID_AA64PFR0_EL1_EL1_64);
    eval 'sub ID_AA64PFR0_EL1_EL1_64_32 () {2;}' unless defined(&ID_AA64PFR0_EL1_EL1_64_32);
    eval 'sub ID_AA64PFR0_EL1_EL0 () { &__BITS(3,0);}' unless defined(&ID_AA64PFR0_EL1_EL0);
    eval 'sub ID_AA64PFR0_EL1_EL0_64 () {1;}' unless defined(&ID_AA64PFR0_EL1_EL0_64);
    eval 'sub ID_AA64PFR0_EL1_EL0_64_32 () {2;}' unless defined(&ID_AA64PFR0_EL1_EL0_64_32);
    eval 'sub ICC_SRE_EL1_DIB () { &__BIT(2);}' unless defined(&ICC_SRE_EL1_DIB);
    eval 'sub ICC_SRE_EL1_DFB () { &__BIT(1);}' unless defined(&ICC_SRE_EL1_DFB);
    eval 'sub ICC_SRE_EL1_SRE () { &__BIT(0);}' unless defined(&ICC_SRE_EL1_SRE);
    eval 'sub ICC_SRE_EL2_EN () { &__BIT(3);}' unless defined(&ICC_SRE_EL2_EN);
    eval 'sub ICC_SRE_EL2_DIB () { &__BIT(2);}' unless defined(&ICC_SRE_EL2_DIB);
    eval 'sub ICC_SRE_EL2_DFB () { &__BIT(1);}' unless defined(&ICC_SRE_EL2_DFB);
    eval 'sub ICC_SRE_EL2_SRE () { &__BIT(0);}' unless defined(&ICC_SRE_EL2_SRE);
    eval 'sub ICC_BPR_EL1_BinaryPoint () { &__BITS(2,0);}' unless defined(&ICC_BPR_EL1_BinaryPoint);
    eval 'sub ICC_CTLR_EL1_A3V () { &__BIT(15);}' unless defined(&ICC_CTLR_EL1_A3V);
    eval 'sub ICC_CTLR_EL1_SEIS () { &__BIT(14);}' unless defined(&ICC_CTLR_EL1_SEIS);
    eval 'sub ICC_CTLR_EL1_IDbits () { &__BITS(13,11);}' unless defined(&ICC_CTLR_EL1_IDbits);
    eval 'sub ICC_CTLR_EL1_PRIbits () { &__BITS(10,8);}' unless defined(&ICC_CTLR_EL1_PRIbits);
    eval 'sub ICC_CTLR_EL1_PMHE () { &__BIT(6);}' unless defined(&ICC_CTLR_EL1_PMHE);
    eval 'sub ICC_CTLR_EL1_EOImode () { &__BIT(1);}' unless defined(&ICC_CTLR_EL1_EOImode);
    eval 'sub ICC_CTLR_EL1_CBPR () { &__BIT(0);}' unless defined(&ICC_CTLR_EL1_CBPR);
    eval 'sub ICC_IGRPEN_EL1_Enable () { &__BIT(0);}' unless defined(&ICC_IGRPEN_EL1_Enable);
    eval 'sub ICC_SGIR_EL1_Aff3 () { &__BITS(55,48);}' unless defined(&ICC_SGIR_EL1_Aff3);
    eval 'sub ICC_SGIR_EL1_IRM () { &__BIT(40);}' unless defined(&ICC_SGIR_EL1_IRM);
    eval 'sub ICC_SGIR_EL1_Aff2 () { &__BITS(39,32);}' unless defined(&ICC_SGIR_EL1_Aff2);
    eval 'sub ICC_SGIR_EL1_INTID () { &__BITS(27,24);}' unless defined(&ICC_SGIR_EL1_INTID);
    eval 'sub ICC_SGIR_EL1_Aff1 () { &__BITS(23,16);}' unless defined(&ICC_SGIR_EL1_Aff1);
    eval 'sub ICC_SGIR_EL1_TargetList () { &__BITS(15,0);}' unless defined(&ICC_SGIR_EL1_TargetList);
    eval 'sub ICC_SGIR_EL1_Aff () {( &ICC_SGIR_EL1_Aff3| &ICC_SGIR_EL1_Aff2| &ICC_SGIR_EL1_Aff1);}' unless defined(&ICC_SGIR_EL1_Aff);
    eval 'sub ICC_IAR_INTID () { &__BITS(23,0);}' unless defined(&ICC_IAR_INTID);
    eval 'sub ICC_IAR_INTID_SPURIOUS () {1023;}' unless defined(&ICC_IAR_INTID_SPURIOUS);
    eval 'sub icc_sre_read () { &reg_icc_sre_el1_read;}' unless defined(&icc_sre_read);
    eval 'sub icc_sre_write () { &reg_icc_sre_el1_write;}' unless defined(&icc_sre_write);
    eval 'sub icc_pmr_read () { &reg_icc_pmr_el1_read;}' unless defined(&icc_pmr_read);
    eval 'sub icc_pmr_write () { &reg_icc_pmr_el1_write;}' unless defined(&icc_pmr_write);
    eval 'sub icc_bpr0_write () { &reg_icc_bpr0_el1_write;}' unless defined(&icc_bpr0_write);
    eval 'sub icc_bpr1_write () { &reg_icc_bpr1_el1_write;}' unless defined(&icc_bpr1_write);
    eval 'sub icc_ctlr_read () { &reg_icc_ctlr_el1_read;}' unless defined(&icc_ctlr_read);
    eval 'sub icc_ctlr_write () { &reg_icc_ctlr_el1_write;}' unless defined(&icc_ctlr_write);
    eval 'sub icc_igrpen1_write () { &reg_icc_igrpen1_el1_write;}' unless defined(&icc_igrpen1_write);
    eval 'sub icc_sgi1r_write () { &reg_icc_sgi1r_el1_write;}' unless defined(&icc_sgi1r_write);
    eval 'sub icc_iar1_read () { &reg_icc_iar1_el1_read;}' unless defined(&icc_iar1_read);
    eval 'sub icc_eoi1r_write () { &reg_icc_eoir1_el1_write;}' unless defined(&icc_eoi1r_write);
    if(defined(&_KERNEL)) {
	eval 'sub gtmr_cntk_ctl_read {
	    my($void) = @_;
    	    eval q({  &reg_cntkctl_el1_read(); });
	}' unless defined(&gtmr_cntk_ctl_read);
	eval 'sub gtmr_cntk_ctl_write {
	    my($val) = @_;
    	    eval q({  &reg_cntkctl_el1_write($val); });
	}' unless defined(&gtmr_cntk_ctl_write);
	eval 'sub gtmr_cntvct_read {
	    my($void) = @_;
    	    eval q({  &reg_cntvct_el0_read(); });
	}' unless defined(&gtmr_cntvct_read);
	eval 'sub gtmr_cntv_ctl_write {
	    my($val) = @_;
    	    eval q({  &reg_cntv_ctl_el0_write($val); });
	}' unless defined(&gtmr_cntv_ctl_write);
	eval 'sub gtmr_cntp_ctl_write {
	    my($val) = @_;
    	    eval q({  &reg_cntp_ctl_el0_write($val); });
	}' unless defined(&gtmr_cntp_ctl_write);
	eval 'sub gtmr_cntp_tval_write {
	    my($val) = @_;
    	    eval q({  &reg_cntp_tval_el0_write($val); });
	}' unless defined(&gtmr_cntp_tval_write);
	eval 'sub gtmr_cntv_tval_write {
	    my($val) = @_;
    	    eval q({  &reg_cntv_tval_el0_write($val); });
	}' unless defined(&gtmr_cntv_tval_write);
	eval 'sub gtmr_cntp_cval_write {
	    my($val) = @_;
    	    eval q({  &reg_cntp_cval_el0_write($val); });
	}' unless defined(&gtmr_cntp_cval_write);
	eval 'sub gtmr_cntv_cval_write {
	    my($val) = @_;
    	    eval q({  &reg_cntv_cval_el0_write($val); });
	}' unless defined(&gtmr_cntv_cval_write);
    }
}
1;
