/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class FlowLayout
implements LayoutManager,
Serializable {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int LEADING = 3;
    public static final int TRAILING = 4;
    private static final long serialVersionUID = -7262534875583282631L;
    private int align;
    private int hgap;
    private int vgap;

    public void addLayoutComponent(String name, Component comp) {
    }

    public int getAlignment() {
        return this.align;
    }

    public int getHgap() {
        return this.hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int num = parent.getComponentCount();
            Component[] comps = parent.component;
            Dimension d = parent.getSize();
            Insets ins = parent.getInsets();
            ComponentOrientation orient = parent.getComponentOrientation();
            boolean left_to_right = orient.isLeftToRight();
            int y = ins.top + this.vgap;
            int i = 0;
            while (i < num) {
                int new_w = ins.left + this.hgap + ins.right;
                int new_h = 0;
                boolean found_one = false;
                int j = i;
                while (j < num) {
                    if (comps[j].visible) {
                        Dimension c = comps[j].getPreferredSize();
                        int next_w = new_w + this.hgap + c.width;
                        if (next_w > d.width && found_one) break;
                        new_w = next_w;
                        new_h = Math.max(new_h, c.height);
                        found_one = true;
                    }
                    ++j;
                }
                int myalign = this.align;
                if (this.align == 3) {
                    myalign = left_to_right ? 0 : 2;
                } else if (this.align == 4) {
                    int n = myalign = left_to_right ? 2 : 0;
                }
                int x = myalign == 2 ? ins.left + (d.width - new_w) + this.hgap : (myalign == 1 ? ins.left + (d.width - new_w) / 2 + this.hgap : ins.left + this.hgap);
                int k = i;
                while (k < j) {
                    if (comps[k].visible) {
                        Dimension c = comps[k].getPreferredSize();
                        comps[k].setBounds(x, y + (new_h - c.height) / 2, c.width, c.height);
                        x += c.width + this.hgap;
                    }
                    ++k;
                }
                i = j;
                y += new_h + this.vgap;
            }
            return;
        }
    }

    public Dimension minimumLayoutSize(Container cont) {
        return this.getSize(cont, true);
    }

    public Dimension preferredLayoutSize(Container cont) {
        return this.getSize(cont, false);
    }

    public void removeLayoutComponent(Component comp) {
    }

    public void setAlignment(int align) {
        this.align = align;
    }

    public void setHgap(int hgap) {
        if (hgap < 0) {
            throw new IllegalArgumentException("horizontal gap must be nonnegative");
        }
        this.hgap = hgap;
    }

    public void setVgap(int vgap) {
        if (vgap < 0) {
            throw new IllegalArgumentException("vertical gap must be nonnegative");
        }
        this.vgap = vgap;
    }

    public String toString() {
        return "[" + this.getClass().getName() + ",hgap=" + this.hgap + ",vgap=" + this.vgap + ",align=" + this.align + ']';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Dimension getSize(Container parent, boolean is_min) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int num = parent.getComponentCount();
            Component[] comps = parent.component;
            int w = 0;
            int h = 0;
            int i = 0;
            while (true) {
                if (i >= num) {
                    Insets ins = parent.getInsets();
                    return new Dimension(w += (num + 1) * this.hgap + ins.left + ins.right, h += 2 * this.vgap + ins.top + ins.bottom);
                }
                if (comps[i].visible) {
                    Dimension d = is_min ? comps[i].getMinimumSize() : comps[i].getPreferredSize();
                    w += d.width;
                    h = Math.max(d.height, h);
                }
                ++i;
            }
        }
    }

    public FlowLayout() {
        this(1, 5, 5);
    }

    public FlowLayout(int align) {
        this(align, 5, 5);
    }

    public FlowLayout(int align, int hgap, int vgap) {
        this.setVgap(vgap);
        this.setHgap(hgap);
        this.setAlignment(align);
    }
}

