/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer.cli;

import com.glavsoft.utils.Strings;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Parser {
    private final Map<String, Option> options = new LinkedHashMap<String, Option>();
    private final List<String> plainOptions = new ArrayList<String>();
    private boolean isSetPlainOptions = false;

    public void addOption(String opName, String defaultValue, String desc) {
        Option op = new Option(opName, defaultValue, desc);
        this.options.put(opName.toLowerCase(), op);
    }

    public void parse(String[] args) {
        for (String p : args) {
            if (p.startsWith("-")) {
                int skipMinuses = p.startsWith("--") ? 2 : 1;
                String[] params = p.split("=", 2);
                Option op = this.options.get(params[0].toLowerCase().substring(skipMinuses));
                if (op == null) continue;
                op.isSet = true;
                if (params.length <= 1 || Strings.isTrimmedEmpty(params[1])) continue;
                op.value = params[1];
                continue;
            }
            if (p.startsWith("-")) continue;
            this.isSetPlainOptions = true;
            this.plainOptions.add(p);
        }
    }

    public String getValueFor(String param) {
        Option op = this.options.get(param.toLowerCase());
        return op != null ? op.value : null;
    }

    public boolean isSet(String param) {
        Option op = this.options.get(param.toLowerCase());
        return op != null && op.isSet;
    }

    public boolean isSetPlainOptions() {
        return this.isSetPlainOptions;
    }

    public String getPlainOptionAt(int index) {
        return this.plainOptions.get(index);
    }

    public int getPlainOptionsNumber() {
        return this.plainOptions.size();
    }

    public String optionsUsage() {
        StringBuilder sb = new StringBuilder();
        int maxNameLength = 0;
        for (Option op : this.options.values()) {
            maxNameLength = Math.max(maxNameLength, op.opName.length());
        }
        for (Option op : this.options.values()) {
            sb.append(" -").append(op.opName);
            for (int i = 0; i < maxNameLength - op.opName.length(); ++i) {
                sb.append(' ');
            }
            sb.append(" : ").append(op.desc).append('\n');
        }
        return sb.toString();
    }

    private static class Option {
        protected String opName;
        protected String defaultValue;
        protected String desc;
        protected String value;
        protected boolean isSet = false;

        public Option(String opName, String defaultValue, String desc) {
            this.opName = opName;
            this.defaultValue = defaultValue;
            this.desc = desc;
            this.value = defaultValue;
        }
    }
}

