/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xslt.extensions;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.xalan.xpath.MutableNodeList;
import org.apache.xalan.xpath.SimpleNodeLocator;
import org.apache.xalan.xpath.XLocator;
import org.apache.xalan.xpath.XNodeSet;
import org.apache.xalan.xpath.XObject;
import org.apache.xalan.xpath.XPath;
import org.apache.xalan.xpath.XPathSupport;
import org.apache.xalan.xslt.ElemExtensionCall;
import org.apache.xalan.xslt.XSLProcessorContext;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.ElementImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.AttributeList;

public class RowSetLocator
extends SimpleNodeLocator {
    public String m_driver;
    public String m_dbURL;
    static Properties m_protocol = new Properties();
    public String m_userID = "";
    public String m_password = "";
    public Connection m_connection;
    Statement m_statement;

    public RowSetLocator(String string, String string2) {
        this.init(string, string2);
    }

    public static void protocol(XSLProcessorContext xSLProcessorContext, ElemExtensionCall elemExtensionCall) {
        AttributeList attributeList = elemExtensionCall.getAttributeList();
        int n = attributeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            ((Hashtable)m_protocol).put(attributeList.getName(n2), attributeList.getValue(n2));
            ++n2;
        }
    }

    private void init(String string, String string2) {
        this.m_driver = string;
        this.m_dbURL = string2;
    }

    public static XLocator connect(String string, String string2, String string3) {
        RowSetLocator rowSetLocator = null;
        try {
            rowSetLocator = new RowSetLocator(string, string2);
            Class.forName(rowSetLocator.m_driver);
            rowSetLocator.m_connection = DriverManager.getConnection(rowSetLocator.m_dbURL, m_protocol);
            rowSetLocator.m_connection.setAutoCommit(false);
            rowSetLocator.m_statement = rowSetLocator.m_connection.createStatement();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return rowSetLocator;
    }

    public XNodeSet connectToNodes(XPath xPath, XPathSupport xPathSupport, Node node, int n, Vector vector) {
        XNodeSet xNodeSet = new XNodeSet();
        MutableNodeList mutableNodeList = xNodeSet.mutableNodeset();
        try {
            String string = ((XObject)vector.elementAt(2)).str();
            ResultSet resultSet = this.m_statement.executeQuery(string);
            DocumentImpl documentImpl = new DocumentImpl();
            RowSetElem rowSetElem = new RowSetElem(documentImpl, "row-set", resultSet, this);
            documentImpl.appendChild((Node)((Object)rowSetElem));
            if (xPath.getOpMap()[n] == 28) {
                XNodeSet xNodeSet2 = xPath.locationPath(xPathSupport, (Node)documentImpl, n, null, null, false);
                if (xNodeSet2 != null) {
                    mutableNodeList.addNodes(xNodeSet2.nodeset());
                    xPathSupport.associateXLocatorToNode((Node)documentImpl, this);
                }
            } else {
                mutableNodeList.addNode((Node)((Object)rowSetElem));
                xPathSupport.associateXLocatorToNode((Node)documentImpl, this);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return xNodeSet;
    }

    class RowSetElem
    extends ElementImpl {
        ResultSet m_rowSet;
        RowSetLocator m_locator;
        int m_count;

        public RowSetElem(DocumentImpl documentImpl, String string, ResultSet resultSet, RowSetLocator rowSetLocator2) {
            super(documentImpl, string);
            RowSetLocator.this = RowSetLocator.this;
            this.m_rowSet = resultSet;
            this.m_locator = rowSetLocator2;
            try {
                ResultSetMetaData resultSetMetaData = this.m_rowSet.getMetaData();
                if (resultSetMetaData != null) {
                    int n = resultSetMetaData.getColumnCount();
                    this.setAttribute("n-columns", Integer.toString(n));
                    int n2 = 1;
                    while (n2 <= n) {
                        String string2;
                        String string3;
                        String string4;
                        String string5;
                        Element element = documentImpl.createElement("col-header");
                        this.appendChild(element);
                        String string6 = resultSetMetaData.getTableName(n2);
                        if (string6.length() > 0) {
                            element.setAttribute("table-name", string6);
                        }
                        if ((string5 = resultSetMetaData.getCatalogName(n2)).length() > 0) {
                            element.setAttribute("catalog", string5);
                        }
                        if ((string4 = resultSetMetaData.getColumnName(n2)) != null && string4.length() > 0) {
                            element.setAttribute("column-name", string4);
                        }
                        if ((string3 = resultSetMetaData.getColumnLabel(n2)) != null && string3.length() > 0) {
                            element.setAttribute("column-label", string3);
                        }
                        int n3 = resultSetMetaData.getColumnDisplaySize(n2);
                        element.setAttribute("display-size", Integer.toString(n3));
                        int n4 = resultSetMetaData.getPrecision(n2);
                        element.setAttribute("precision", Integer.toString(n4));
                        String string7 = resultSetMetaData.getColumnTypeName(n2);
                        if (string7.length() > 0) {
                            element.setAttribute("type", string7);
                        }
                        if ((string2 = resultSetMetaData.getSchemaName(n2)).length() > 0) {
                            element.setAttribute("schema", string2);
                        }
                        ++n2;
                    }
                    return;
                }
                System.out.println("Could not get metadata!!");
                return;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return;
            }
        }

        public boolean hasChildNodes() {
            return this.getFirstChild() != null;
        }

        public Node getFirstChild() {
            while (this.m_count <= 1 && this.createRow()) {
            }
            return super.getFirstChild();
        }

        public Node getLastChild() {
            this.getLength();
            return super.getLastChild();
        }

        public int getLength() {
            while (this.createRow()) {
            }
            return this.m_count;
        }

        boolean createRow() {
            boolean bl = false;
            try {
                bl = this.m_rowSet.next();
                if (bl) {
                    ResultSetMetaData resultSetMetaData = this.m_rowSet.getMetaData();
                    Document document = this.getOwnerDocument();
                    RowElem rowElem = new RowElem((DocumentImpl)document, "row");
                    this.appendChild((Node)((Object)rowElem));
                    int n = resultSetMetaData.getColumnCount();
                    int n2 = 1;
                    while (n2 <= n) {
                        Element element = document.createElement("col");
                        rowElem.appendChild(element);
                        String string = this.m_rowSet.getString(n2);
                        Text text = document.createTextNode(string);
                        element.appendChild(text);
                        ++n2;
                    }
                    ++this.m_count;
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            return bl;
        }

        public Node item(int n) {
            while (this.m_count <= n && this.createRow()) {
            }
            return super.item(n);
        }
    }

    class RowElem
    extends ElementImpl {
        public RowElem(DocumentImpl documentImpl, String string) {
            super(documentImpl, string);
            RowSetLocator.this = RowSetLocator.this;
        }

        public Node getNextSibling() {
            Node node = super.getNextSibling();
            if (node == null) {
                RowSetElem rowSetElem = (RowSetElem)((Object)this.getParentNode());
                rowSetElem.createRow();
                node = super.getNextSibling();
            }
            return node;
        }
    }
}

