/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.graph.servlets;

import org.apache.zookeeper.graph.FilterOp;
import org.apache.zookeeper.graph.FilterParser;
import org.apache.zookeeper.graph.JsonGenerator;
import org.apache.zookeeper.graph.LogIterator;
import org.apache.zookeeper.graph.LogSource;
import org.apache.zookeeper.graph.servlets.JsonServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphData
extends JsonServlet {
    private static final Logger LOG = LoggerFactory.getLogger(GraphData.class);
    private static final int DEFAULT_PERIOD = 1000;
    private LogSource source = null;

    public GraphData(LogSource src) throws Exception {
        this.source = src;
    }

    @Override
    String handleRequest(JsonServlet.JsonRequest request) throws Exception {
        long starttime = 0L;
        long endtime = 0L;
        long period = 0L;
        FilterOp fo = null;
        starttime = request.getNumber("start", 0L);
        endtime = request.getNumber("end", 0L);
        period = request.getNumber("period", 0L);
        String filterstr = request.getString("filter", "");
        if (filterstr.length() > 0) {
            fo = new FilterParser(filterstr).parse();
        }
        if (starttime == 0L) {
            starttime = this.source.getStartTime();
        }
        if (endtime == 0L) {
            endtime = period > 0L ? starttime + period : starttime + 1000L;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("handle(start= " + starttime + ", end=" + endtime + ", period=" + period + ")");
        }
        LogIterator iterator = fo != null ? this.source.iterator(starttime, endtime, fo) : this.source.iterator(starttime, endtime);
        return new JsonGenerator(iterator).toString();
    }
}

