/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.settings;

import com.datastax.driver.core.Host;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.stress.settings.GroupedOptions;
import org.apache.cassandra.stress.settings.Option;
import org.apache.cassandra.stress.settings.OptionSimple;
import org.apache.cassandra.stress.settings.StressSettings;

public class SettingsNode
implements Serializable {
    public final List<String> nodes;
    public final boolean isWhiteList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsNode(Options options) {
        block7: {
            if (options.file.setByUser()) {
                try {
                    ArrayList<String> tmpNodes = new ArrayList<String>();
                    try (BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(options.file.value())));){
                        String node;
                        while ((node = in.readLine()) != null) {
                            if (node.length() <= 0) continue;
                            tmpNodes.add(node);
                        }
                        this.nodes = Arrays.asList(tmpNodes.toArray(new String[tmpNodes.size()]));
                        break block7;
                    }
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
            this.nodes = Arrays.asList(options.list.value().split(","));
        }
        this.isWhiteList = options.whitelist.setByUser();
    }

    public Set<String> resolveAllPermitted(StressSettings settings) {
        HashSet<String> r = new HashSet<String>();
        switch (settings.mode.api) {
            case THRIFT_SMART: 
            case JAVA_DRIVER_NATIVE: {
                if (!this.isWhiteList) {
                    for (Host host : settings.getJavaDriverClient().getCluster().getMetadata().getAllHosts()) {
                        r.add(host.getAddress().getHostName());
                    }
                    break;
                }
            }
            case THRIFT: 
            case SIMPLE_NATIVE: {
                for (InetAddress address : this.resolveAllSpecified()) {
                    r.add(address.getHostName());
                }
                break;
            }
        }
        return r;
    }

    public Set<InetAddress> resolveAllSpecified() {
        HashSet<InetAddress> r = new HashSet<InetAddress>();
        for (String node : this.nodes) {
            try {
                r.add(InetAddress.getByName(node));
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
        return r;
    }

    public Set<InetSocketAddress> resolveAll(int port) {
        HashSet<InetSocketAddress> r = new HashSet<InetSocketAddress>();
        for (String node : this.nodes) {
            try {
                r.add(new InetSocketAddress(InetAddress.getByName(node), port));
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
        return r;
    }

    public String randomNode() {
        int index = (int)(Math.random() * (double)this.nodes.size());
        if (index >= this.nodes.size()) {
            index = this.nodes.size() - 1;
        }
        return this.nodes.get(index);
    }

    public static SettingsNode get(Map<String, String[]> clArgs) {
        String[] params = clArgs.remove("-node");
        if (params == null) {
            return new SettingsNode(new Options());
        }
        GroupedOptions options = GroupedOptions.select((String[])params, (GroupedOptions[])new Options[]{new Options()});
        if (options == null) {
            SettingsNode.printHelp();
            System.out.println("Invalid -node options provided, see output for valid options");
            System.exit(1);
        }
        return new SettingsNode((Options)options);
    }

    public static void printHelp() {
        GroupedOptions.printOptions(System.out, "-node", new Options());
    }

    public static Runnable helpPrinter() {
        return new Runnable(){

            @Override
            public void run() {
                SettingsNode.printHelp();
            }
        };
    }

    public static final class Options
    extends GroupedOptions {
        final OptionSimple whitelist = new OptionSimple("whitelist", "", null, "Limit communications to the provided nodes", false);
        final OptionSimple file = new OptionSimple("file=", ".*", null, "Node file (one per line)", false);
        final OptionSimple list = new OptionSimple("", "[^=,]+(,[^=,]+)*", "localhost", "comma delimited list of nodes", false);

        @Override
        public List<? extends Option> options() {
            return Arrays.asList(this.whitelist, this.file, this.list);
        }
    }
}

