/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.operations.userdefined;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TableMetadata;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.stress.Operation;
import org.apache.cassandra.stress.generate.Distribution;
import org.apache.cassandra.stress.generate.DistributionFixed;
import org.apache.cassandra.stress.generate.PartitionGenerator;
import org.apache.cassandra.stress.generate.PartitionIterator;
import org.apache.cassandra.stress.generate.Row;
import org.apache.cassandra.stress.generate.Seed;
import org.apache.cassandra.stress.generate.SeedManager;
import org.apache.cassandra.stress.operations.PartitionOperation;
import org.apache.cassandra.stress.report.Timer;
import org.apache.cassandra.stress.settings.StressSettings;
import org.apache.cassandra.stress.util.JavaDriverClient;
import org.apache.cassandra.stress.util.ThriftClient;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.Compression;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.CqlRow;
import org.apache.cassandra.thrift.ThriftConversion;
import org.apache.cassandra.utils.Pair;
import org.apache.thrift.TException;

public class ValidatingSchemaQuery
extends PartitionOperation {
    private Pair<Row, Row> bounds;
    final int clusteringComponents;
    final ValidatingStatement[] statements;
    final ConsistencyLevel cl;
    final int[] argumentIndex;
    final Object[] bindBuffer;

    private ValidatingSchemaQuery(Timer timer, StressSettings settings, PartitionGenerator generator, SeedManager seedManager, ValidatingStatement[] statements, ConsistencyLevel cl, int clusteringComponents) {
        super(timer, settings, new PartitionOperation.DataSpec(generator, seedManager, (Distribution)new DistributionFixed(1L), settings.insert.rowPopulationRatio.get(), 1));
        this.statements = statements;
        this.cl = cl;
        this.argumentIndex = new int[statements[0].statement.getVariables().size()];
        this.bindBuffer = new Object[this.argumentIndex.length];
        int i = 0;
        for (ColumnDefinitions.Definition definition : statements[0].statement.getVariables()) {
            this.argumentIndex[i++] = this.spec.partitionGenerator.indexOf(definition.getName());
        }
        for (ValidatingStatement statement : statements) {
            statement.statement.setConsistencyLevel(JavaDriverClient.from(cl));
        }
        this.clusteringComponents = clusteringComponents;
    }

    @Override
    protected boolean reset(Seed seed, PartitionIterator iterator) {
        this.bounds = iterator.resetToBounds(seed, this.clusteringComponents);
        return true;
    }

    BoundStatement bind(int statementIndex) {
        int pkc = ((Row)this.bounds.left).partitionKey.length;
        System.arraycopy(((Row)this.bounds.left).partitionKey, 0, this.bindBuffer, 0, pkc);
        int ccc = ((Row)this.bounds.left).row.length;
        System.arraycopy(((Row)this.bounds.left).row, 0, this.bindBuffer, pkc, ccc);
        System.arraycopy(((Row)this.bounds.right).row, 0, this.bindBuffer, pkc + ccc, ccc);
        return this.statements[statementIndex].statement.bind(this.bindBuffer);
    }

    List<ByteBuffer> thriftArgs() {
        int i;
        ArrayList<ByteBuffer> args = new ArrayList<ByteBuffer>();
        int pkc = ((Row)this.bounds.left).partitionKey.length;
        for (int i2 = 0; i2 < pkc; ++i2) {
            args.add(this.spec.partitionGenerator.convert(-i2, ((Row)this.bounds.left).partitionKey[i2]));
        }
        int ccc = ((Row)this.bounds.left).row.length;
        for (i = 0; i < ccc; ++i) {
            args.add(this.spec.partitionGenerator.convert(i, ((Row)this.bounds.left).get(i)));
        }
        for (i = 0; i < ccc; ++i) {
            args.add(this.spec.partitionGenerator.convert(i, ((Row)this.bounds.right).get(i)));
        }
        return args;
    }

    @Override
    public void run(JavaDriverClient client) throws IOException {
        this.timeWithRetry(new JavaDriverRun(client, (PartitionIterator)this.partitions.get(0)));
    }

    @Override
    public void run(ThriftClient client) throws IOException {
        this.timeWithRetry(new ThriftRun(client, (PartitionIterator)this.partitions.get(0)));
    }

    public static List<Factory> create(TableMetadata metadata, StressSettings settings) {
        ArrayList<Factory> factories = new ArrayList<Factory>();
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        sb.append("SELECT * FROM ");
        sb.append(metadata.getName());
        sb.append(" WHERE");
        for (ColumnMetadata pk : metadata.getPartitionKey()) {
            sb.append(first ? " " : " AND ");
            sb.append(pk.getName());
            sb.append(" = ?");
            first = false;
        }
        String base = sb.toString();
        factories.add(new Factory(new ValidatingStatement[]{ValidatingSchemaQuery.prepare(settings, base, true, true)}, 0));
        int maxDepth = metadata.getClusteringColumns().size() - 1;
        for (int depth = 0; depth <= maxDepth; ++depth) {
            boolean[] blArray;
            StringBuilder cc = new StringBuilder();
            StringBuilder arg = new StringBuilder();
            cc.append('(');
            arg.append('(');
            for (int d = 0; d <= depth; ++d) {
                if (d > 0) {
                    cc.append(',');
                    arg.append(',');
                }
                cc.append(((ColumnMetadata)metadata.getClusteringColumns().get(d)).getName());
                arg.append('?');
            }
            cc.append(')');
            arg.append(')');
            ValidatingStatement[] statements = new ValidatingStatement[depth < maxDepth ? 1 : 4];
            int i = 0;
            if (depth < maxDepth) {
                boolean[] blArray2 = new boolean[1];
                blArray = blArray2;
                blArray2[0] = true;
            } else {
                boolean[] blArray3 = new boolean[2];
                blArray3[0] = true;
                blArray = blArray3;
                blArray3[1] = false;
            }
            for (boolean incLb : blArray) {
                boolean[] blArray4;
                if (depth < maxDepth) {
                    boolean[] blArray5 = new boolean[1];
                    blArray4 = blArray5;
                    blArray5[0] = false;
                } else {
                    boolean[] blArray6 = new boolean[2];
                    blArray6[0] = true;
                    blArray4 = blArray6;
                    blArray6[1] = false;
                }
                for (boolean incUb : blArray4) {
                    String lb = incLb ? ">=" : ">";
                    String ub = incUb ? "<=" : "<";
                    sb.setLength(0);
                    sb.append(base);
                    sb.append(" AND ");
                    sb.append((CharSequence)cc);
                    sb.append(lb);
                    sb.append((CharSequence)arg);
                    sb.append(" AND ");
                    sb.append((CharSequence)cc);
                    sb.append(ub);
                    sb.append((CharSequence)arg);
                    statements[i++] = ValidatingSchemaQuery.prepare(settings, sb.toString(), incLb, incUb);
                }
            }
            factories.add(new Factory(statements, depth + 1));
        }
        return factories;
    }

    private static ValidatingStatement prepare(StressSettings settings, String cql, boolean incLb, boolean incUb) {
        JavaDriverClient jclient = settings.getJavaDriverClient();
        ThriftClient tclient = settings.getThriftClient();
        PreparedStatement statement = jclient.prepare(cql);
        try {
            Integer thriftId = tclient.prepare_cql3_query(cql, Compression.NONE);
            return new ValidatingStatement(statement, thriftId, incLb, incUb);
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
    }

    private static class ValidatingStatement {
        final PreparedStatement statement;
        final Integer thriftId;
        final boolean inclusiveStart;
        final boolean inclusiveEnd;

        private ValidatingStatement(PreparedStatement statement, Integer thriftId, boolean inclusiveStart, boolean inclusiveEnd) {
            this.statement = statement;
            this.thriftId = thriftId;
            this.inclusiveStart = inclusiveStart;
            this.inclusiveEnd = inclusiveEnd;
        }
    }

    public static class Factory {
        final ValidatingStatement[] statements;
        final int clusteringComponents;

        public Factory(ValidatingStatement[] statements, int clusteringComponents) {
            this.statements = statements;
            this.clusteringComponents = clusteringComponents;
        }

        public ValidatingSchemaQuery create(Timer timer, StressSettings settings, PartitionGenerator generator, SeedManager seedManager, ConsistencyLevel cl) {
            return new ValidatingSchemaQuery(timer, settings, generator, seedManager, this.statements, cl, this.clusteringComponents);
        }
    }

    private class ThriftRun
    extends Runner {
        final ThriftClient client;

        private ThriftRun(ThriftClient client, PartitionIterator iter) {
            super(iter);
            this.client = client;
        }

        @Override
        public boolean run() throws Exception {
            CqlResult rs = this.client.execute_prepared_cql3_query(ValidatingSchemaQuery.this.statements[this.statementIndex].thriftId, ((PartitionIterator)ValidatingSchemaQuery.this.partitions.get(0)).getToken(), ValidatingSchemaQuery.this.thriftArgs(), ThriftConversion.toThrift((ConsistencyLevel)ValidatingSchemaQuery.this.cl));
            int[] valueIndex = new int[rs.getSchema().name_types.size()];
            for (int i = 0; i < valueIndex.length; ++i) {
                valueIndex[i] = ((ValidatingSchemaQuery)ValidatingSchemaQuery.this).spec.partitionGenerator.indexOf(rs.fieldForId(i).getFieldName());
            }
            int r = 0;
            if (!ValidatingSchemaQuery.this.statements[this.statementIndex].inclusiveStart && this.iter.hasNext()) {
                this.iter.next();
            }
            while (this.iter.hasNext()) {
                Row expectedRow = (Row)this.iter.next();
                if (!ValidatingSchemaQuery.this.statements[this.statementIndex].inclusiveEnd && !this.iter.hasNext()) break;
                if (r == rs.num) {
                    return false;
                }
                ++this.rowCount;
                CqlRow actualRow = (CqlRow)rs.getRows().get(r++);
                for (int i = 0; i < actualRow.getColumnsSize(); ++i) {
                    ByteBuffer actualValue;
                    ByteBuffer expectedValue = ((ValidatingSchemaQuery)ValidatingSchemaQuery.this).spec.partitionGenerator.convert(valueIndex[i], expectedRow.get(valueIndex[i]));
                    if (expectedValue.equals(actualValue = ((Column)actualRow.getColumns().get((int)i)).value)) continue;
                    return false;
                }
            }
            assert (r == rs.num);
            this.partitionCount = Math.min(1, this.rowCount);
            return true;
        }
    }

    private class JavaDriverRun
    extends Runner {
        final JavaDriverClient client;

        private JavaDriverRun(JavaDriverClient client, PartitionIterator iter) {
            super(iter);
            this.client = client;
        }

        @Override
        public boolean run() throws Exception {
            ResultSet rs = this.client.getSession().execute((Statement)ValidatingSchemaQuery.this.bind(this.statementIndex));
            int[] valueIndex = new int[rs.getColumnDefinitions().size()];
            int i = 0;
            for (ColumnDefinitions.Definition definition : rs.getColumnDefinitions()) {
                valueIndex[i++] = ((ValidatingSchemaQuery)ValidatingSchemaQuery.this).spec.partitionGenerator.indexOf(definition.getName());
            }
            this.rowCount = 0;
            Iterator results = rs.iterator();
            if (!ValidatingSchemaQuery.this.statements[this.statementIndex].inclusiveStart && this.iter.hasNext()) {
                this.iter.next();
            }
            while (this.iter.hasNext()) {
                Row expectedRow = (Row)this.iter.next();
                if (!ValidatingSchemaQuery.this.statements[this.statementIndex].inclusiveEnd && !this.iter.hasNext()) break;
                if (!results.hasNext()) {
                    return false;
                }
                ++this.rowCount;
                com.datastax.driver.core.Row actualRow = (com.datastax.driver.core.Row)results.next();
                for (int i2 = 0; i2 < actualRow.getColumnDefinitions().size(); ++i2) {
                    Object actualValue;
                    Object expectedValue = expectedRow.get(valueIndex[i2]);
                    if (expectedValue.equals(actualValue = ((ValidatingSchemaQuery)ValidatingSchemaQuery.this).spec.partitionGenerator.convert(valueIndex[i2], actualRow.getBytesUnsafe(i2)))) continue;
                    return false;
                }
            }
            this.partitionCount = Math.min(1, this.rowCount);
            return rs.isExhausted();
        }
    }

    abstract class Runner
    implements Operation.RunOp {
        int partitionCount;
        int rowCount;
        final PartitionIterator iter;
        final int statementIndex;

        protected Runner(PartitionIterator iter) {
            this.iter = iter;
            this.statementIndex = ThreadLocalRandom.current().nextInt(ValidatingSchemaQuery.this.statements.length);
        }

        @Override
        public int partitionCount() {
            return this.partitionCount;
        }

        @Override
        public int rowCount() {
            return this.rowCount;
        }
    }
}

