/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.ArraySizingStrategy;

public final class BoundedProportionalArraySizingStrategy
implements ArraySizingStrategy {
    public static final int MAX_ARRAY_SIZE = Integer.MAX_VALUE;
    public static final int DEFAULT_MIN_GROW_COUNT = 10;
    public static final int DEFAULT_MAX_GROW_COUNT = Integer.MAX_VALUE;
    public static final float DEFAULT_GROW_RATIO = 1.5f;
    public final int minGrowCount;
    public final int maxGrowCount;
    public final float growRatio;

    public BoundedProportionalArraySizingStrategy() {
        this(10, Integer.MAX_VALUE, 1.5f);
    }

    public BoundedProportionalArraySizingStrategy(int minGrow, int maxGrow, float ratio) {
        assert (minGrow >= 1) : "Min grow must be >= 1.";
        assert (maxGrow >= minGrow) : "Max grow must be >= min grow.";
        assert (ratio >= 1.0f) : "Growth ratio must be >= 1 (was " + ratio + ").";
        this.minGrowCount = minGrow;
        this.maxGrowCount = maxGrow;
        this.growRatio = ratio - 1.0f;
    }

    @Override
    public int grow(int currentBufferLength, int elementsCount, int expectedAdditions) {
        long growBy = (long)((float)currentBufferLength * this.growRatio);
        growBy = Math.max(growBy, (long)this.minGrowCount);
        long growTo = Math.min(Integer.MAX_VALUE, (growBy = Math.min(growBy, (long)this.maxGrowCount)) + (long)currentBufferLength);
        long newSize = Math.max((long)elementsCount + (long)expectedAdditions, growTo);
        if (newSize > Integer.MAX_VALUE) {
            throw new AssertionError((Object)("Cannot resize beyond 2147483647 (" + (elementsCount + expectedAdditions) + ")"));
        }
        return (int)newSize;
    }

    @Override
    public int round(int capacity) {
        assert (capacity >= 0) : "Capacity must be a positive number.";
        return capacity;
    }
}

