/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.concurrenttrees.common;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class LazyIterator<T>
implements Iterator<T> {
    T next = null;
    State state = State.NOT_READY;

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Iterator.remove() is not supported");
    }

    @Override
    public final boolean hasNext() {
        if (this.state == State.FAILED) {
            throw new IllegalStateException("This iterator is in an inconsistent state, and can no longer be used, due to an exception previously thrown by the computeNext() method");
        }
        switch (this.state) {
            case DONE: {
                return false;
            }
            case READY: {
                return true;
            }
        }
        return this.tryToComputeNext();
    }

    boolean tryToComputeNext() {
        this.state = State.FAILED;
        this.next = this.computeNext();
        if (this.state != State.DONE) {
            this.state = State.READY;
            return true;
        }
        return false;
    }

    @Override
    public final T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.state = State.NOT_READY;
        return this.next;
    }

    protected final T endOfData() {
        this.state = State.DONE;
        return null;
    }

    protected abstract T computeNext();

    static enum State {
        READY,
        NOT_READY,
        DONE,
        FAILED;

    }
}

