/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.ajp;

import java.util.regex.Pattern;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.Processor;
import org.apache.coyote.ajp.AbstractAjpProcessor;
import org.apache.coyote.http11.upgrade.UpgradeInbound;
import org.apache.coyote.http11.upgrade.servlet31.HttpUpgradeHandler;
import org.apache.tomcat.util.net.SocketWrapper;
import org.apache.tomcat.util.res.StringManager;

public abstract class AbstractAjpProtocol<S>
extends AbstractProtocol<S> {
    protected static final StringManager sm = StringManager.getManager(AbstractAjpProtocol.class);
    protected boolean ajpFlush = true;
    protected boolean tomcatAuthentication = true;
    private boolean tomcatAuthorization = false;
    protected String requiredSecret = null;
    private String secret = null;
    private boolean secretRequired = true;
    private Pattern allowedRequestAttributesPatternPattern;
    protected int packetSize = 8192;

    @Override
    protected String getProtocolName() {
        return "Ajp";
    }

    public boolean getAjpFlush() {
        return this.ajpFlush;
    }

    public void setAjpFlush(boolean ajpFlush) {
        this.ajpFlush = ajpFlush;
    }

    public boolean getTomcatAuthentication() {
        return this.tomcatAuthentication;
    }

    public void setTomcatAuthentication(boolean tomcatAuthentication) {
        this.tomcatAuthentication = tomcatAuthentication;
    }

    public boolean getTomcatAuthorization() {
        return this.tomcatAuthorization;
    }

    public void setTomcatAuthorization(boolean tomcatAuthorization) {
        this.tomcatAuthorization = tomcatAuthorization;
    }

    public void setSecret(String secret) {
        this.secret = secret;
        this.requiredSecret = secret;
    }

    protected String getSecret() {
        return this.secret;
    }

    @Deprecated
    public void setRequiredSecret(String requiredSecret) {
        this.setSecret(requiredSecret);
    }

    @Deprecated
    protected String getRequiredSecret() {
        return this.getSecret();
    }

    public void setSecretRequired(boolean secretRequired) {
        this.secretRequired = secretRequired;
    }

    public boolean getSecretRequired() {
        return this.secretRequired;
    }

    public void setAllowedRequestAttributesPattern(String allowedRequestAttributesPattern) {
        this.allowedRequestAttributesPatternPattern = Pattern.compile(allowedRequestAttributesPattern);
    }

    public String getAllowedRequestAttributesPattern() {
        return this.allowedRequestAttributesPatternPattern.pattern();
    }

    protected Pattern getAllowedRequestAttributesPatternPattern() {
        return this.allowedRequestAttributesPatternPattern;
    }

    public int getPacketSize() {
        return this.packetSize;
    }

    public void setPacketSize(int packetSize) {
        this.packetSize = packetSize < 8192 ? 8192 : packetSize;
    }

    @Override
    public void start() throws Exception {
        String secret;
        if (this.getSecretRequired() && ((secret = this.getSecret()) == null || secret.length() == 0)) {
            throw new IllegalArgumentException(sm.getString("ajpprotocol.noSecret"));
        }
        super.start();
    }

    protected static abstract class AbstractAjpConnectionHandler<S, P extends AbstractAjpProcessor<S>>
    extends AbstractProtocol.AbstractConnectionHandler<S, P> {
        protected AbstractAjpConnectionHandler() {
        }

        @Override
        protected void initSsl(SocketWrapper<S> socket, Processor<S> processor) {
        }

        @Override
        protected void longPoll(SocketWrapper<S> socket, Processor<S> processor) {
            socket.setAsync(true);
        }

        @Deprecated
        protected P createUpgradeProcessor(SocketWrapper<S> socket, UpgradeInbound inbound) {
            return null;
        }

        protected P createUpgradeProcessor(SocketWrapper<S> socket, HttpUpgradeHandler httpUpgradeHandler) {
            return null;
        }
    }
}

