/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp.datasources;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.tomcat.dbcp.dbcp.datasources.PooledConnectionAndInfo;
import org.apache.tomcat.dbcp.dbcp.datasources.PooledConnectionManager;
import org.apache.tomcat.dbcp.dbcp.datasources.UserPassKey;
import org.apache.tomcat.dbcp.pool.KeyedObjectPool;
import org.apache.tomcat.dbcp.pool.KeyedPoolableObjectFactory;

class KeyedCPDSConnectionFactory
implements KeyedPoolableObjectFactory<UserPassKey, PooledConnectionAndInfo>,
ConnectionEventListener,
PooledConnectionManager {
    private static final String NO_KEY_MESSAGE = "close() was called on a Connection, but I have no record of the underlying PooledConnection.";
    private final ConnectionPoolDataSource _cpds;
    private final String _validationQuery;
    private final boolean _rollbackAfterValidation;
    private final KeyedObjectPool<UserPassKey, PooledConnectionAndInfo> _pool;
    private final Set<PooledConnection> validatingSet = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<PooledConnection, PooledConnectionAndInfo> pcMap = new ConcurrentHashMap<PooledConnection, PooledConnectionAndInfo>();

    public KeyedCPDSConnectionFactory(ConnectionPoolDataSource cpds, KeyedObjectPool<UserPassKey, PooledConnectionAndInfo> pool, String validationQuery) {
        this(cpds, pool, validationQuery, false);
    }

    public KeyedCPDSConnectionFactory(ConnectionPoolDataSource cpds, KeyedObjectPool<UserPassKey, PooledConnectionAndInfo> pool, String validationQuery, boolean rollbackAfterValidation) {
        this._cpds = cpds;
        this._pool = pool;
        pool.setFactory(this);
        this._validationQuery = validationQuery;
        this._rollbackAfterValidation = rollbackAfterValidation;
    }

    public KeyedObjectPool<UserPassKey, PooledConnectionAndInfo> getPool() {
        return this._pool;
    }

    @Override
    public synchronized PooledConnectionAndInfo makeObject(UserPassKey upkey) throws Exception {
        PooledConnectionAndInfo obj = null;
        PooledConnection pc = null;
        String username = upkey.getUsername();
        String password = upkey.getPassword();
        pc = username == null ? this._cpds.getPooledConnection() : this._cpds.getPooledConnection(username, password);
        if (pc == null) {
            throw new IllegalStateException("Connection pool data source returned null from getPooledConnection");
        }
        pc.addConnectionEventListener(this);
        obj = new PooledConnectionAndInfo(pc, username, password);
        this.pcMap.put(pc, obj);
        return obj;
    }

    @Override
    public void destroyObject(UserPassKey key, PooledConnectionAndInfo obj) throws Exception {
        PooledConnection pc = obj.getPooledConnection();
        pc.removeConnectionEventListener(this);
        this.pcMap.remove(pc);
        pc.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean validateObject(UserPassKey key, PooledConnectionAndInfo obj) {
        boolean valid = false;
        PooledConnection pconn = obj.getPooledConnection();
        String query = this._validationQuery;
        if (null == query) return true;
        Connection conn = null;
        Statement stmt = null;
        ResultSet rset = null;
        this.validatingSet.add(pconn);
        try {
            conn = pconn.getConnection();
            stmt = conn.createStatement();
            rset = stmt.executeQuery(query);
            valid = rset.next();
            if (!this._rollbackAfterValidation) return valid;
            conn.rollback();
            return valid;
        }
        catch (Exception e) {
            valid = false;
            return valid;
        }
        finally {
            if (rset != null) {
                try {
                    rset.close();
                }
                catch (Throwable t) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable t) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Throwable t) {}
            }
            this.validatingSet.remove(pconn);
        }
    }

    @Override
    public void passivateObject(UserPassKey key, PooledConnectionAndInfo obj) {
    }

    @Override
    public void activateObject(UserPassKey key, PooledConnectionAndInfo obj) {
    }

    @Override
    public void connectionClosed(ConnectionEvent event) {
        PooledConnection pc = (PooledConnection)event.getSource();
        if (!this.validatingSet.contains(pc)) {
            PooledConnectionAndInfo info = this.pcMap.get(pc);
            if (info == null) {
                throw new IllegalStateException(NO_KEY_MESSAGE);
            }
            try {
                this._pool.returnObject(info.getUserPassKey(), info);
            }
            catch (Exception e) {
                System.err.println("CLOSING DOWN CONNECTION AS IT COULD NOT BE RETURNED TO THE POOL");
                pc.removeConnectionEventListener(this);
                try {
                    this._pool.invalidateObject(info.getUserPassKey(), info);
                }
                catch (Exception e3) {
                    System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + info);
                    e3.printStackTrace();
                }
            }
        }
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent event) {
        PooledConnection pc = (PooledConnection)event.getSource();
        if (null != event.getSQLException()) {
            System.err.println("CLOSING DOWN CONNECTION DUE TO INTERNAL ERROR (" + event.getSQLException() + ")");
        }
        pc.removeConnectionEventListener(this);
        PooledConnectionAndInfo info = this.pcMap.get(pc);
        if (info == null) {
            throw new IllegalStateException(NO_KEY_MESSAGE);
        }
        try {
            this._pool.invalidateObject(info.getUserPassKey(), info);
        }
        catch (Exception e) {
            System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + info);
            e.printStackTrace();
        }
    }

    @Override
    public void invalidate(PooledConnection pc) throws SQLException {
        PooledConnectionAndInfo info = this.pcMap.get(pc);
        if (info == null) {
            throw new IllegalStateException(NO_KEY_MESSAGE);
        }
        UserPassKey key = info.getUserPassKey();
        try {
            this._pool.invalidateObject(key, info);
            this._pool.clear(key);
        }
        catch (Exception ex) {
            throw (SQLException)new SQLException("Error invalidating connection").initCause(ex);
        }
    }

    @Override
    public void setPassword(String password) {
    }

    @Override
    public void closePool(String username) throws SQLException {
        try {
            this._pool.clear(new UserPassKey(username, null));
        }
        catch (Exception ex) {
            throw (SQLException)new SQLException("Error closing connection pool").initCause(ex);
        }
    }
}

