/*
 * AppleRecords - A DAAP client
 * Copyright (C) 2004  Chris Davies <c.davies@cdavies.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package org.cdavies.applerecords;

import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import javax.swing.table.*;
import java.util.*;

import org.cdavies.applerecords.table.*;
import org.cdavies.itunes.rendezvous.*;
import org.cdavies.itunes.*;
import org.cdavies.applerecords.search.*;

import java.net.*;

/**
 * 
 * The main class of the AppleRecords software.
 * <p>
 * AppleRecords is a DAAP client, designed to stream music from iTunes
 * and other, compatible DAAP servers. It is currently compatible with all
 * three known DAAP versions.
 * <p>
 * This class contructs the main panel of AppleRecords, starts the
 * Rendezvous resolver, then sits around waiting for events.
 * 
 * 
 * @author       Chris Davies (c.davies@cdavies.org)
 * @version      0.5 21/06/2004
 *
 */

public class AppleRecordsPanel extends JPanel {
	
	private AppleRecordsServerControl _serverControl;
	private AppleRecordsStatusPanel _status;
	
	private ItunesListener _resolver;
	
       /**
	* 
	* Constructs a new AppleRecords client. Basically, this does most everything
	* (yes, I know, I know). It lays out the panel, adds various listeners and 
	* other such tasks, then finally starts the rendezvous resolver.
	* <p>
	* I will, soonish, do something about the general horridness of this method.
	* Just thank whatever deity you believe in I don't believe in writing action
	* listeners inline.
	* 
	* @exception Exception could throw a whole bunch of fatal exception, we can't recover so resolution is pointless
	*
	*/
	
	public AppleRecordsPanel() throws Exception {
		
		
		JFrame frame = new JFrame("AppleRecords");
		
		_status = new AppleRecordsStatusPanel(this);
		
		TrackListTableModel model = new TrackListTableModel();
		
		
		//TableSorter sorter = new TableSorter(model);
		JTable trackTable = new JTable(model);
		
		setLayout(new GridBagLayout());
		
		GridBagConstraints _cons;
		
		_cons = new GridBagConstraints();
		_cons.gridx = 0;
		_cons.gridy = 0;
		_cons.weightx = 0;
		_cons.weighty = 0;
		_cons.insets = new Insets(2, 2, 2, 2);
		
		AppleRecordsControlPanel _control = new AppleRecordsControlPanel(trackTable, model, _status);
		trackTable.addMouseListener(new TrackListTableMouseListener(_control));
		
		add(_control, _cons);
		
		_cons = new GridBagConstraints();
		_cons.gridx = 1;
		_cons.gridy = 0;
		_cons.weightx = 1;
		_cons.weighty = 0;
		_cons.fill = GridBagConstraints.HORIZONTAL;
		_cons.insets = new Insets(5, 5, 5, 5);
		
		AppleRecordsSearchPanel _sp = new AppleRecordsSearchPanel();
		add(_sp, _cons);
		
		_cons = new GridBagConstraints();
		_cons.gridx = 2;
		_cons.gridy = 0;
		_cons.weightx = 1;
		_cons.weighty = 0;
		
		
		trackTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		
		for (int i = 0; i < 3; i++) {
				TableColumn column = trackTable.getColumnModel().getColumn(i);
				column.setCellRenderer(new TrackListTableRenderer());
				if (i == 2) {
					column.setPreferredWidth(310);
				} else if (i==0||i==1){
					column.setPreferredWidth(160);
				}
			}
		
		setOpaque(true);
		
		
		
		trackTable.validate();
		JScrollPane scroller = new JScrollPane(trackTable);
		
		_cons = new GridBagConstraints();
		_cons.gridx = 0;
		_cons.gridy = 1;
		_cons.weightx = 1;
		_cons.weighty = 1;
		_cons.gridwidth = 2;
		_cons.fill = GridBagConstraints.BOTH;
		
		add(scroller, _cons);
		
		_serverControl = new AppleRecordsServerControl();
		_serverControl.addActionListener(new ServerControlActionListener(model, trackTable, _status, _control));
		_sp.addSearchActionListener(new SearchPanelActionListener(model, trackTable, _status, _control, _serverControl));
		
		_cons = new GridBagConstraints();
		_cons.gridx = 0;
		_cons.gridy = 2;
		_cons.weightx = 1;
		_cons.weighty = 0;
		_cons.gridwidth = 2;
		_cons.fill = GridBagConstraints.HORIZONTAL;
		
		add(_serverControl, _cons);
		
		
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setContentPane(_status);
		frame.pack();
		frame.setVisible(true);
		
		startItunesListener();
		
	}
	
	private void startItunesListener() {
		
		/* TODO : UNHARDCODE MY ADDRESS!!!! */
		
		try {
		
			//_resolver = new ItunesListener(InetAddress.getByName("0.0.0.0"), _serverControl, _status);
			_resolver = new ItunesListener(null, _serverControl, _status);
			
		}
		catch (Exception _e) {
			
			System.err.println("Error: Cannot Start The Rendevouz Resolver");
			System.exit(1);
			
		}
		
	}
	
	public static void main(String[] args) {
		try {
		new AppleRecordsPanel();
		}
		catch(Exception e) {
			e.printStackTrace();
		}
		
	}
		
	
}
