package org.cdavies.itunes.request;

import java.net.*;
import java.io.*;

import itunes.FieldPair;

public class Itunes45UpdateRequest extends Request implements UpdateRequest {
	
	public Itunes45UpdateRequest(String server, int port, int sessionId, int revNum) {
		
		super(server, port, "update?session-id=" + sessionId + "&revision-number=" + revNum);
		
	}
	
	public void constructQuery() {
		
		URL _url = null;
		
		try {
			
			_url = new URL("http://"+server+":"+port+"/"+requestString);
			URLConnection _urlc = _url.openConnection();
			
			_urlc.addRequestProperty("Host", server);
            _urlc.addRequestProperty("Client-DAAP-Version", "3.0");
			_urlc.setRequestProperty("User-Agent", "AppleRecords");
			_urlc.addRequestProperty("Client-DAAP-Access-Index", "2");
			_urlc.addRequestProperty("Client-DAAP-Validation", hash.generateHash("/"+requestString, 2, -1));
			_conn = _urlc;
			
		}
		catch (Exception e) {
			
			/* Should never happen */
			_conn = null;
			
		}
		
	}
	
	
	public void runQuery() throws NoServerPermissionException {
		
		try {
			
			DataInputStream _in = new DataInputStream(_conn.getInputStream());
			
			int _len = _conn.getContentLength();
			
			if (_len == -1)
				return;
				
			
			data = new byte[_len];
			_in.readFully(data);
			
		} 
		catch (MalformedURLException _e) {
			
			/* Should never happen */
			_e.printStackTrace();
			System.exit(1);
			
		} 
		catch (IOException _e) {
			
			throw new NoServerPermissionException(_e.getMessage());
			
		}
		
	}
	
	public int getRevisionNumber() {
		
        int _index = fieldPairs.indexOf(new FieldPair("musr", new byte[0], 0, 0));
        if (_index == -1)
                return _index;
			
        FieldPair _fp = (FieldPair)fieldPairs.get(_index);
		
        return readInt(_fp.value, 0);
		
	}
	
}
