package org.cdavies.itunes.request;

import java.net.*;
import java.io.*;

import itunes.FieldPair;

public class LegacyLoginRequest extends Request implements LoginRequest {
	
	public LegacyLoginRequest(String server, int port) {
		
		super(server, port, "login");
		
	}
	
	
	public void runQuery() throws NoServerPermissionException {
		
		try {
			
			DataInputStream _in = new DataInputStream(_conn.getInputStream());
			
			int _len = _conn.getContentLength();
			
			if (_len == -1)
				return;
				
			
			data = new byte[_len];
			_in.readFully(data);
			
		} 
		catch (MalformedURLException _e) {
			
			/* Should never happen */
			_e.printStackTrace();
			System.exit(1);
			
		} 
		catch (IOException _e) {
			
			throw new NoServerPermissionException(_e.getMessage());
			
		}
		
	}
	
	public int getSessionId() {
		
		int _index = fieldPairs.indexOf(new FieldPair("mlid",new byte[0],0,0));
		
		if (_index == -1)
			return _index;
		
		FieldPair _fp = (FieldPair)fieldPairs.get(_index);
		
		return readInt(_fp.value, 0);
		
	}
	
}
