/* include/clib/queue.h.  Generated from queue.h.in by configure.  */
/*	$NetBSD: queue.h,v 1.49.6.1 2008/11/20 03:22:38 snj Exp $
 * Copyright (c) 2009 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Tonnerre Lombard <tonnerre@NetBSD.org>.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 *	@(#)queue.h	8.5 (Berkeley) 8/20/94
 */

#ifndef	_CLIB_QUEUE_H_
#define	_CLIB_QUEUE_H_

/*
 * This file defines five types of data structures: singly-linked lists,
 * lists, simple queues, tail queues, and circular queues.
 *
 * A singly-linked list is headed by a single forward pointer. The
 * elements are singly linked for minimum space and pointer manipulation
 * overhead at the expense of O(n) removal for arbitrary elements. New
 * elements can be added to the list after an existing element or at the
 * head of the list.  Elements being removed from the head of the list
 * should use the explicit macro for this purpose for optimum
 * efficiency. A singly-linked list may only be traversed in the forward
 * direction.  Singly-linked lists are ideal for applications with large
 * datasets and few or no removals or for implementing a LIFO queue.
 *
 * A list is headed by a single forward pointer (or an array of forward
 * pointers for a hash table header). The elements are doubly linked
 * so that an arbitrary element can be removed without a need to
 * traverse the list. New elements can be added to the list before
 * or after an existing element or at the head of the list. A list
 * may only be traversed in the forward direction.
 *
 * A simple queue is headed by a pair of pointers, one the head of the
 * list and the other to the tail of the list. The elements are singly
 * linked to save space, so elements can only be removed from the
 * head of the list. New elements can be added to the list after
 * an existing element, at the head of the list, or at the end of the
 * list. A simple queue may only be traversed in the forward direction.
 *
 * A tail queue is headed by a pair of pointers, one to the head of the
 * list and the other to the tail of the list. The elements are doubly
 * linked so that an arbitrary element can be removed without a need to
 * traverse the list. New elements can be added to the list before or
 * after an existing element, at the head of the list, or at the end of
 * the list. A tail queue may be traversed in either direction.
 *
 * A circle queue is headed by a pair of pointers, one to the head of the
 * list and the other to the tail of the list. The elements are doubly
 * linked so that an arbitrary element can be removed without a need to
 * traverse the list. New elements can be added to the list before or after
 * an existing element, at the head of the list, or at the end of the list.
 * A circle queue may be traversed in either direction, but has a more
 * complex end of list detection.
 *
 * For details on the use of these macros, see the queue(3) manual page.
 */

/*
 * List definitions.
 */
/* #undef LIST_HEAD */
/* #undef LIST_HEAD_INITIALIZER */
/* #undef LIST_ENTRY */

/*
 * List functions.
 */
/* #undef LIST_INIT */

/* #undef LIST_INSERT_AFTER */
/* #undef LIST_INSERT_BEFORE */
/* #undef LIST_INSERT_HEAD */
/* #undef LIST_REMOVE */
/* #undef LIST_FOREACH */

/*
 * List access methods.
 */
/* #undef LIST_EMPTY */
/* #undef LIST_FIRST */
/* #undef LIST_NEXT */


/*
 * Singly-linked List definitions.
 */
/* #undef SLIST_HEAD */
/* #undef SLIST_HEAD_INITIALIZER */
/* #undef SLIST_ENTRY */

/*
 * Singly-linked List functions.
 */
/* #undef SLIST_INIT */
/* #undef SLIST_INSERT_AFTER */
/* #undef SLIST_INSERT_HEAD */
/* #undef SLIST_REMOVE_HEAD */
/* #undef SLIST_REMOVE */
/* #undef SLIST_REMOVE_AFTER */
/* #undef SLIST_FOREACH */

/*
 * Singly-linked List access methods.
 */
/* #undef SLIST_EMPTY */
/* #undef SLIST_FIRST */
/* #undef SLIST_NEXT */


/*
 * Singly-linked Tail queue declarations.
 */
/* #undef STAILQ_HEAD */
/* #undef STAILQ_HEAD_INITIALIZER */
/* #undef STAILQ_ENTRY */

/*
 * Singly-linked Tail queue functions.
 */
/* #undef STAILQ_INIT */
/* #undef STAILQ_INSERT_HEAD */
/* #undef STAILQ_INSERT_TAIL */
/* #undef STAILQ_INSERT_AFTER */
/* #undef STAILQ_REMOVE_HEAD */
/* #undef STAILQ_REMOVE */
/* #undef STAILQ_FOREACH */
/* #undef STAILQ_CONCAT */

/*
 * Singly-linked Tail queue access methods.
 */
/* #undef STAILQ_EMPTY */
/* #undef STAILQ_FIRST */
/* #undef STAILQ_NEXT */


/*
 * Simple queue definitions.
 */
/* #undef SIMPLEQ_HEAD */
/* #undef SIMPLEQ_HEAD_INITIALIZER */
/* #undef SIMPLEQ_ENTRY */

/*
 * Simple queue functions.
 */
/* #undef SIMPLEQ_INIT */
/* #undef SIMPLEQ_INSERT_HEAD */
/* #undef SIMPLEQ_INSERT_TAIL */
/* #undef SIMPLEQ_INSERT_AFTER */
/* #undef SIMPLEQ_REMOVE_HEAD */
/* #undef SIMPLEQ_REMOVE */
/* #undef SIMPLEQ_FOREACH */

/*
 * Simple queue access methods.
 */
/* #undef SIMPLEQ_EMPTY */
/* #undef SIMPLEQ_FIRST */
/* #undef SIMPLEQ_NEXT */


/*
 * Tail queue definitions.
 */
/* #undef _TAILQ_HEAD */
/* #undef TAILQ_HEAD */
/* #undef TAILQ_HEAD_INITIALIZER */
/* #undef _TAILQ_ENTRY */
/* #undef TAILQ_ENTRY */

/*
 * Tail queue functions.
 */
/* #undef TAILQ_INIT */
/* #undef TAILQ_INSERT_HEAD */
/* #undef TAILQ_INSERT_TAIL */
/* #undef TAILQ_INSERT_AFTER */
/* #undef TAILQ_INSERT_BEFORE */
/* #undef TAILQ_REMOVE */
/* #undef TAILQ_FOREACH */
/* #undef TAILQ_FOREACH_SAFE */
/* #undef TAILQ_FOREACH_REVERSE */
/* #undef TAILQ_FOREACH_REVERSE_SAFE */
/* #undef TAILQ_CONCAT */

/*
 * Tail queue access methods.
 */
/* #undef TAILQ_EMPTY */
/* #undef TAILQ_FIRST */
/* #undef TAILQ_NEXT */
/* #undef TAILQ_LAST */
/* #undef TAILQ_PREV */


/*
 * Circular queue definitions.
 */
/* #undef CIRCLEQ_HEAD */
/* #undef CIRCLEQ_HEAD_INITIALIZER */
/* #undef CIRCLEQ_ENTRY */

/*
 * Circular queue functions.
 */
/* #undef CIRCLEQ_INIT */
/* #undef CIRCLEQ_INSERT_AFTER */
/* #undef CIRCLEQ_INSERT_BEFORE */
/* #undef CIRCLEQ_INSERT_HEAD */
/* #undef CIRCLEQ_INSERT_TAIL */
/* #undef CIRCLEQ_REMOVE */
/* #undef CIRCLEQ_FOREACH */
/* #undef CIRCLEQ_FOREACH_REVERSE */

/*
 * Circular queue access methods.
 */
/* #undef CIRCLEQ_EMPTY */
/* #undef CIRCLEQ_FIRST */
/* #undef CIRCLEQ_LAST */
/* #undef CIRCLEQ_NEXT */
/* #undef CIRCLEQ_PREV */

/* #undef CIRCLEQ_LOOP_NEXT */
/* #undef CIRCLEQ_LOOP_PREV */

#endif	/* !_CLIB_QUEUE_H_ */
