/*****
 NAME
 	pnet.h - protocols for the network operation classes
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#if !defined(PNET_H_INCLUDED)
#define PNET_H_INCLUDED

#include <coconut/pstream.h>
#include <coconut/gnet/tgnet.h>

@protocol PNetStream <PStream>
 - (id <PError>) openChannel: (GIOChannel *) channel ;
 - (id <PError>) closeChannel ;
@end

@protocol PNetClientAccess <PObject>
 - (id <PError>) open: (int) portnum server: (const char *) servername ;
 - (id <PError>) close ;
 - (boolean) isServer ;
@end

@protocol PNetServerAccess <PObject>
 - (id <PError>) open: (int) portnum connect: (boolean) doconnect ;
 - (id <PError>) close ;
 - (boolean) connect ;
 - (boolean) isServer ;
@end

@protocol PNetClient <PNetStream, PNetClientAccess>
@end

@protocol PNetServer <PNetStream, PNetServerAccess>
@end

/* see the protocol PAsyncIO in ./coconut/pstream.h */
@protocol PAsyncNet <PObject>
  - (void) setStream: (id <PStream>) input and: (id <PStream>) output ;
  - (id <PError>) closeChannel ;
  - (io_status_t) flush ;

  - (boolean) asyncIOEvent: (GIOChannel *) channel condition: (GIOCondition) 
      cond ;
  - (boolean) asyncInputEvent: (GIOChannel *) channel ;
  - (boolean) asyncOutputEvent: (GIOChannel *) channel ;
@end

@protocol PAsyncClientAccess <PObject>
 - (id <PError>) openToRead: (int) portnum server: (const char *) server
     output: (id <PStream>) output ;
 - (id <PError>) openToWrite: (int) portnum server: (const char *) server
     input: (id <PStream>) input ;
 - (id <PError>) close ;
 - (void) asyncConnect: (GTcpSocket *) socket addr: (GInetAddr *) addr
     status: (GTcpSocketConnectAsyncStatus) status ;
@end

@protocol PAsyncServerAccess <PObject>
 - (id <PError>) openToRead: (int) portnum output: (id <PStream>) output ;
 - (id <PError>) openToWrite: (int) portnum input: (id <PStream>) input ;
 - (id <PError>) close ;
 - (void) asyncConnect: (GTcpSocket *) server client: (GTcpSocket *) client ;
@end

@protocol PAsyncClient <PAsyncNet, PAsyncClientAccess>
@end

@protocol PAsyncServer <PAsyncNet, PAsyncServerAccess>
@end

#endif /* PNET_H_INCLUDED */

