/*****
 NAME
	pmath.h - protocols for Math classes
 VERSION
	$Id$
 CHANGELOG
	$Log$
 */

#if !defined(PMATH_H_INCLUDED)
#define PMATH_H_INCLUDED

#include <coconut/pstring.h>
#include <coconut/pset.h>
#include <coconut/perror.h>
#include <coconut/tmath.h>

@protocol PRandom
 /* the initialization of random seed is done in CSystem class */
 + initRandomSeed ;
 + (int) getRandomInt: (int) min to: (int) max ;
@end

@protocol PIntFactory
  + (id <PError>) binStrToUInt64: (const char *) str to: (u_int64_t *) result ;
    /* "dst" must have 66 bytes or more spaces */
  + (id <PError>) strToULong: (const char *) str to: (u_long *) result ;
  + (id <PError>) strToInt: (const char *) str to: (int *) result ;
  + (id <PError>) uInt64ToBinStr: (u_int64_t) value to: (char *) dst ;
@end

@protocol PRealFactory
 + (id <PError>) strToReal: (const char *) str to: (double *) result ;
@end

@protocol PNumber <PIdHashElm, PDebug>
 - (valtype_t) type ;

 - setObject: (id <PNumber>) obj ;
 - setBoolean: (boolean) value ;
 - setInt: (int) value ;
 - setReal: (double) value ;

 - (boolean) booleanNum ;
 - (int) intNum ;
 - (double) realNum ;

 - (id <PNumber>) addObject: (id <PNumber>) obj ;
 - (id <PNumber>) addBoolean: (boolean) value ;
 - (id <PNumber>) addInt: (int) value ;
 - (id <PNumber>) addReal: (double) value ;

 - (id <PNumber>) duplicate ;

 - (id <PString>) toString ;

@end

@protocol PExp <PIdHashElm, PDebug>
  - (exp_t) type ;
  - (obj_status_t) status ;

    /* this method returns nil when the object does not have a value to
       evaluate. do not deallocate the return value, "value" */
  - (id <PNumber>) eval ;

  - (id <PString>) toString ;
@end

@protocol PExpFactory
  + (id <PExp>) stringToExp: (id <PString>) str ;
@end

@protocol PExpConst <PExp>
  + newExpConstInt: (int) val format: (int_format_t) form ;
  + newExpConstReal: (double) val ;

  - setValue: (id <PNumber>) value ;
@end

@protocol PExpVar <PExp>
  - (id <PConstStr>) name ;
  - setName: (id <PConstStr>) name ;
  - setValue: (id <PNumber>) value ;
@end

#endif /* !defined(PMATH_H_INCLUDED) */

