/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import com.google.common.collect.ImmutableSet;
import javax.annotation.Nullable;
import org.owasp.html.AttributePolicy;
import org.owasp.html.Strings;
import org.owasp.html.TCB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TCB
public class FilterUrlByProtocolAttributePolicy
implements AttributePolicy {
    private final ImmutableSet<String> protocols;

    public FilterUrlByProtocolAttributePolicy(Iterable<? extends String> protocols) {
        this.protocols = ImmutableSet.copyOf(protocols);
    }

    @Override
    @Nullable
    public String apply(String elementName, String attributeName, String s) {
        int n = s.length();
        block4: for (int i = 0; i < n; ++i) {
            switch (s.charAt(i)) {
                case '#': 
                case '/': 
                case '?': {
                    if (!s.startsWith("//") || this.allowProtocolRelativeUrls()) break block4;
                    return null;
                }
                case ':': {
                    String protocol = Strings.toLowerCase(s.substring(0, i));
                    if (this.protocols.contains((Object)protocol)) break block4;
                    return null;
                }
                default: {
                    continue block4;
                }
            }
        }
        return FilterUrlByProtocolAttributePolicy.normalizeUri(s);
    }

    protected boolean allowProtocolRelativeUrls() {
        return this.protocols.contains((Object)"http") && this.protocols.contains((Object)"https");
    }

    static String normalizeUri(String s) {
        int n = s.length();
        boolean colonsIrrelevant = false;
        block14: for (int i = 0; i < n; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '#': 
                case '/': 
                case ':': 
                case '?': {
                    colonsIrrelevant = true;
                    continue block14;
                }
                case '(': 
                case ')': 
                case '\uff1a': {
                    StringBuilder sb = new StringBuilder(n + 16);
                    int pos = 0;
                    while (i < n) {
                        ch = s.charAt(i);
                        block4 : switch (ch) {
                            case '(': {
                                sb.append(s, pos, i).append("%28");
                                pos = i + 1;
                                break;
                            }
                            case ')': {
                                sb.append(s, pos, i).append("%29");
                                pos = i + 1;
                                break;
                            }
                            default: {
                                if (ch <= '\u0100' || colonsIrrelevant) break;
                                switch (ch) {
                                    case '\u0589': {
                                        sb.append(s, pos, i).append("%d6%89");
                                        pos = i + 1;
                                        break block4;
                                    }
                                    case '\u05c3': {
                                        sb.append(s, pos, i).append("%d7%83");
                                        pos = i + 1;
                                        break block4;
                                    }
                                    case '\u2236': {
                                        sb.append(s, pos, i).append("%e2%88%b6");
                                        pos = i + 1;
                                        break block4;
                                    }
                                    case '\uff1a': {
                                        sb.append(s, pos, i).append("%ef%bc%9a");
                                        pos = i + 1;
                                    }
                                }
                            }
                        }
                        ++i;
                    }
                    return sb.append(s, pos, n).toString();
                }
            }
        }
        return s;
    }

    public boolean equals(Object o) {
        return o != null && this.getClass() == o.getClass() && this.protocols.equals(((FilterUrlByProtocolAttributePolicy)o).protocols);
    }

    public int hashCode() {
        return this.protocols.hashCode();
    }
}

