/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.collector.indices;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.action.admin.indices.stats.CommonStats;
import org.elasticsearch.action.admin.indices.stats.IndexStats;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.monitoring.MonitoredSystem;
import org.elasticsearch.xpack.core.monitoring.exporter.MonitoringDoc;
import org.elasticsearch.xpack.monitoring.exporter.FilteredMonitoringDoc;

public class IndicesStatsMonitoringDoc
extends FilteredMonitoringDoc {
    public static final String TYPE = "indices_stats";
    private final List<IndexStats> indicesStats;
    public static final Set<String> XCONTENT_FILTERS = Sets.newHashSet((Object[])new String[]{"indices_stats._all.primaries.docs.count", "indices_stats._all.primaries.indexing.index_time_in_millis", "indices_stats._all.primaries.indexing.index_total", "indices_stats._all.primaries.indexing.is_throttled", "indices_stats._all.primaries.indexing.throttle_time_in_millis", "indices_stats._all.primaries.search.query_time_in_millis", "indices_stats._all.primaries.search.query_total", "indices_stats._all.primaries.store.size_in_bytes", "indices_stats._all.total.docs.count", "indices_stats._all.total.indexing.index_time_in_millis", "indices_stats._all.total.indexing.index_total", "indices_stats._all.total.indexing.is_throttled", "indices_stats._all.total.indexing.throttle_time_in_millis", "indices_stats._all.total.search.query_time_in_millis", "indices_stats._all.total.search.query_total", "indices_stats._all.total.store.size_in_bytes"});

    IndicesStatsMonitoringDoc(String cluster, long timestamp, long intervalMillis, MonitoringDoc.Node node, List<IndexStats> indicesStats) {
        super(cluster, timestamp, intervalMillis, node, MonitoredSystem.ES, TYPE, null, XCONTENT_FILTERS);
        this.indicesStats = Objects.requireNonNull(indicesStats);
    }

    List<IndexStats> getIndicesStats() {
        return this.indicesStats;
    }

    protected void innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        CommonStats total = new CommonStats();
        CommonStats primaries = new CommonStats();
        for (IndexStats indexStats : this.getIndicesStats()) {
            ShardStats[] shardsStats = indexStats.getShards();
            if (shardsStats == null) continue;
            for (ShardStats shard : indexStats.getShards()) {
                total.add(shard.getStats());
                if (!shard.getShardRouting().primary()) continue;
                primaries.add(shard.getStats());
            }
        }
        builder.startObject(TYPE);
        builder.startObject("_all");
        builder.startObject("primaries");
        primaries.toXContent(builder, params);
        builder.endObject();
        builder.startObject("total");
        total.toXContent(builder, params);
        builder.endObject();
        builder.endObject();
        builder.startObject("indices");
        for (IndexStats indexStats : this.getIndicesStats()) {
            builder.startObject(indexStats.getIndex());
            builder.startObject("primaries");
            indexStats.getPrimaries().toXContent(builder, params);
            builder.endObject();
            builder.startObject("total");
            indexStats.getTotal().toXContent(builder, params);
            builder.endObject();
            builder.endObject();
        }
        builder.endObject();
        builder.endObject();
    }
}

