/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.permission;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.lucene.util.automaton.Automaton;
import org.elasticsearch.cluster.metadata.AliasOrIndex;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.core.security.authz.permission.ApplicationPermission;
import org.elasticsearch.xpack.core.security.authz.permission.ClusterPermission;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissionsCache;
import org.elasticsearch.xpack.core.security.authz.permission.IndicesPermission;
import org.elasticsearch.xpack.core.security.authz.permission.ResourcePrivilegesMap;
import org.elasticsearch.xpack.core.security.authz.permission.Role;
import org.elasticsearch.xpack.core.security.authz.permission.RunAsPermission;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilegeDescriptor;
import org.elasticsearch.xpack.core.security.authz.privilege.ClusterPrivilege;
import org.elasticsearch.xpack.core.security.support.Automatons;

public final class LimitedRole
extends Role {
    private final Role limitedBy;

    LimitedRole(String[] names, ClusterPermission cluster, IndicesPermission indices, ApplicationPermission application, RunAsPermission runAs, Role limitedBy) {
        super(names, cluster, indices, application, runAs);
        assert (limitedBy != null) : "limiting role is required";
        this.limitedBy = limitedBy;
    }

    public Role limitedBy() {
        return this.limitedBy;
    }

    @Override
    public ClusterPermission cluster() {
        throw new UnsupportedOperationException("cannot retrieve cluster permission on limited role");
    }

    @Override
    public IndicesPermission indices() {
        throw new UnsupportedOperationException("cannot retrieve indices permission on limited role");
    }

    @Override
    public ApplicationPermission application() {
        throw new UnsupportedOperationException("cannot retrieve application permission on limited role");
    }

    @Override
    public RunAsPermission runAs() {
        throw new UnsupportedOperationException("cannot retrieve cluster permission on limited role");
    }

    @Override
    public IndicesAccessControl authorize(String action, Set<String> requestedIndicesOrAliases, Map<String, AliasOrIndex> aliasAndIndexLookup, FieldPermissionsCache fieldPermissionsCache) {
        IndicesAccessControl indicesAccessControl = super.authorize(action, requestedIndicesOrAliases, aliasAndIndexLookup, fieldPermissionsCache);
        IndicesAccessControl limitedByIndicesAccessControl = this.limitedBy.authorize(action, requestedIndicesOrAliases, aliasAndIndexLookup, fieldPermissionsCache);
        return indicesAccessControl.limitIndicesAccessControl(limitedByIndicesAccessControl);
    }

    @Override
    public Predicate<String> allowedIndicesMatcher(String action) {
        Predicate<String> predicate = super.indices().allowedIndicesMatcher(action);
        predicate = predicate.and(this.limitedBy.indices().allowedIndicesMatcher(action));
        return predicate;
    }

    @Override
    public Automaton allowedActionsMatcher(String index) {
        Automaton allowedMatcher = super.allowedActionsMatcher(index);
        Automaton limitedByMatcher = super.allowedActionsMatcher(index);
        return Automatons.intersectAndMinimize(allowedMatcher, limitedByMatcher);
    }

    @Override
    public boolean checkIndicesAction(String action) {
        return super.checkIndicesAction(action) && this.limitedBy.checkIndicesAction(action);
    }

    @Override
    public ResourcePrivilegesMap checkIndicesPrivileges(Set<String> checkForIndexPatterns, boolean allowRestrictedIndices, Set<String> checkForPrivileges) {
        ResourcePrivilegesMap resourcePrivilegesMap = super.indices().checkResourcePrivileges(checkForIndexPatterns, allowRestrictedIndices, checkForPrivileges);
        ResourcePrivilegesMap resourcePrivilegesMapForLimitedRole = this.limitedBy.indices().checkResourcePrivileges(checkForIndexPatterns, allowRestrictedIndices, checkForPrivileges);
        return ResourcePrivilegesMap.intersection(resourcePrivilegesMap, resourcePrivilegesMapForLimitedRole);
    }

    @Override
    public boolean checkClusterAction(String action, TransportRequest request) {
        return super.checkClusterAction(action, request) && this.limitedBy.checkClusterAction(action, request);
    }

    @Override
    public boolean grants(ClusterPrivilege clusterPrivilege) {
        return super.grants(clusterPrivilege) && this.limitedBy.grants(clusterPrivilege);
    }

    @Override
    public ResourcePrivilegesMap checkApplicationResourcePrivileges(String applicationName, Set<String> checkForResources, Set<String> checkForPrivilegeNames, Collection<ApplicationPrivilegeDescriptor> storedPrivileges) {
        ResourcePrivilegesMap resourcePrivilegesMap = super.application().checkResourcePrivileges(applicationName, checkForResources, checkForPrivilegeNames, storedPrivileges);
        ResourcePrivilegesMap resourcePrivilegesMapForLimitedRole = this.limitedBy.application().checkResourcePrivileges(applicationName, checkForResources, checkForPrivilegeNames, storedPrivileges);
        return ResourcePrivilegesMap.intersection(resourcePrivilegesMap, resourcePrivilegesMapForLimitedRole);
    }

    @Override
    public boolean checkRunAs(String runAs) {
        return super.checkRunAs(runAs) && this.limitedBy.checkRunAs(runAs);
    }

    public static LimitedRole createLimitedRole(Role fromRole, Role limitedByRole) {
        Objects.requireNonNull(limitedByRole, "limited by role is required to create limited role");
        return new LimitedRole(fromRole.names(), fromRole.cluster(), fromRole.indices(), fromRole.application(), fromRole.runAs(), limitedByRole);
    }
}

