/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.replication.ReplicationRequest;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.AbstractBaseReindexRestHandler;
import org.elasticsearch.index.reindex.AbstractBulkByScrollRequest;
import org.elasticsearch.index.reindex.ReindexAction;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.index.reindex.RemoteInfo;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.script.Script;

public class RestReindexAction
extends AbstractBaseReindexRestHandler<ReindexRequest, ReindexAction> {
    static final ObjectParser<ReindexRequest, Void> PARSER = new ObjectParser("reindex");

    public RestReindexAction(Settings settings, RestController controller) {
        super(settings, ReindexAction.INSTANCE);
        controller.registerHandler(RestRequest.Method.POST, "/_reindex", (RestHandler)this);
    }

    public String getName() {
        return "reindex_action";
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        return this.doPrepareRequest(request, client, true, true);
    }

    @Override
    protected ReindexRequest buildRequest(RestRequest request) throws IOException {
        if (request.hasParam("pipeline")) {
            throw new IllegalArgumentException("_reindex doesn't support [pipeline] as a query parameter. Specify it in the [dest] object instead.");
        }
        ReindexRequest internal = new ReindexRequest();
        try (XContentParser parser = request.contentParser();){
            PARSER.parse(parser, (Object)internal, null);
        }
        if (request.hasParam("scroll")) {
            internal.setScroll(TimeValue.parseTimeValue((String)request.param("scroll"), (String)"scroll"));
        }
        return internal;
    }

    static RemoteInfo buildRemoteInfo(Map<String, Object> source) throws IOException {
        URI uri;
        Map remote = (Map)source.remove("remote");
        if (remote == null) {
            return null;
        }
        String username = RestReindexAction.extractString(remote, "username");
        String password = RestReindexAction.extractString(remote, "password");
        String hostInRequest = Objects.requireNonNull(RestReindexAction.extractString(remote, "host"), "[host] must be specified to reindex from a remote cluster");
        try {
            uri = new URI(hostInRequest);
            if (uri.getPort() == -1) {
                throw new URISyntaxException(hostInRequest, "The port was not defined in the [host]");
            }
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("[host] must be of the form [scheme]://[host]:[port](/[pathPrefix])? but was [" + hostInRequest + "]", ex);
        }
        String scheme = uri.getScheme();
        String host = uri.getHost();
        int port = uri.getPort();
        String pathPrefix = null;
        if (!uri.getPath().isEmpty()) {
            pathPrefix = uri.getPath();
        }
        Map<String, String> headers = RestReindexAction.extractStringStringMap(remote, "headers");
        TimeValue socketTimeout = RestReindexAction.extractTimeValue(remote, "socket_timeout", RemoteInfo.DEFAULT_SOCKET_TIMEOUT);
        TimeValue connectTimeout = RestReindexAction.extractTimeValue(remote, "connect_timeout", RemoteInfo.DEFAULT_CONNECT_TIMEOUT);
        if (!remote.isEmpty()) {
            throw new IllegalArgumentException("Unsupported fields in [remote]: [" + Strings.collectionToCommaDelimitedString(remote.keySet()) + "]");
        }
        return new RemoteInfo(scheme, host, port, pathPrefix, RestReindexAction.queryForRemote(source), username, password, headers, socketTimeout, connectTimeout);
    }

    private static String[] extractStringArray(Map<String, Object> source, String name) {
        Object value = source.remove(name);
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            List list = (List)value;
            return list.toArray(new String[list.size()]);
        }
        if (value instanceof String) {
            return new String[]{(String)value};
        }
        throw new IllegalArgumentException("Expected [" + name + "] to be a list of a string but was [" + value + ']');
    }

    private static String extractString(Map<String, Object> source, String name) {
        Object value = source.remove(name);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        throw new IllegalArgumentException("Expected [" + name + "] to be a string but was [" + value + "]");
    }

    private static Map<String, String> extractStringStringMap(Map<String, Object> source, String name) {
        Object value = source.remove(name);
        if (value == null) {
            return Collections.emptyMap();
        }
        if (!(value instanceof Map)) {
            throw new IllegalArgumentException("Expected [" + name + "] to be an object containing strings but was [" + value + "]");
        }
        Map map = (Map)value;
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getKey() instanceof String && entry.getValue() instanceof String) continue;
            throw new IllegalArgumentException("Expected [" + name + "] to be an object containing strings but has [" + entry + "]");
        }
        Map safe = map;
        return safe;
    }

    private static TimeValue extractTimeValue(Map<String, Object> source, String name, TimeValue defaultValue) {
        String string = RestReindexAction.extractString(source, name);
        return string == null ? defaultValue : TimeValue.parseTimeValue((String)string, (String)name);
    }

    private static BytesReference queryForRemote(Map<String, Object> source) throws IOException {
        XContentBuilder builder = JsonXContent.contentBuilder().prettyPrint();
        Object query = source.remove("query");
        if (query == null) {
            return BytesReference.bytes((XContentBuilder)QueryBuilders.matchAllQuery().toXContent(builder, ToXContent.EMPTY_PARAMS));
        }
        if (!(query instanceof Map)) {
            throw new IllegalArgumentException("Expected [query] to be an object but was [" + query + "]");
        }
        Map map = (Map)query;
        return BytesReference.bytes((XContentBuilder)builder.map(map));
    }

    static {
        ObjectParser.Parser sourceParser = (parser, request, context) -> {
            String[] types;
            Map source = parser.map();
            String[] indices = RestReindexAction.extractStringArray(source, "index");
            if (indices != null) {
                request.getSearchRequest().indices(indices);
            }
            if ((types = RestReindexAction.extractStringArray(source, "type")) != null) {
                request.getSearchRequest().types(types);
            }
            request.setRemoteInfo(RestReindexAction.buildRemoteInfo(source));
            XContentBuilder builder = XContentFactory.contentBuilder((XContentType)parser.contentType());
            builder.map(source);
            try (StreamInput stream = BytesReference.bytes((XContentBuilder)builder).streamInput();
                 XContentParser innerParser = parser.contentType().xContent().createParser(parser.getXContentRegistry(), parser.getDeprecationHandler(), (InputStream)stream);){
                request.getSearchRequest().source().parseXContent(innerParser, false);
            }
        };
        ObjectParser destParser = new ObjectParser("dest");
        destParser.declareString(ReplicationRequest::index, new ParseField("index", new String[0]));
        destParser.declareString(IndexRequest::type, new ParseField("type", new String[0]));
        destParser.declareString(IndexRequest::routing, new ParseField("routing", new String[0]));
        destParser.declareString(IndexRequest::opType, new ParseField("op_type", new String[0]));
        destParser.declareString(IndexRequest::setPipeline, new ParseField("pipeline", new String[0]));
        destParser.declareString((s, i) -> s.versionType(VersionType.fromString((String)i)), new ParseField("version_type", new String[0]));
        PARSER.declareField((arg_0, arg_1, arg_2) -> ((ObjectParser.Parser)sourceParser).parse(arg_0, arg_1, arg_2), new ParseField("source", new String[0]), ObjectParser.ValueType.OBJECT);
        PARSER.declareField((p, v, c) -> destParser.parse(p, (Object)v.getDestination(), c), new ParseField("dest", new String[0]), ObjectParser.ValueType.OBJECT);
        PARSER.declareInt(AbstractBulkByScrollRequest::setSize, new ParseField("size", new String[0]));
        PARSER.declareField((p, v, c) -> v.setScript(Script.parse((XContentParser)p)), new ParseField("script", new String[0]), ObjectParser.ValueType.OBJECT);
        PARSER.declareString(AbstractBulkByScrollRequest::setConflicts, new ParseField("conflicts", new String[0]));
    }
}

