/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.bulk.BulkAction;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.action.DeleteFilterAction;
import org.elasticsearch.xpack.core.ml.job.config.Detector;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.config.MlFilter;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.job.persistence.JobConfigProvider;

public class TransportDeleteFilterAction
extends HandledTransportAction<DeleteFilterAction.Request, AcknowledgedResponse> {
    private final Client client;
    private final ClusterService clusterService;
    private final JobConfigProvider jobConfigProvider;

    @Inject
    public TransportDeleteFilterAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client, ClusterService clusterService, JobConfigProvider jobConfigProvider) {
        super(settings, "cluster:admin/xpack/ml/filters/delete", threadPool, transportService, actionFilters, indexNameExpressionResolver, DeleteFilterAction.Request::new);
        this.client = client;
        this.clusterService = clusterService;
        this.jobConfigProvider = jobConfigProvider;
    }

    protected void doExecute(DeleteFilterAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        String filterId = request.getFilterId();
        List<String> clusterStateJobsUsingFilter = TransportDeleteFilterAction.clusterStateJobsUsingFilter(filterId, this.clusterService.state());
        if (!clusterStateJobsUsingFilter.isEmpty()) {
            listener.onFailure((Exception)((Object)ExceptionsHelper.conflictStatusException((String)Messages.getMessage((String)"Cannot delete filter [{0}] currently used by jobs {1}", (Object[])new Object[]{filterId, clusterStateJobsUsingFilter}), (Object[])new Object[0])));
            return;
        }
        this.jobConfigProvider.findJobsWithCustomRules((ActionListener<List<Job>>)ActionListener.wrap(jobs -> {
            List<String> currentlyUsedBy = TransportDeleteFilterAction.findJobsUsingFilter(jobs, filterId);
            if (!currentlyUsedBy.isEmpty()) {
                listener.onFailure((Exception)((Object)ExceptionsHelper.conflictStatusException((String)Messages.getMessage((String)"Cannot delete filter [{0}] currently used by jobs {1}", (Object[])new Object[]{filterId, currentlyUsedBy}), (Object[])new Object[0])));
            } else {
                this.deleteFilter(filterId, listener);
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private static List<String> findJobsUsingFilter(Collection<Job> jobs, String filterId) {
        ArrayList<String> currentlyUsedBy = new ArrayList<String>();
        block0: for (Job job : jobs) {
            List detectors = job.getAnalysisConfig().getDetectors();
            for (Detector detector : detectors) {
                if (!detector.extractReferencedFilters().contains(filterId)) continue;
                currentlyUsedBy.add(job.getId());
                continue block0;
            }
        }
        return currentlyUsedBy;
    }

    private static List<String> clusterStateJobsUsingFilter(String filterId, ClusterState state) {
        Map jobs = MlMetadata.getMlMetadata((ClusterState)state).getJobs();
        return TransportDeleteFilterAction.findJobsUsingFilter(jobs.values(), filterId);
    }

    private void deleteFilter(final String filterId, final ActionListener<AcknowledgedResponse> listener) {
        DeleteRequest deleteRequest = new DeleteRequest(".ml-meta", "doc", MlFilter.documentId((String)filterId));
        BulkRequestBuilder bulkRequestBuilder = this.client.prepareBulk();
        bulkRequestBuilder.add(deleteRequest);
        bulkRequestBuilder.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (Action)BulkAction.INSTANCE, (ActionRequest)((BulkRequest)bulkRequestBuilder.request()), (ActionListener)new ActionListener<BulkResponse>(){

            public void onResponse(BulkResponse bulkResponse) {
                if (bulkResponse.getItems()[0].status() == RestStatus.NOT_FOUND) {
                    listener.onFailure((Exception)new ResourceNotFoundException("Could not delete filter with ID [" + filterId + "] because it does not exist", new Object[0]));
                } else {
                    listener.onResponse((Object)new AcknowledgedResponse(true));
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure((Exception)ExceptionsHelper.serverError((String)("Could not delete filter with ID [" + filterId + "]"), (Throwable)e));
            }
        });
    }
}

