/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed.extractor.fields;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.fieldcaps.FieldCapabilities;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.elasticsearch.xpack.core.ml.utils.MlStrings;
import org.elasticsearch.xpack.ml.datafeed.extractor.fields.ExtractedField;

public class ExtractedFields {
    private static final String TEXT = "text";
    private final List<ExtractedField> allFields;
    private final List<ExtractedField> docValueFields;
    private final String[] sourceFields;

    public ExtractedFields(List<ExtractedField> allFields) {
        this.allFields = Collections.unmodifiableList(allFields);
        this.docValueFields = ExtractedFields.filterFields(ExtractedField.ExtractionMethod.DOC_VALUE, allFields);
        this.sourceFields = (String[])ExtractedFields.filterFields(ExtractedField.ExtractionMethod.SOURCE, allFields).stream().map(ExtractedField::getName).toArray(String[]::new);
    }

    public List<ExtractedField> getAllFields() {
        return this.allFields;
    }

    public String[] getSourceFields() {
        return this.sourceFields;
    }

    public List<ExtractedField> getDocValueFields() {
        return this.docValueFields;
    }

    private static List<ExtractedField> filterFields(ExtractedField.ExtractionMethod method, List<ExtractedField> fields) {
        return fields.stream().filter(field -> field.getExtractionMethod() == method).collect(Collectors.toList());
    }

    public static ExtractedFields build(Collection<String> allFields, Set<String> scriptFields, FieldCapabilitiesResponse fieldsCapabilities) {
        ExtractionMethodDetector extractionMethodDetector = new ExtractionMethodDetector(scriptFields, fieldsCapabilities);
        return new ExtractedFields(allFields.stream().map(field -> extractionMethodDetector.detect((String)field)).collect(Collectors.toList()));
    }

    protected static class ExtractionMethodDetector {
        private final Set<String> scriptFields;
        private final FieldCapabilitiesResponse fieldsCapabilities;

        protected ExtractionMethodDetector(Set<String> scriptFields, FieldCapabilitiesResponse fieldsCapabilities) {
            this.scriptFields = scriptFields;
            this.fieldsCapabilities = fieldsCapabilities;
        }

        protected ExtractedField detect(String field) {
            String parentField;
            String internalField = field;
            ExtractedField.ExtractionMethod method = ExtractedField.ExtractionMethod.SOURCE;
            if (this.scriptFields.contains(field)) {
                method = ExtractedField.ExtractionMethod.SCRIPT_FIELD;
            } else if (this.isAggregatable(field)) {
                method = ExtractedField.ExtractionMethod.DOC_VALUE;
                if (this.isFieldOfType(field, "date")) {
                    return ExtractedField.newTimeField(field, method);
                }
            } else if (this.isFieldOfType(field, ExtractedFields.TEXT) && !Objects.equals(parentField = MlStrings.getParentField((String)field), field) && this.fieldsCapabilities.getField(parentField) != null) {
                internalField = parentField;
                method = this.isAggregatable(parentField) ? ExtractedField.ExtractionMethod.DOC_VALUE : ExtractedField.ExtractionMethod.SOURCE;
            }
            return ExtractedField.newField(field, internalField, method);
        }

        protected boolean isAggregatable(String field) {
            Map fieldCaps = this.fieldsCapabilities.getField(field);
            if (fieldCaps == null || fieldCaps.isEmpty()) {
                throw new IllegalArgumentException("cannot retrieve field [" + field + "] because it has no mappings");
            }
            for (FieldCapabilities capsPerIndex : fieldCaps.values()) {
                if (capsPerIndex.isAggregatable()) continue;
                return false;
            }
            return true;
        }

        private boolean isFieldOfType(String field, String type) {
            Map fieldCaps = this.fieldsCapabilities.getField(field);
            if (fieldCaps != null && fieldCaps.size() == 1) {
                return fieldCaps.containsKey(type);
            }
            return false;
        }
    }
}

