/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.literal;

import java.io.IOException;
import java.time.temporal.TemporalAmount;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.sql.proto.StringUtils;
import org.elasticsearch.xpack.sql.type.DataType;

public abstract class Interval<I extends TemporalAmount>
implements NamedWriteable,
ToXContentObject {
    private final I interval;
    private final DataType intervalType;

    public Interval(I interval, DataType intervalType) {
        this.interval = interval;
        this.intervalType = intervalType;
    }

    public I interval() {
        return this.interval;
    }

    public DataType dataType() {
        return this.intervalType;
    }

    public abstract Interval<I> add(Interval<I> var1);

    public abstract Interval<I> sub(Interval<I> var1);

    public abstract Interval<I> mul(long var1);

    public int hashCode() {
        return Objects.hash(new Object[]{this.interval, this.intervalType});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Interval other = (Interval)obj;
        return Objects.equals(other.interval, this.interval) && Objects.equals((Object)other.intervalType, (Object)this.intervalType);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.value(this.interval);
    }

    public String toString() {
        return StringUtils.toString(this.interval);
    }
}

