/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class DN
implements Comparable<DN>,
Comparator<DN>,
Serializable {
    private static final RDN[] NO_RDNS = new RDN[0];
    public static final DN NULL_DN = new DN(new RDN[0]);
    private static final long serialVersionUID = -5272968942085729346L;
    private final RDN[] rdns;
    private final Schema schema;
    private final String dnString;
    private volatile String normalizedString;

    public DN(RDN ... rdns) {
        Validator.ensureNotNull(rdns);
        this.rdns = rdns;
        if (rdns.length == 0) {
            this.dnString = "";
            this.normalizedString = "";
            this.schema = null;
        } else {
            Schema s = null;
            StringBuilder buffer = new StringBuilder();
            for (RDN rdn : rdns) {
                if (buffer.length() > 0) {
                    buffer.append(',');
                }
                rdn.toString(buffer, false);
                if (s != null) continue;
                s = rdn.getSchema();
            }
            this.dnString = buffer.toString();
            this.schema = s;
        }
    }

    public DN(List<RDN> rdns) {
        Validator.ensureNotNull(rdns);
        if (rdns.isEmpty()) {
            this.rdns = NO_RDNS;
            this.dnString = "";
            this.normalizedString = "";
            this.schema = null;
        } else {
            this.rdns = rdns.toArray(new RDN[rdns.size()]);
            Schema s = null;
            StringBuilder buffer = new StringBuilder();
            for (RDN rdn : this.rdns) {
                if (buffer.length() > 0) {
                    buffer.append(',');
                }
                rdn.toString(buffer, false);
                if (s != null) continue;
                s = rdn.getSchema();
            }
            this.dnString = buffer.toString();
            this.schema = s;
        }
    }

    public DN(RDN rdn, DN parentDN) {
        Validator.ensureNotNull(rdn, parentDN);
        this.rdns = new RDN[parentDN.rdns.length + 1];
        this.rdns[0] = rdn;
        System.arraycopy(parentDN.rdns, 0, this.rdns, 1, parentDN.rdns.length);
        Schema s = null;
        StringBuilder buffer = new StringBuilder();
        for (RDN r : this.rdns) {
            if (buffer.length() > 0) {
                buffer.append(',');
            }
            r.toString(buffer, false);
            if (s != null) continue;
            s = r.getSchema();
        }
        this.dnString = buffer.toString();
        this.schema = s;
    }

    public DN(String dnString) throws LDAPException {
        this(dnString, null);
    }

    public DN(String dnString, Schema schema) throws LDAPException {
        Validator.ensureNotNull(dnString);
        this.dnString = dnString;
        this.schema = schema;
        ArrayList<RDN> rdnList = new ArrayList<RDN>(5);
        int length = dnString.length();
        if (length == 0) {
            this.rdns = NO_RDNS;
            this.normalizedString = "";
            return;
        }
        int pos = 0;
        boolean expectMore = false;
        block12: while (pos < length) {
            int rdnEndPos;
            ASN1OctetString value;
            char c;
            while (pos < length && dnString.charAt(pos) == ' ') {
                ++pos;
            }
            if (pos >= length) {
                if (rdnList.isEmpty()) break;
                throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_DN_ENDS_WITH_COMMA.get(dnString));
            }
            int attrStartPos = pos;
            int rdnStartPos = pos;
            while (pos < length && (c = dnString.charAt(pos)) != ' ' && c != '=') {
                if (c == ',' || c == ';') {
                    throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_DN_UNEXPECTED_COMMA.get(dnString, pos));
                }
                ++pos;
            }
            String attrName = dnString.substring(attrStartPos, pos);
            if (attrName.isEmpty()) {
                throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_DN_NO_ATTR_IN_RDN.get(dnString));
            }
            while (pos < length && dnString.charAt(pos) == ' ') {
                ++pos;
            }
            if (pos >= length || dnString.charAt(pos) != '=') {
                throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_DN_NO_EQUAL_SIGN.get(dnString, attrName));
            }
            ++pos;
            while (pos < length && dnString.charAt(pos) == ' ') {
                ++pos;
            }
            if (pos >= length) {
                value = new ASN1OctetString();
                rdnEndPos = pos;
            } else if (dnString.charAt(pos) == '#') {
                byte[] valueArray = RDN.readHexString(dnString, ++pos);
                try {
                    value = ASN1OctetString.decodeAsOctetString(valueArray);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_HEX_STRING_NOT_BER_ENCODED.get(dnString, attrName), e);
                }
                rdnEndPos = pos += valueArray.length * 2;
            } else {
                StringBuilder buffer = new StringBuilder();
                pos = RDN.readValueString(dnString, pos, buffer);
                value = new ASN1OctetString(buffer.toString());
                rdnEndPos = pos;
            }
            while (pos < length && dnString.charAt(pos) == ' ') {
                ++pos;
            }
            if (pos >= length) {
                rdnList.add(new RDN(attrName, value, schema, DN.getTrimmedRDN(dnString, rdnStartPos, rdnEndPos)));
                expectMore = false;
                break;
            }
            switch (dnString.charAt(pos)) {
                case '+': {
                    break;
                }
                case ',': 
                case ';': {
                    rdnList.add(new RDN(attrName, value, schema, DN.getTrimmedRDN(dnString, rdnStartPos, rdnEndPos)));
                    ++pos;
                    expectMore = true;
                    continue block12;
                }
                default: {
                    throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_DN_UNEXPECTED_CHAR.get(dnString, Character.valueOf(dnString.charAt(pos)), pos));
                }
            }
            if (++pos >= length) {
                throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_DN_ENDS_WITH_PLUS.get(dnString));
            }
            ArrayList<String> nameList = new ArrayList<String>(5);
            ArrayList<ASN1OctetString> valueList = new ArrayList<ASN1OctetString>(5);
            nameList.add(attrName);
            valueList.add(value);
            block18: while (pos < length) {
                ASN1OctetString[] values;
                char c2;
                while (pos < length && dnString.charAt(pos) == ' ') {
                    ++pos;
                }
                if (pos >= length) {
                    throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_DN_ENDS_WITH_PLUS.get(dnString));
                }
                attrStartPos = pos;
                while (pos < length && (c2 = dnString.charAt(pos)) != ' ' && c2 != '=') {
                    if (c2 == ',' || c2 == ';') {
                        throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_DN_UNEXPECTED_COMMA.get(dnString, pos));
                    }
                    ++pos;
                }
                attrName = dnString.substring(attrStartPos, pos);
                if (attrName.isEmpty()) {
                    throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_DN_NO_ATTR_IN_RDN.get(dnString));
                }
                while (pos < length && dnString.charAt(pos) == ' ') {
                    ++pos;
                }
                if (pos >= length || dnString.charAt(pos) != '=') {
                    throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_DN_NO_EQUAL_SIGN.get(dnString, attrName));
                }
                ++pos;
                while (pos < length && dnString.charAt(pos) == ' ') {
                    ++pos;
                }
                if (pos >= length) {
                    value = new ASN1OctetString();
                    rdnEndPos = pos;
                } else if (dnString.charAt(pos) == '#') {
                    byte[] valueArray = RDN.readHexString(dnString, ++pos);
                    try {
                        value = ASN1OctetString.decodeAsOctetString(valueArray);
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_HEX_STRING_NOT_BER_ENCODED.get(dnString, attrName), e);
                    }
                    rdnEndPos = pos += valueArray.length * 2;
                } else {
                    StringBuilder buffer = new StringBuilder();
                    pos = RDN.readValueString(dnString, pos, buffer);
                    value = new ASN1OctetString(buffer.toString());
                    rdnEndPos = pos;
                }
                while (pos < length && dnString.charAt(pos) == ' ') {
                    ++pos;
                }
                nameList.add(attrName);
                valueList.add(value);
                if (pos >= length) {
                    String[] names = nameList.toArray(new String[nameList.size()]);
                    values = valueList.toArray(new ASN1OctetString[valueList.size()]);
                    rdnList.add(new RDN(names, values, schema, DN.getTrimmedRDN(dnString, rdnStartPos, rdnEndPos)));
                    expectMore = false;
                    break block12;
                }
                switch (dnString.charAt(pos)) {
                    case '+': {
                        if (++pos < length) continue block18;
                        throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_DN_ENDS_WITH_PLUS.get(dnString));
                    }
                    case ',': 
                    case ';': {
                        String[] names = nameList.toArray(new String[nameList.size()]);
                        values = valueList.toArray(new ASN1OctetString[valueList.size()]);
                        rdnList.add(new RDN(names, values, schema, DN.getTrimmedRDN(dnString, rdnStartPos, rdnEndPos)));
                        ++pos;
                        expectMore = true;
                        continue block12;
                    }
                }
                throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_DN_UNEXPECTED_CHAR.get(dnString, Character.valueOf(dnString.charAt(pos)), pos));
            }
        }
        if (expectMore) {
            throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_DN_ENDS_WITH_COMMA.get(dnString));
        }
        this.rdns = new RDN[rdnList.size()];
        rdnList.toArray(this.rdns);
    }

    private static String getTrimmedRDN(String dnString, int start, int end) {
        String rdnString = dnString.substring(start, end);
        if (!rdnString.endsWith(" ")) {
            return rdnString;
        }
        StringBuilder buffer = new StringBuilder(rdnString);
        while (buffer.charAt(buffer.length() - 1) == ' ' && buffer.charAt(buffer.length() - 2) != '\\') {
            buffer.setLength(buffer.length() - 1);
        }
        return buffer.toString();
    }

    public static boolean isValidDN(String s) {
        try {
            new DN(s);
            return true;
        }
        catch (LDAPException le) {
            return false;
        }
    }

    public RDN getRDN() {
        if (this.rdns.length == 0) {
            return null;
        }
        return this.rdns[0];
    }

    public String getRDNString() {
        if (this.rdns.length == 0) {
            return null;
        }
        return this.rdns[0].toString();
    }

    public static String getRDNString(String s) throws LDAPException {
        return new DN(s).getRDNString();
    }

    public RDN[] getRDNs() {
        return this.rdns;
    }

    public static RDN[] getRDNs(String s) throws LDAPException {
        return new DN(s).getRDNs();
    }

    public String[] getRDNStrings() {
        String[] rdnStrings = new String[this.rdns.length];
        for (int i = 0; i < this.rdns.length; ++i) {
            rdnStrings[i] = this.rdns[i].toString();
        }
        return rdnStrings;
    }

    public static String[] getRDNStrings(String s) throws LDAPException {
        return new DN(s).getRDNStrings();
    }

    public boolean isNullDN() {
        return this.rdns.length == 0;
    }

    public DN getParent() {
        switch (this.rdns.length) {
            case 0: 
            case 1: {
                return null;
            }
            case 2: {
                return new DN(this.rdns[1]);
            }
            case 3: {
                return new DN(this.rdns[1], this.rdns[2]);
            }
            case 4: {
                return new DN(this.rdns[1], this.rdns[2], this.rdns[3]);
            }
            case 5: {
                return new DN(this.rdns[1], this.rdns[2], this.rdns[3], this.rdns[4]);
            }
        }
        RDN[] parentRDNs = new RDN[this.rdns.length - 1];
        System.arraycopy(this.rdns, 1, parentRDNs, 0, parentRDNs.length);
        return new DN(parentRDNs);
    }

    public static DN getParent(String s) throws LDAPException {
        return new DN(s).getParent();
    }

    public String getParentString() {
        DN parentDN = this.getParent();
        if (parentDN == null) {
            return null;
        }
        return parentDN.toString();
    }

    public static String getParentString(String s) throws LDAPException {
        return new DN(s).getParentString();
    }

    public boolean isAncestorOf(DN dn, boolean allowEquals) {
        int thisPos = this.rdns.length - 1;
        int thatPos = dn.rdns.length - 1;
        if (thisPos < 0) {
            return allowEquals || thatPos >= 0;
        }
        if (thisPos > thatPos || thisPos == thatPos && !allowEquals) {
            return false;
        }
        while (thisPos >= 0) {
            if (this.rdns[thisPos--].equals(dn.rdns[thatPos--])) continue;
            return false;
        }
        return true;
    }

    public boolean isAncestorOf(String s, boolean allowEquals) throws LDAPException {
        return this.isAncestorOf(new DN(s), allowEquals);
    }

    public static boolean isAncestorOf(String s1, String s2, boolean allowEquals) throws LDAPException {
        return new DN(s1).isAncestorOf(new DN(s2), allowEquals);
    }

    public boolean isDescendantOf(DN dn, boolean allowEquals) {
        int thisPos = this.rdns.length - 1;
        int thatPos = dn.rdns.length - 1;
        if (thatPos < 0) {
            return allowEquals || thisPos >= 0;
        }
        if (thisPos < thatPos || thisPos == thatPos && !allowEquals) {
            return false;
        }
        while (thatPos >= 0) {
            if (this.rdns[thisPos--].equals(dn.rdns[thatPos--])) continue;
            return false;
        }
        return true;
    }

    public boolean isDescendantOf(String s, boolean allowEquals) throws LDAPException {
        return this.isDescendantOf(new DN(s), allowEquals);
    }

    public static boolean isDescendantOf(String s1, String s2, boolean allowEquals) throws LDAPException {
        return new DN(s1).isDescendantOf(new DN(s2), allowEquals);
    }

    public boolean matchesBaseAndScope(String baseDN, SearchScope scope) throws LDAPException {
        return this.matchesBaseAndScope(new DN(baseDN), scope);
    }

    public boolean matchesBaseAndScope(DN baseDN, SearchScope scope) throws LDAPException {
        Validator.ensureNotNull(baseDN, scope);
        switch (scope.intValue()) {
            case 0: {
                return this.equals(baseDN);
            }
            case 1: {
                return baseDN.equals(this.getParent());
            }
            case 2: {
                return this.isDescendantOf(baseDN, true);
            }
            case 3: {
                return this.isDescendantOf(baseDN, false);
            }
        }
        throw new LDAPException(ResultCode.PARAM_ERROR, LDAPMessages.ERR_DN_MATCHES_UNSUPPORTED_SCOPE.get(this.dnString, String.valueOf(scope)));
    }

    public int hashCode() {
        return this.toNormalizedString().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof DN)) {
            return false;
        }
        DN dn = (DN)o;
        return this.toNormalizedString().equals(dn.toNormalizedString());
    }

    public boolean equals(String s) throws LDAPException {
        if (s == null) {
            return false;
        }
        return this.equals(new DN(s));
    }

    public static boolean equals(String s1, String s2) throws LDAPException {
        return new DN(s1).equals(new DN(s2));
    }

    public static boolean equals(String s1, String s2, Schema schema) throws LDAPException {
        return new DN(s1, schema).equals(new DN(s2, schema));
    }

    public String toString() {
        return this.dnString;
    }

    public String toMinimallyEncodedString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer, true);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        this.toString(buffer, false);
    }

    public void toString(StringBuilder buffer, boolean minimizeEncoding) {
        for (int i = 0; i < this.rdns.length; ++i) {
            if (i > 0) {
                buffer.append(',');
            }
            this.rdns[i].toString(buffer, minimizeEncoding);
        }
    }

    public String toNormalizedString() {
        if (this.normalizedString == null) {
            StringBuilder buffer = new StringBuilder();
            this.toNormalizedString(buffer);
            this.normalizedString = buffer.toString();
        }
        return this.normalizedString;
    }

    public void toNormalizedString(StringBuilder buffer) {
        for (int i = 0; i < this.rdns.length; ++i) {
            if (i > 0) {
                buffer.append(',');
            }
            buffer.append(this.rdns[i].toNormalizedString());
        }
    }

    public static String normalize(String s) throws LDAPException {
        return DN.normalize(s, null);
    }

    public static String normalize(String s, Schema schema) throws LDAPException {
        return new DN(s, schema).toNormalizedString();
    }

    @Override
    public int compareTo(DN dn) {
        return this.compare(this, dn);
    }

    @Override
    public int compare(DN dn1, DN dn2) {
        int pos2;
        Validator.ensureNotNull(dn1, dn2);
        int pos1 = dn1.rdns.length - 1;
        if (pos1 < 0) {
            if (pos2 < 0) {
                return 0;
            }
            return -1;
        }
        if (pos2 < 0) {
            return 1;
        }
        for (pos2 = dn2.rdns.length - 1; pos1 >= 0 && pos2 >= 0; --pos1, --pos2) {
            int compValue = dn1.rdns[pos1].compareTo(dn2.rdns[pos2]);
            if (compValue == 0) continue;
            return compValue;
        }
        if (pos1 < 0) {
            if (pos2 < 0) {
                return 0;
            }
            return -1;
        }
        return 1;
    }

    public static int compare(String s1, String s2) throws LDAPException {
        return DN.compare(s1, s2, null);
    }

    public static int compare(String s1, String s2, Schema schema) throws LDAPException {
        return new DN(s1, schema).compareTo(new DN(s2, schema));
    }
}

