/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Date;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.GUIMessage;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.common.resources.ResourceManager;

public class ChatDisplay {
    private static final int MESSAGE_COUNT = 3;
    private static final int MESSAGE_AGE = 30000;
    private final ArrayList<GUIMessage> messages = new ArrayList(3);

    ChatDisplay() {
    }

    public synchronized void addMessage(GUIMessage message) {
        if (this.getMessageCount() == 3) {
            this.messages.remove(0);
        }
        this.messages.add(message);
    }

    private GUIMessage getMessage(int index) {
        return this.messages.get(index);
    }

    private int getMessageCount() {
        return this.messages.size();
    }

    public synchronized void display(Graphics2D g, ImageLibrary lib, Dimension size) {
        if (this.getMessageCount() > 0) {
            Font font = FontLibrary.createFont(FontLibrary.FontType.NORMAL, FontLibrary.FontSize.TINY, lib.getScaleFactor());
            GUIMessage message = this.getMessage(0);
            BufferedImage si = lib.getStringImage(g, message.getMessage(), message.getColor(), font);
            int yy = size.height - 300 - this.getMessageCount() * ((Image)si).getHeight(null);
            int xx = 40;
            for (int i = 0; i < this.getMessageCount(); ++i) {
                message = this.getMessage(i);
                g.drawImage((Image)lib.getStringImage(g, message.getMessage(), message.getColor(), font), xx, yy, null);
                yy += ((Image)si).getHeight(null);
            }
            BufferedImage decoration = ResourceManager.getImage("image.menuborder.shadow.s");
            int width = ((Image)decoration).getWidth(null);
            for (int index = 0; index < size.width; index += width) {
                g.drawImage((Image)decoration, index, 0, null);
            }
            decoration = ResourceManager.getImage("image.menuborder.shadow.sw");
            g.drawImage((Image)decoration, 0, 0, null);
            decoration = ResourceManager.getImage("image.menuborder.shadow.se");
            g.drawImage((Image)decoration, size.width - ((Image)decoration).getWidth(null), 0, null);
        }
    }

    public synchronized boolean removeOldMessages() {
        long currentTime = new Date().getTime();
        boolean result = false;
        int i = 0;
        while (i < this.getMessageCount()) {
            long creationTime = this.getMessage(i).getCreationTime();
            if (currentTime - creationTime >= 30000L) {
                result = true;
                this.messages.remove(i);
                continue;
            }
            ++i;
        }
        return result;
    }
}

