/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;
import org.broad.igv.feature.genome.GenomeException;
import org.broad.igv.feature.genome.fasta.FastaUtils;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.HttpUtils;

public class GenomeImporter {
    public static final int MAX_CONTIGS = 1500000;
    static Logger log = Logger.getLogger(GenomeImporter.class);
    public static final Pattern SEQUENCE_NAME_SPLITTER = Pattern.compile("\\s+");
    static final int ZIP_ENTRY_CHUNK_SIZE = 64000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File createGenomeArchive(File genomeFile, String genomeId, String genomeDisplayName, String fastaFile, File geneAnnotFile, File cytobandFile, File chrAliasFile) throws IOException {
        if (genomeFile == null || genomeId == null || genomeDisplayName == null) {
            log.error((Object)"Invalid input for genome creation: ");
            log.error((Object)("\tGenome file=" + genomeFile.getAbsolutePath()));
            log.error((Object)("\tGenome Id=" + genomeId));
            log.error((Object)("\tGenome Name" + genomeDisplayName));
            return null;
        }
        File propertyFile = null;
        OutputStreamWriter propertyFileWriter = null;
        try {
            boolean fastaDirectory = false;
            ArrayList<String> fastaFileNames = new ArrayList<String>();
            if (!FileUtils.resourceExists(fastaFile)) {
                String msg = "File not found: " + fastaFile;
                throw new GenomeException(msg);
            }
            if (fastaFile.toLowerCase().endsWith(".zip")) {
                String msg = "Error.  Zip archives are not supported.  Please select a fasta file.";
                throw new GenomeException(msg);
            }
            if (fastaFile.toLowerCase().endsWith(".gz")) {
                String msg = "Error.  GZipped files are not supported.  Please select a non-gzipped fasta file.";
                throw new GenomeException(msg);
            }
            ArrayList<CallSite> fastaIndexPathList = new ArrayList<CallSite>();
            String fastaIndexPath = fastaFile + ".fai";
            File sequenceInputFile = new File(fastaFile);
            if (sequenceInputFile.exists()) {
                if (sequenceInputFile.isDirectory()) {
                    fastaDirectory = true;
                    List<File> files = this.getSequenceFiles(sequenceInputFile);
                    for (File file : files) {
                        if (file.getName().toLowerCase().endsWith(".gz")) {
                            String msg = "<html>Error.  One or more fasta files are gzipped: " + file.getName() + "<br>All fasta files must be gunzipped prior to importing.";
                            throw new GenomeException(msg);
                        }
                        File indexFile = new File(sequenceInputFile, file.getName() + ".fai");
                        if (!indexFile.exists()) {
                            FastaUtils.createIndexFile(file.getAbsolutePath(), indexFile.getAbsolutePath());
                        }
                        fastaIndexPathList.add((CallSite)((Object)fastaIndexPath));
                        fastaFileNames.add(file.getName());
                    }
                } else {
                    File indexFile = new File(fastaIndexPath);
                    if (!indexFile.exists()) {
                        FastaUtils.createIndexFile(fastaFile, fastaIndexPath);
                    }
                    fastaIndexPathList.add((CallSite)((Object)fastaIndexPath));
                }
            } else if (!FileUtils.resourceExists(fastaIndexPath)) {
                String msg = "<html>Index file " + fastaIndexPath + " Not found. <br>Remote fasta files must be indexed prior to importing.";
                throw new GenomeException(msg);
            }
            fastaFile = FileUtils.getRelativePath(genomeFile.getParent(), fastaFile);
            byte[] propertyBytes = this.createGenomePropertyFile(genomeId, genomeDisplayName, fastaFile, geneAnnotFile, cytobandFile, chrAliasFile, fastaDirectory, fastaFileNames);
            File[] inputFiles = new File[]{geneAnnotFile, cytobandFile, chrAliasFile};
            GenomeImporter.createGenomeArchive(genomeFile, inputFiles, propertyBytes);
        }
        finally {
            if (propertyFileWriter != null) {
                try {
                    propertyFileWriter.close();
                }
                catch (IOException ex) {
                    log.error((Object)("Failed to close genome archive: +" + genomeFile.getAbsolutePath()), (Throwable)ex);
                }
            }
            if (propertyFile != null) {
                propertyFile.delete();
            }
        }
        return genomeFile;
    }

    private List<File> getSequenceFiles(File sequenceDir) {
        ArrayList<File> files = new ArrayList<File>();
        for (File f : sequenceDir.listFiles()) {
            if (f.getName().startsWith(".") || f.isDirectory() || f.getName().endsWith(".fai")) continue;
            files.add(f);
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] createGenomePropertyFile(String genomeId, String genomeDisplayName, String sequenceLocation, File geneAnnotFile, File cytobandFile, File chrAliasFile, boolean fastaDirectory, List<String> fastaFileNames) throws IOException {
        try (PrintWriter propertyFileWriter = null;){
            ByteArrayOutputStream propertyBytes = new ByteArrayOutputStream();
            propertyFileWriter = new PrintWriter(new OutputStreamWriter(propertyBytes));
            propertyFileWriter.println("fasta=true");
            propertyFileWriter.println("fastaDirectory=" + fastaDirectory);
            if (fastaDirectory) {
                propertyFileWriter.print("fastaFiles=");
                for (String fif : fastaFileNames) {
                    propertyFileWriter.print(fif + ",");
                }
                propertyFileWriter.println();
            }
            propertyFileWriter.println("ordered=" + !fastaDirectory);
            if (genomeId != null) {
                propertyFileWriter.println("id=" + genomeId);
            }
            if (genomeDisplayName != null) {
                propertyFileWriter.println("name=" + genomeDisplayName);
            }
            if (cytobandFile != null) {
                propertyFileWriter.println("cytobandFile=" + cytobandFile.getName());
            }
            if (geneAnnotFile != null) {
                propertyFileWriter.println("geneFile=" + geneAnnotFile.getName());
            }
            if (chrAliasFile != null) {
                propertyFileWriter.println("chrAliasFile=" + chrAliasFile.getName());
            }
            if (sequenceLocation != null) {
                if (!HttpUtils.isRemoteURL(sequenceLocation)) {
                    sequenceLocation = sequenceLocation.replace('\\', '/');
                }
                propertyFileWriter.println("sequenceLocation=" + sequenceLocation);
            }
            propertyFileWriter.flush();
            Object object = propertyBytes.toByteArray();
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createGenomeArchive(File zipOutputFile, File[] inputFiles, byte[] propertyBytes) throws FileNotFoundException, IOException {
        if (zipOutputFile == null) {
            return;
        }
        if (inputFiles == null || inputFiles.length == 0) {
            return;
        }
        DeflaterOutputStream zipOutputStream = null;
        try {
            zipOutputStream = new ZipOutputStream(new FileOutputStream(zipOutputFile));
            ZipEntry propertiesEntry = new ZipEntry("property.txt");
            propertiesEntry.setSize(propertyBytes.length);
            ((ZipOutputStream)zipOutputStream).putNextEntry(propertiesEntry);
            zipOutputStream.write(propertyBytes);
            for (File file : inputFiles) {
                if (file == null) continue;
                long fileLength = file.length();
                ZipEntry zipEntry = new ZipEntry(file.getName());
                zipEntry.setSize(fileLength);
                ((ZipOutputStream)zipOutputStream).putNextEntry(zipEntry);
                try (BufferedInputStream bufferedInputstream = null;){
                    FileInputStream inputStream = new FileInputStream(file);
                    bufferedInputstream = new BufferedInputStream(inputStream);
                    int bytesRead = 0;
                    byte[] data = new byte[64000];
                    while ((bytesRead = bufferedInputstream.read(data)) != -1) {
                        ((ZipOutputStream)zipOutputStream).write(data, 0, bytesRead);
                    }
                }
            }
        }
        finally {
            if (zipOutputStream != null) {
                zipOutputStream.flush();
                ((ZipOutputStream)zipOutputStream).close();
            }
        }
    }
}

