/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.stat;

import edu.cornell.med.icb.stat.PredictionStatisticCalculator;

public class MatthewsCorrelationCalculator
extends PredictionStatisticCalculator {
    private double mcc;

    @Override
    public String getMeasureName() {
        return "MCC";
    }

    public MatthewsCorrelationCalculator() {
        this.highestStatisticIsBest = true;
        this.zero = 0.0;
    }

    public double evaluateMCC(double threshold, double[] decisionValues, double[] labels) {
        this.evaluateContingencyTable(threshold, decisionValues, labels);
        double value = (this.TP * this.TN - this.FP * this.FN) / Math.sqrt((this.TP + this.FP) * (this.TP + this.FN) * (this.TN + this.FP) * (this.TN + this.FN));
        return value;
    }

    @Override
    public double evaluateStatisticAtThreshold(double threshold, double[] decisionValues, double[] labels) {
        return this.evaluateMCC(threshold, decisionValues, labels);
    }
}

