/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.alignments;

import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.io.IOException;
import org.campagnelab.goby.alignments.AlignmentReader;
import org.campagnelab.goby.alignments.AlignmentReaderFactory;
import org.campagnelab.goby.alignments.AlignmentReaderFactoryBase;
import org.campagnelab.goby.alignments.AlignmentReaderImpl;
import org.campagnelab.goby.alignments.GenomicRange;
import org.campagnelab.goby.alignments.GobyAlignmentReaderFactory;
import org.campagnelab.goby.alignments.HTSJdkReaderFactory;
import org.campagnelab.goby.alignments.htsjdk.HTSJDKReaderImpl;

public class DefaultAlignmentReaderFactory
extends AlignmentReaderFactoryBase
implements AlignmentReaderFactory {
    GobyAlignmentReaderFactory gobyFactory = new GobyAlignmentReaderFactory();
    HTSJdkReaderFactory samBamCramFactory = new HTSJdkReaderFactory();

    @Override
    public AlignmentReader createReader(String basename) throws IOException {
        switch (this.determineFormat(basename)) {
            case GOBY: {
                return this.gobyFactory.createReader(basename);
            }
            case SAM_BAM_CRAM: {
                return this.samBamCramFactory.createReader(basename);
            }
        }
        throw new UnsupportedOperationException("None of the factories could read the input file: " + basename);
    }

    @Override
    public AlignmentReader createReader(String basename, boolean upgrade) throws IOException {
        switch (this.determineFormat(basename)) {
            case GOBY: {
                return this.gobyFactory.createReader(basename, upgrade);
            }
            case SAM_BAM_CRAM: {
                return this.samBamCramFactory.createReader(basename, upgrade);
            }
        }
        throw new UnsupportedOperationException("None of the factories could read the input file: " + basename);
    }

    @Override
    public AlignmentReader[] createReaderArray(int numElements) throws IOException {
        return new AlignmentReader[numElements];
    }

    @Override
    public AlignmentReader createReader(String basename, int startReferenceIndex, int startPosition, int endReferenceIndex, int endPosition) throws IOException {
        switch (this.determineFormat(basename)) {
            case GOBY: {
                return this.gobyFactory.createReader(basename, startReferenceIndex, startPosition, endReferenceIndex, endPosition);
            }
            case SAM_BAM_CRAM: {
                return this.samBamCramFactory.createReader(basename, startReferenceIndex, startPosition, endReferenceIndex, endPosition);
            }
        }
        throw new UnsupportedOperationException("None of the factories could read the input file: " + basename);
    }

    @Override
    public AlignmentReader createReader(String basename, GenomicRange range) throws IOException {
        switch (this.determineFormat(basename)) {
            case GOBY: {
                return this.gobyFactory.createReader(basename, range);
            }
            case SAM_BAM_CRAM: {
                return this.samBamCramFactory.createReader(basename, range);
            }
        }
        throw new UnsupportedOperationException("None of the factories could read the input file: " + basename);
    }

    @Override
    public String[] getBasenames(String[] inputFilenames) {
        ObjectArraySet basenames = new ObjectArraySet();
        block4: for (String inputFilename : inputFilenames) {
            String[] names = new String[]{inputFilename};
            switch (this.determineFormat(inputFilename)) {
                case GOBY: {
                    basenames.add(this.gobyFactory.getBasenames(names)[0]);
                    continue block4;
                }
                case SAM_BAM_CRAM: {
                    basenames.add(this.samBamCramFactory.getBasenames(names)[0]);
                    continue block4;
                }
            }
        }
        return basenames.toArray(new String[basenames.size()]);
    }

    @Override
    public AlignmentReader createReader(String basename, long startOffset, long endOffset) throws IOException {
        switch (this.determineFormat(basename)) {
            case GOBY: {
                return this.gobyFactory.createReader(basename, startOffset, endOffset);
            }
            case SAM_BAM_CRAM: {
                return this.samBamCramFactory.createReader(basename, startOffset, endOffset);
            }
        }
        throw new UnsupportedOperationException("None of the factories could read the input file: " + basename);
    }

    public AlignmentFormat determineFormat(String basename) {
        if (AlignmentReaderImpl.canRead(basename)) {
            return AlignmentFormat.GOBY;
        }
        if (HTSJDKReaderImpl.canRead(basename)) {
            return AlignmentFormat.SAM_BAM_CRAM;
        }
        return AlignmentFormat.OTHER;
    }

    private static enum AlignmentFormat {
        GOBY,
        SAM_BAM_CRAM,
        OTHER;

    }
}

