/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.AbstractBAMFileIndex;
import htsjdk.samtools.BAMFileSpan;
import htsjdk.samtools.BAMIndexContent;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class DiskBasedBAMFileIndex
extends AbstractBAMFileIndex {
    public DiskBasedBAMFileIndex(File file, SAMSequenceDictionary dictionary) {
        super(file, dictionary);
    }

    public DiskBasedBAMFileIndex(SeekableStream stream, SAMSequenceDictionary dictionary) {
        super(stream, dictionary);
    }

    public DiskBasedBAMFileIndex(File file, SAMSequenceDictionary dictionary, boolean useMemoryMapping) {
        super(file, dictionary, useMemoryMapping);
    }

    @Override
    public BAMFileSpan getSpanOverlapping(int referenceIndex, int startPos, int endPos) {
        BAMIndexContent queryResults = this.query(referenceIndex, startPos, endPos);
        if (queryResults == null) {
            return null;
        }
        List<Chunk> chunkList = new ArrayList<Chunk>();
        for (Chunk chunk : queryResults.getAllChunks()) {
            chunkList.add(chunk.clone());
        }
        chunkList = Chunk.optimizeChunkList(chunkList, queryResults.getLinearIndex().getMinimumOffset(startPos));
        return new BAMFileSpan(chunkList);
    }

    @Override
    protected BAMIndexContent getQueryResults(int reference) {
        throw new UnsupportedOperationException();
    }
}

