/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import kafka.log.CompletedTxn;
import kafka.log.Log$;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateEntry$;
import kafka.log.ProducerStateManager;
import kafka.log.TxnMetadata;
import kafka.log.ValidationType;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTxnStateException;
import org.apache.kafka.common.errors.OutOfOrderSequenceException;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.errors.TransactionCoordinatorFencedException;
import org.apache.kafka.common.errors.UnknownProducerIdException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.junit.JUnitSuite;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t]f\u0001B\u0001\u0003\u0001\u001d\u0011\u0001\u0004\u0015:pIV\u001cWM]*uCR,W*\u00198bO\u0016\u0014H+Z:u\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n!5\t!B\u0003\u0002\f\u0019\u0005)!.\u001e8ji*\u0011QBD\u0001\ng\u000e\fG.\u0019;fgRT\u0011aD\u0001\u0004_J<\u0017BA\t\u000b\u0005)QUK\\5u'VLG/\u001a\u0005\u0006'\u0001!\t\u0001F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0001\"A\u0006\u0001\u000e\u0003\tAq\u0001\u0007\u0001A\u0002\u0013\u0005\u0011$\u0001\u0004m_\u001e$\u0015N]\u000b\u00025A\u00111\u0004I\u0007\u00029)\u0011QDH\u0001\u0003S>T\u0011aH\u0001\u0005U\u00064\u0018-\u0003\u0002\"9\t!a)\u001b7f\u0011\u001d\u0019\u0003\u00011A\u0005\u0002\u0011\n!\u0002\\8h\t&\u0014x\fJ3r)\t)3\u0006\u0005\u0002'S5\tqEC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQsE\u0001\u0003V]&$\bb\u0002\u0017#\u0003\u0003\u0005\rAG\u0001\u0004q\u0012\n\u0004B\u0002\u0018\u0001A\u0003&!$A\u0004m_\u001e$\u0015N\u001d\u0011\t\u000fA\u0002\u0001\u0019!C\u0001c\u0005a1\u000f^1uK6\u000bg.Y4feV\t!\u0007\u0005\u0002\u0017g%\u0011AG\u0001\u0002\u0015!J|G-^2feN#\u0018\r^3NC:\fw-\u001a:\t\u000fY\u0002\u0001\u0019!C\u0001o\u0005\u00012\u000f^1uK6\u000bg.Y4fe~#S-\u001d\u000b\u0003KaBq\u0001L\u001b\u0002\u0002\u0003\u0007!\u0007\u0003\u0004;\u0001\u0001\u0006KAM\u0001\u000egR\fG/Z'b]\u0006<WM\u001d\u0011\t\u000fq\u0002!\u0019!C\u0001{\u0005I\u0001/\u0019:uSRLwN\\\u000b\u0002}A\u0011q(R\u0007\u0002\u0001*\u0011\u0011IQ\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015\u0019%B\u0001#\u000f\u0003\u0019\t\u0007/Y2iK&\u0011a\t\u0011\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019A\u0005\u0001)A\u0005}\u0005Q\u0001/\u0019:uSRLwN\u001c\u0011\t\u000f)\u0003!\u0019!C\u0001\u0017\u0006Q\u0001O]8ek\u000e,'/\u00133\u0016\u00031\u0003\"AJ'\n\u00059;#\u0001\u0002'p]\u001eDa\u0001\u0015\u0001!\u0002\u0013a\u0015a\u00039s_\u0012,8-\u001a:JI\u0002BqA\u0015\u0001C\u0002\u0013\u00051+\u0001\nnCb\u0004\u0016\u000eZ#ya&\u0014\u0018\r^5p]6\u001bX#\u0001+\u0011\u0005\u0019*\u0016B\u0001,(\u0005\rIe\u000e\u001e\u0005\u00071\u0002\u0001\u000b\u0011\u0002+\u0002'5\f\u0007\u0010U5e\u000bb\u0004\u0018N]1uS>tWj\u001d\u0011\t\u000fi\u0003!\u0019!C\u00017\u0006!A/[7f+\u0005a\u0006CA/a\u001b\u0005q&BA0A\u0003\u0015)H/\u001b7t\u0013\t\tgL\u0001\u0005N_\u000e\\G+[7f\u0011\u0019\u0019\u0007\u0001)A\u00059\u0006)A/[7fA!)Q\r\u0001C\u0001M\u0006)1/\u001a;VaR\tQ\u0005\u000b\u0002eQB\u0011\u0011n[\u0007\u0002U*\u00111BD\u0005\u0003Y*\u0014aAQ3g_J,\u0007\"\u00028\u0001\t\u00031\u0017\u0001\u0003;fCJ$un\u001e8)\u00055\u0004\bCA5r\u0013\t\u0011(NA\u0003BMR,'\u000fC\u0003u\u0001\u0011\u0005a-\u0001\nuKN$()Y:jG&#W*\u00199qS:<\u0007FA:w!\tIw/\u0003\u0002yU\n!A+Z:u\u0011\u0015Q\b\u0001\"\u0001g\u0003y!Xm\u001d;Qe>$WoY3s'\u0016\fX/\u001a8dK^\u0013\u0018\r]!s_VtG\r\u000b\u0002zm\")Q\u0010\u0001C\u0001M\u0006)C/Z:u!J|G-^2feN+\u0017/^3oG\u0016LeN^1mS\u0012<&/\u00199Be>,h\u000e\u001a\u0015\u0006yZ|\u0018\u0011A\u0001\tKb\u0004Xm\u0019;fI\u000e\u0012\u00111\u0001\t\u0005\u0003\u000b\tY!\u0004\u0002\u0002\b)\u0019\u0011\u0011\u0002!\u0002\r\u0015\u0014(o\u001c:t\u0013\u0011\ti!a\u0002\u00037=+Ho\u00144Pe\u0012,'oU3rk\u0016t7-Z#yG\u0016\u0004H/[8o\u0011\u0019\t\t\u0002\u0001C\u0001M\u0006QC/Z:u\u001d>4\u0016\r\\5eCRLwN\\(o\r&\u00148\u000f^#oiJLx\u000b[3o\u0019>\fG-\u001b8h\u0019><\u0007fAA\bm\"1\u0011q\u0003\u0001\u0005\u0002\u0019\f1\u0004^3ti\u000e{g\u000e\u001e:pYJ+7m\u001c:e\u0005Vl\u0007o]#q_\u000eD\u0007fAA\u000bm\"1\u0011Q\u0004\u0001\u0005\u0002\u0019\f\u0001\u0005^3tiRChNR5sgR|eMZ:fi6+G/\u00193bi\u0006\u001c\u0015m\u00195fI\"\u001a\u00111\u0004<\t\r\u0005\r\u0002\u0001\"\u0001g\u00039\"Xm\u001d;O_:l\u0015\r^2iS:<G\u000b\u001f8GSJ\u001cHo\u00144gg\u0016$X*\u001a;bI\u0006$\u0018MT8u\u0007\u0006\u001c\u0007.\u001a3)\u0007\u0005\u0005b\u000f\u0003\u0004\u0002*\u0001!\tAZ\u0001\u001fi\u0016\u001cH\u000f\u0015:fa\u0006\u0014X-\u00169eCR,Gi\\3t\u001d>$X*\u001e;bi\u0016D3!a\nw\u0011\u0019\ty\u0003\u0001C\u0001M\u0006qR\u000f\u001d3bi\u0016\u0004&o\u001c3vG\u0016\u0014HK]1og\u0006\u001cG/[8o'R\fG/\u001a\u0015\u0004\u0003[1\bBBA\u001b\u0001\u0011\u0005a-\u0001\u0017uKN$x*\u001e;PMN+\u0017/^3oG\u0016\fe\r^3s\u0007>tGO]8m%\u0016\u001cwN\u001d3Fa>\u001c\u0007NQ;na\"\u001a\u00111\u0007<\t\r\u0005m\u0002\u0001\"\u0001g\u0003A\"Xm\u001d;O_:$&/\u00198tC\u000e$\u0018n\u001c8bY\u0006\u0003\b/\u001a8e/&$\bn\u00148h_&tw\r\u0016:b]N\f7\r^5p]\"2\u0011\u0011\b<\u0000\u0003\u007f\u0019#!!\u0011\u0011\t\u0005\u0015\u00111I\u0005\u0005\u0003\u000b\n9A\u0001\rJ]Z\fG.\u001b3Uq:\u001cF/\u0019;f\u000bb\u001cW\r\u001d;j_:Da!!\u0013\u0001\t\u00031\u0017a\f;fgR$&/\u001e8dCR,\u0017I\u001c3SK2|\u0017\r\u001a*f[>4Xm](vi>3'+\u00198hKNs\u0017\r]:i_R\u001c\bfAA$m\"1\u0011q\n\u0001\u0005\u0002\u0019\f\u0001\u0003^3tiR\u000b7.Z*oCB\u001c\bn\u001c;)\u0007\u00055c\u000f\u0003\u0004\u0002V\u0001!\tAZ\u0001\u0018i\u0016\u001cHOU3d_Z,'O\u0012:p[Ns\u0017\r]:i_RD3!a\u0015w\u0011\u0019\tY\u0006\u0001C\u0001M\u0006iB/Z:u%\u0016lwN^3FqBL'/\u001a3QS\u0012\u001cxJ\u001c*fY>\fG\r\u000b\u0004\u0002ZY|\u0018qL\u0012\u0003\u0003C\u0002B!!\u0002\u0002d%!\u0011QMA\u0004\u0005i)fn\u001b8po:\u0004&o\u001c3vG\u0016\u0014\u0018\nZ#yG\u0016\u0004H/[8o\u0011\u0019\tI\u0007\u0001C\u0001M\u0006iC/Z:u\u0003\u000e\u001cW\r\u001d;BaB,g\u000eZ,ji\"|W\u000f\u001e)s_\u0012,8-\u001a:Ti\u0006$Xm\u00148SKBd\u0017nY1)\u0007\u0005\u001dd\u000f\u0003\u0004\u0002p\u0001!\tAZ\u0001*i\u0016\u001cH/Q2dKB$\u0018\t\u001d9f]\u0012<\u0016\u000e\u001e5TKF,XM\\2f\u000f\u0006\u00048o\u00148SKBd\u0017nY1)\u0007\u00055d\u000f\u0003\u0004\u0002v\u0001!\tAZ\u0001\u001ai\u0016\u001cH\u000fR3mKR,7K\\1qg\"|Go\u001d\"fM>\u0014X\rK\u0002\u0002tYDa!a\u001f\u0001\t\u00031\u0017\u0001\u0004;fgR$&/\u001e8dCR,\u0007fAA=m\"1\u0011\u0011\u0011\u0001\u0005\u0002\u0019\fa\u0005^3ti\u001aK'o\u001d;V]N$\u0018M\u00197f\u001f\u001a47/\u001a;BMR,'\u000f\u0016:v]\u000e\fG/[8oQ\r\tyH\u001e\u0005\u0007\u0003\u000f\u0003A\u0011\u00014\u0002IQ,7\u000f\u001e$jeN$XK\\:uC\ndWm\u00144gg\u0016$\u0018I\u001a;fe\u00163\u0018n\u0019;j_:D3!!\"w\u0011\u0019\ti\t\u0001C\u0001M\u0006\u0001B/Z:u)J,hnY1uK\"+\u0017\r\u001a\u0015\u0004\u0003\u00173\bBBAJ\u0001\u0011\u0005a-A\u0018uKN$Hj\\1e\rJ|Wn\u00158baNDw\u000e\u001e*f[>4Xm\u001d(p]J+G/Y5oK\u0012\u0004&o\u001c3vG\u0016\u00148\u000fK\u0002\u0002\u0012ZDa!!'\u0001\t\u00031\u0017!\t;fgR\u001c6.\u001b9T]\u0006\u00048\u000f[8u\u0013\u001a|eMZ:fiVs7\r[1oO\u0016$\u0007fAALm\"1\u0011q\u0014\u0001\u0005\u0002\u0019\fq\u0002^3tiN#\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0015\u0004\u0003;3\bBBAS\u0001\u0011\u0005a-\u0001\ruKN$\b+\u001b3FqBL'/\u0019;j_:$\u0016.\\3pkRDc!a)w\u007f\u0006}\u0003BBAV\u0001\u0011\u0005a-A\fuKN$h)\u001b:tiVs7\u000f^1cY\u0016|eMZ:fi\"\u001a\u0011\u0011\u0016<\t\r\u0005E\u0006\u0001\"\u0001g\u00039\"Xm\u001d;Qe>$WoY3sg^KG\u000f[(oO>Lgn\u001a+sC:\u001c\u0018m\u0019;j_:\u001cHi\u001c8u\u000bb\u0004\u0018N]3)\u0007\u0005=f\u000f\u0003\u0004\u00028\u0002!\tAZ\u0001.i\u0016\u001cHoU3rk\u0016t7-\u001a(piZ\u000bG.\u001b3bi\u0016$gi\u001c:He>,\b/T3uC\u0012\fG/\u0019+pa&\u001c\u0007fAA[m\"1\u0011Q\u0018\u0001\u0005\u0002\u0019\fA\u0004^3ti>cG-\u00129pG\"4uN]\"p]R\u0014x\u000e\u001c*fG>\u0014H\r\u000b\u0004\u0002<Z|\u0018\u0011Y\u0012\u0003\u0003\u0007\u0004B!!\u0002\u0002F&!\u0011qYA\u0004\u0005]\u0001&o\u001c3vG\u0016\u0014h)\u001a8dK\u0012,\u0005pY3qi&|g\u000e\u0003\u0004\u0002L\u0002!\tAZ\u0001\u0017i\u0016\u001cHoQ8pe\u0012Lg.\u0019;pe\u001a+gnY5oO\"\u001a\u0011\u0011\u001a<\t\r\u0005E\u0007\u0001\"\u0001g\u0003\u0001\"Xm\u001d;D_>\u0014H-\u001b8bi>\u0014h)\u001a8dK\u0012\fe\r^3s%\u0016dw.\u00193)\r\u0005=go`AkG\t\t9\u000e\u0005\u0003\u0002\u0006\u0005e\u0017\u0002BAn\u0003\u000f\u0011Q\u0005\u0016:b]N\f7\r^5p]\u000e{wN\u001d3j]\u0006$xN\u001d$f]\u000e,G-\u0012=dKB$\u0018n\u001c8\t\r\u0005}\u0007\u0001\"\u0001g\u0003u!Xm\u001d;M_\u0006$gI]8n\u000b6\u0004H/_*oCB\u001c\bn\u001c;GS2,\u0007fAAom\"1\u0011Q\u001d\u0001\u0005\u0002\u0019\f\u0011\u0005^3ti2{\u0017\r\u001a$s_6$&/\u001e8dCR,Gm\u00158baNDw\u000e\u001e$jY\u0016D3!a9w\u0011\u0019\tY\u000f\u0001C\u0001M\u0006yB/Z:u\u0019>\fGM\u0012:p[\u000e{'O];qiNs\u0017\r]:i_R4\u0015\u000e\\3)\u0007\u0005%h\u000fC\u0004\u0002r\u0002!I!a=\u00027Q,7\u000f\u001e'pC\u00124%o\\7D_J\u0014X\u000f\u001d;T]\u0006\u00048\u000f[8u)\r)\u0013Q\u001f\u0005\t\u0003o\fy\u000f1\u0001\u0002z\u0006yQ.Y6f\r&dWmQ8seV\u0004H\u000f\u0005\u0004'\u0003w\fy0J\u0005\u0004\u0003{<#!\u0003$v]\u000e$\u0018n\u001c82!\u0011\u0011\tAa\u0003\u000e\u0005\t\r!\u0002\u0002B\u0003\u0005\u000f\t\u0001b\u00195b]:,Gn\u001d\u0006\u0004\u0005\u0013q\u0012a\u00018j_&!!Q\u0002B\u0002\u0005-1\u0015\u000e\\3DQ\u0006tg.\u001a7\t\u000f\tE\u0001\u0001\"\u0003\u0003\u0014\u0005\u0011\u0012\r\u001d9f]\u0012,e\u000e\u001a+y]6\u000b'o[3s)A\u0011)B!\t\u0003&\t\u001d\"\u0011\u0007B!\u0005\u000b\u0012I\u0005\u0005\u0004'\u0005/\u0011Y\u0002T\u0005\u0004\u000539#A\u0002+va2,'\u0007E\u0002\u0017\u0005;I1Aa\b\u0003\u00051\u0019u.\u001c9mKR,G\r\u0016=o\u0011\u001d\u0011\u0019Ca\u0004A\u0002I\nq!\\1qa&tw\r\u0003\u0004K\u0005\u001f\u0001\r\u0001\u0014\u0005\t\u0005S\u0011y\u00011\u0001\u0003,\u0005i\u0001O]8ek\u000e,'/\u00129pG\"\u00042A\nB\u0017\u0013\r\u0011yc\n\u0002\u0006'\"|'\u000f\u001e\u0005\t\u0005g\u0011y\u00011\u0001\u00036\u0005Y1m\u001c8ue>dG+\u001f9f!\u0011\u00119D!\u0010\u000e\u0005\te\"b\u0001B\u001e\u0001\u00061!/Z2pe\u0012LAAa\u0010\u0003:\t\t2i\u001c8ue>d'+Z2pe\u0012$\u0016\u0010]3\t\u000f\t\r#q\u0002a\u0001\u0019\u00061qN\u001a4tKRD\u0011Ba\u0012\u0003\u0010A\u0005\t\u0019\u0001+\u0002!\r|wN\u001d3j]\u0006$xN]#q_\u000eD\u0007\"\u0003B&\u0005\u001f\u0001\n\u00111\u0001M\u0003%!\u0018.\\3ti\u0006l\u0007\u000fC\u0004\u0003P\u0001!IA!\u0015\u0002\r\u0005\u0004\b/\u001a8e)E)#1\u000bB+\u0005/\u0012IF!\u0018\u0003`\t\u0005$1\u000e\u0005\u0007a\t5\u0003\u0019\u0001\u001a\t\r)\u0013i\u00051\u0001M\u0011!\u0011IC!\u0014A\u0002\t-\u0002b\u0002B.\u0005\u001b\u0002\r\u0001V\u0001\u0004g\u0016\f\bb\u0002B\"\u0005\u001b\u0002\r\u0001\u0014\u0005\n\u0005\u0017\u0012i\u0005%AA\u00021C!Ba\u0019\u0003NA\u0005\t\u0019\u0001B3\u0003=I7\u000f\u0016:b]N\f7\r^5p]\u0006d\u0007c\u0001\u0014\u0003h%\u0019!\u0011N\u0014\u0003\u000f\t{w\u000e\\3b]\"Q!Q\u000eB'!\u0003\u0005\rA!\u001a\u0002\u0019%\u001chI]8n\u00072LWM\u001c;\t\u000f\tE\u0004\u0001\"\u0003\u0003t\u000512-\u001e:sK:$8K\\1qg\"|Go\u00144gg\u0016$8/\u0006\u0002\u0003vA)!q\u000fBA\u00196\u0011!\u0011\u0010\u0006\u0005\u0005w\u0012i(A\u0005j[6,H/\u00192mK*\u0019!qP\u0014\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003\u0004\ne$aA*fi\"I!q\u0011\u0001\u0012\u0002\u0013%!\u0011R\u0001\u0011CB\u0004XM\u001c3%I\u00164\u0017-\u001e7uIY*\"Aa#+\u00071\u0013ii\u000b\u0002\u0003\u0010B!!\u0011\u0013BN\u001b\t\u0011\u0019J\u0003\u0003\u0003\u0016\n]\u0015!C;oG\",7m[3e\u0015\r\u0011IjJ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002BO\u0005'\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\u0011\t\u000bAI\u0001\n\u0013\u0011\u0019+\u0001\tbaB,g\u000e\u001a\u0013eK\u001a\fW\u000f\u001c;%oU\u0011!Q\u0015\u0016\u0005\u0005K\u0012i\tC\u0005\u0003*\u0002\t\n\u0011\"\u0003\u0003$\u0006\u0001\u0012\r\u001d9f]\u0012$C-\u001a4bk2$H\u0005\u000f\u0005\n\u0005[\u0003\u0011\u0013!C\u0005\u0005_\u000bA$\u00199qK:$WI\u001c3Uq:l\u0015M]6fe\u0012\"WMZ1vYR$c'\u0006\u0002\u00032*\u001aAK!$\t\u0013\tU\u0006!%A\u0005\n\t%\u0015\u0001H1qa\u0016tG-\u00128e)btW*\u0019:lKJ$C-\u001a4bk2$He\u000e")
public class ProducerStateManagerTest
extends JUnitSuite {
    private File logDir = null;
    private ProducerStateManager stateManager = null;
    private final TopicPartition partition = new TopicPartition("test", 0);
    private final long producerId;
    private final int maxPidExpirationMs;
    private final MockTime time = new MockTime();

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public ProducerStateManager stateManager() {
        return this.stateManager;
    }

    public void stateManager_$eq(ProducerStateManager x$1) {
        this.stateManager = x$1;
    }

    public TopicPartition partition() {
        return this.partition;
    }

    public long producerId() {
        return this.producerId;
    }

    public int maxPidExpirationMs() {
        return this.maxPidExpirationMs;
    }

    public MockTime time() {
        return this.time;
    }

    @Before
    public void setUp() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
        this.stateManager_$eq(new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs()));
    }

    @After
    public void tearDown() {
        Utils.delete((File)this.logDir());
    }

    @Test
    public void testBasicIdMapping() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 0L, 1L, this.append$default$7(), this.append$default$8());
        this.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.append(this.stateManager(), this.producerId(), epoch, 1, 0L, 1L, this.append$default$7(), this.append$default$8()), ClassTag$.MODULE$.apply(OutOfOrderSequenceException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
        this.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.append(this.stateManager(), this.producerId(), epoch, 5, 0L, 2L, this.append$default$7(), this.append$default$8()), ClassTag$.MODULE$.apply(OutOfOrderSequenceException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        this.append(this.stateManager(), this.producerId(), (short)(epoch + 1), 0, 0L, 3L, this.append$default$7(), this.append$default$8());
        this.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 4L, this.append$default$7(), this.append$default$8()), ClassTag$.MODULE$.apply(ProducerFencedException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
    }

    @Test
    public void testProducerSequenceWrapAround() {
        short epoch = (short)15;
        int sequence = Integer.MAX_VALUE;
        long offset = 735L;
        ProducerStateManager x$17 = this.stateManager();
        long x$18 = this.producerId();
        short x$19 = epoch;
        int x$20 = sequence;
        long x$21 = offset;
        boolean x$22 = false;
        long x$23 = this.append$default$6();
        boolean x$24 = this.append$default$7();
        this.append(x$17, x$18, x$19, x$20, x$21, x$23, x$24, x$22);
        this.append(this.stateManager(), this.producerId(), epoch, 0, offset + 500L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assert.assertTrue((boolean)maybeLastEntry.isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assert.assertEquals((long)epoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)0L, (long)lastEntry.lastSeq());
    }

    @Test(expected=OutOfOrderSequenceException.class)
    public void testProducerSequenceInvalidWrapAround() {
        short epoch = (short)15;
        int sequence = Integer.MAX_VALUE;
        long offset = 735L;
        ProducerStateManager x$25 = this.stateManager();
        long x$26 = this.producerId();
        short x$27 = epoch;
        int x$28 = sequence;
        long x$29 = offset;
        boolean x$30 = false;
        long x$31 = this.append$default$6();
        boolean x$32 = this.append$default$7();
        this.append(x$25, x$26, x$27, x$28, x$29, x$31, x$32, x$30);
        this.append(this.stateManager(), this.producerId(), epoch, 1, offset + 500L, this.append$default$6(), this.append$default$7(), this.append$default$8());
    }

    @Test
    public void testNoValidationOnFirstEntryWhenLoadingLog() {
        short epoch = (short)5;
        int sequence = 16;
        long offset = 735L;
        ProducerStateManager x$33 = this.stateManager();
        long x$34 = this.producerId();
        short x$35 = epoch;
        int x$36 = sequence;
        long x$37 = offset;
        boolean x$38 = false;
        long x$39 = this.append$default$6();
        boolean x$40 = this.append$default$7();
        this.append(x$33, x$34, x$35, x$36, x$37, x$39, x$40, x$38);
        Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assert.assertTrue((boolean)maybeLastEntry.isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assert.assertEquals((long)epoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)sequence, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)sequence, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)offset, (long)lastEntry.lastDataOffset());
        Assert.assertEquals((long)offset, (long)lastEntry.firstOffset());
    }

    @Test
    public void testControlRecordBumpsEpoch() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        short bumpedEpoch = (short)1;
        Tuple2<CompletedTxn, Object> tuple2 = this.appendEndTxnMarker(this.stateManager(), this.producerId(), bumpedEpoch, ControlRecordType.ABORT, 1L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        CompletedTxn completedTxn = (CompletedTxn)tuple2._1();
        long lastStableOffset = tuple2._2$mcJ$sp();
        Tuple2 tuple22 = new Tuple2((Object)completedTxn, (Object)BoxesRunTime.boxToLong((long)lastStableOffset));
        Tuple2 tuple23 = tuple22;
        CompletedTxn completedTxn2 = (CompletedTxn)tuple23._1();
        long lastStableOffset2 = tuple23._2$mcJ$sp();
        Assert.assertEquals((long)1L, (long)completedTxn2.firstOffset());
        Assert.assertEquals((long)1L, (long)completedTxn2.lastOffset());
        Assert.assertEquals((long)2L, (long)lastStableOffset2);
        Assert.assertTrue((boolean)completedTxn2.isAborted());
        Assert.assertEquals((long)this.producerId(), (long)completedTxn2.producerId());
        Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assert.assertTrue((boolean)maybeLastEntry.isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assert.assertEquals((long)bumpedEpoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((Object)None$.MODULE$, (Object)lastEntry.currentTxnFirstOffset());
        Assert.assertEquals((long)-1L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)-1L, (long)lastEntry.lastSeq());
        this.append(this.stateManager(), this.producerId(), bumpedEpoch, 0, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)this.stateManager().lastEntry(this.producerId()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.firstSeq())));
    }

    @Test
    public void testTxnFirstOffsetMetadataCached() {
        short producerEpoch = (short)0;
        long offset = 992342L;
        int seq = 0;
        ProducerAppendInfo producerAppendInfo = new ProducerAppendInfo(this.producerId(), ProducerStateEntry$.MODULE$.empty(this.producerId()), (ValidationType)ValidationType.Full$.MODULE$);
        producerAppendInfo.append(producerEpoch, seq, seq, this.time().milliseconds(), offset, true);
        LogOffsetMetadata logOffsetMetadata = new LogOffsetMetadata(offset, 990000L, 234224);
        producerAppendInfo.maybeCacheTxnFirstOffsetMetadata(logOffsetMetadata);
        this.stateManager().update(producerAppendInfo);
        Assert.assertEquals((Object)new Some((Object)logOffsetMetadata), (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testNonMatchingTxnFirstOffsetMetadataNotCached() {
        short producerEpoch = (short)0;
        long offset = 992342L;
        int seq = 0;
        ProducerAppendInfo producerAppendInfo = new ProducerAppendInfo(this.producerId(), ProducerStateEntry$.MODULE$.empty(this.producerId()), (ValidationType)ValidationType.Full$.MODULE$);
        producerAppendInfo.append(producerEpoch, seq, seq, this.time().milliseconds(), offset, true);
        LogOffsetMetadata logOffsetMetadata = new LogOffsetMetadata(offset - 23429L, 990000L, 234224);
        producerAppendInfo.maybeCacheTxnFirstOffsetMetadata(logOffsetMetadata);
        this.stateManager().update(producerAppendInfo);
        Assert.assertEquals((Object)new Some((Object)new LogOffsetMetadata(offset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3())), (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testPrepareUpdateDoesNotMutate() {
        short producerEpoch = (short)0;
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), true);
        appendInfo.append(producerEpoch, 0, 5, this.time().milliseconds(), 20L, false);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().lastEntry(this.producerId()));
        this.stateManager().update(appendInfo);
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        ProducerAppendInfo nextAppendInfo = this.stateManager().prepareUpdate(this.producerId(), true);
        nextAppendInfo.append(producerEpoch, 6, 10, this.time().milliseconds(), 30L, false);
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assert.assertEquals((long)0L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)5L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)20L, (long)lastEntry.lastDataOffset());
        this.stateManager().update(nextAppendInfo);
        lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assert.assertEquals((long)0L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)10L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
    }

    @Test
    public void updateProducerTransactionState() {
        short producerEpoch = (short)0;
        int coordinatorEpoch = 15;
        long offset = 9L;
        this.append(this.stateManager(), this.producerId(), producerEpoch, 0, offset, this.append$default$6(), this.append$default$7(), this.append$default$8());
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), true);
        appendInfo.append(producerEpoch, 1, 5, this.time().milliseconds(), 20L, true);
        ProducerStateEntry lastEntry = appendInfo.toEntry();
        Assert.assertEquals((long)producerEpoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)1L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)5L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)16L, (long)lastEntry.firstOffset());
        Assert.assertEquals((long)20L, (long)lastEntry.lastDataOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)16L)), (Object)lastEntry.currentTxnFirstOffset());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TxnMetadata[]{new TxnMetadata(this.producerId(), 16L)})), (Object)appendInfo.startedTransactions());
        appendInfo.append(producerEpoch, 6, 10, this.time().milliseconds(), 30L, true);
        lastEntry = appendInfo.toEntry();
        Assert.assertEquals((long)producerEpoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)1L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)10L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)16L, (long)lastEntry.firstOffset());
        Assert.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)16L)), (Object)lastEntry.currentTxnFirstOffset());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TxnMetadata[]{new TxnMetadata(this.producerId(), 16L)})), (Object)appendInfo.startedTransactions());
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, coordinatorEpoch);
        CompletedTxn completedTxn = appendInfo.appendEndTxnMarker(endTxnMarker, producerEpoch, 40L, this.time().milliseconds());
        Assert.assertEquals((long)this.producerId(), (long)completedTxn.producerId());
        Assert.assertEquals((long)16L, (long)completedTxn.firstOffset());
        Assert.assertEquals((long)40L, (long)completedTxn.lastOffset());
        Assert.assertFalse((boolean)completedTxn.isAborted());
        lastEntry = appendInfo.toEntry();
        Assert.assertEquals((long)producerEpoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)1L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)10L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)16L, (long)lastEntry.firstOffset());
        Assert.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
        Assert.assertEquals((long)coordinatorEpoch, (long)lastEntry.coordinatorEpoch());
        Assert.assertEquals((Object)None$.MODULE$, (Object)lastEntry.currentTxnFirstOffset());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TxnMetadata[]{new TxnMetadata(this.producerId(), 16L)})), (Object)appendInfo.startedTransactions());
    }

    @Test
    public void testOutOfSequenceAfterControlRecordEpochBump() {
        short epoch = (short)0;
        ProducerStateManager x$41 = this.stateManager();
        long x$42 = this.producerId();
        short x$43 = epoch;
        int x$44 = 0;
        long x$45 = 0L;
        boolean x$46 = true;
        long x$47 = this.append$default$6();
        boolean x$48 = this.append$default$8();
        this.append(x$41, x$42, x$43, x$44, x$45, x$47, x$46, x$48);
        ProducerStateManager x$49 = this.stateManager();
        long x$50 = this.producerId();
        short x$51 = epoch;
        int x$52 = 1;
        long x$53 = 1L;
        boolean x$54 = true;
        long x$55 = this.append$default$6();
        boolean x$56 = this.append$default$8();
        this.append(x$49, x$50, x$51, x$52, x$53, x$55, x$54, x$56);
        short bumpedEpoch = (short)1;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), bumpedEpoch, ControlRecordType.ABORT, 1L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        this.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ProducerStateManager x$57 = this.stateManager();
            long x$58 = this.producerId();
            short x$59 = bumpedEpoch;
            int x$60 = 2;
            long x$61 = 2L;
            boolean x$62 = true;
            long x$63 = this.append$default$6();
            boolean x$64 = this.append$default$8();
            this.append(x$57, x$58, x$59, x$60, x$61, x$63, x$62, x$64);
        }, ClassTag$.MODULE$.apply(OutOfOrderSequenceException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 274));
        this.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ProducerStateManager x$65 = this.stateManager();
            long x$66 = this.producerId();
            short x$67 = (short)(bumpedEpoch + 1);
            int x$68 = 2;
            long x$69 = 2L;
            boolean x$70 = true;
            long x$71 = this.append$default$6();
            boolean x$72 = this.append$default$8();
            this.append(x$65, x$66, x$67, x$68, x$69, x$71, x$70, x$72);
        }, ClassTag$.MODULE$.apply(OutOfOrderSequenceException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
        ProducerStateManager x$73 = this.stateManager();
        long x$74 = this.producerId();
        short x$75 = bumpedEpoch;
        int x$76 = 0;
        long x$77 = 0L;
        boolean x$78 = true;
        long x$79 = this.append$default$6();
        boolean x$80 = this.append$default$8();
        this.append(x$73, x$74, x$75, x$76, x$77, x$79, x$78, x$80);
        Assert.assertEquals((long)bumpedEpoch, (long)((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).producerEpoch());
        Assert.assertEquals((long)0L, (long)((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).lastSeq());
    }

    @Test(expected=InvalidTxnStateException.class)
    public void testNonTransactionalAppendWithOngoingTransaction() {
        short epoch = (short)0;
        ProducerStateManager x$81 = this.stateManager();
        long x$82 = this.producerId();
        short x$83 = epoch;
        int x$84 = 0;
        long x$85 = 0L;
        boolean x$86 = true;
        long x$87 = this.append$default$6();
        boolean x$88 = this.append$default$8();
        this.append(x$81, x$82, x$83, x$84, x$85, x$87, x$86, x$88);
        ProducerStateManager x$89 = this.stateManager();
        long x$90 = this.producerId();
        short x$91 = epoch;
        int x$92 = 1;
        long x$93 = 1L;
        boolean x$94 = false;
        long x$95 = this.append$default$6();
        boolean x$96 = this.append$default$8();
        this.append(x$89, x$90, x$91, x$92, x$93, x$95, x$94, x$96);
    }

    @Test
    public void testTruncateAndReloadRemovesOutOfRangeSnapshots() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 3, 3L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 4, 4L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.stateManager().truncateAndReload(1L, 3L, this.time().milliseconds());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)this.stateManager().oldestSnapshotOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)3L)), (Object)this.stateManager().latestSnapshotOffset());
    }

    @Test
    public void testTakeSnapshot() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((String)"Directory doesn't contain a single file as expected", (long)1L, (long)this.logDir().list().length);
        Assert.assertTrue((String)"Snapshot file is empty", (((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().list())).head()).length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRecoverFromSnapshot() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 3L, this.time().milliseconds());
        this.append(recoveredMapping, this.producerId(), epoch, 2, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
    }

    @Test(expected=UnknownProducerIdException.class)
    public void testRemoveExpiredPidsOnReload() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 1L, 70000L);
        this.append(recoveredMapping, this.producerId(), epoch, 2, 2L, 70001L, this.append$default$7(), this.append$default$8());
    }

    @Test
    public void testAcceptAppendWithoutProducerStateOnReplica() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 1L, 70000L);
        int sequence = 2;
        Assert.assertFalse((boolean)recoveredMapping.activeProducers().contains((Object)BoxesRunTime.boxToLong((long)this.producerId())));
        ProducerStateManager x$97 = recoveredMapping;
        long x$98 = this.producerId();
        short x$99 = epoch;
        int x$100 = sequence;
        long x$101 = 2L;
        long x$102 = 70001L;
        boolean x$103 = false;
        boolean x$104 = this.append$default$7();
        this.append(x$97, x$98, x$99, x$100, x$101, x$102, x$104, x$103);
        Assert.assertTrue((boolean)recoveredMapping.activeProducers().contains((Object)BoxesRunTime.boxToLong((long)this.producerId())));
        ProducerStateEntry producerStateEntry = (ProducerStateEntry)Option$.MODULE$.option2Iterable(recoveredMapping.activeProducers().get((Object)BoxesRunTime.boxToLong((long)this.producerId()))).head();
        Assert.assertEquals((long)epoch, (long)producerStateEntry.producerEpoch());
        Assert.assertEquals((long)sequence, (long)producerStateEntry.firstSeq());
        Assert.assertEquals((long)sequence, (long)producerStateEntry.lastSeq());
    }

    @Test
    public void testAcceptAppendWithSequenceGapsOnReplica() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        int outOfOrderSequence = 3;
        try {
            ProducerStateManager x$105 = this.stateManager();
            long x$106 = this.producerId();
            short x$107 = epoch;
            int x$108 = outOfOrderSequence;
            long x$109 = 1L;
            long x$110 = 1L;
            boolean x$111 = true;
            boolean x$112 = this.append$default$7();
            this.append(x$105, x$106, x$107, x$108, x$109, x$110, x$112, x$111);
            throw this.fail("Expected an OutOfOrderSequenceException to be raised.", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 389));
        }
        catch (OutOfOrderSequenceException outOfOrderSequenceException) {
        }
        catch (Exception exception) {
            throw this.fail("Expected an OutOfOrderSequenceException to be raised.", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 394));
        }
        Assert.assertEquals((long)0L, (long)((ProducerStateEntry)this.stateManager().activeProducers().apply((Object)BoxesRunTime.boxToLong((long)this.producerId()))).lastSeq());
        ProducerStateManager x$113 = this.stateManager();
        long x$114 = this.producerId();
        short x$115 = epoch;
        int x$116 = outOfOrderSequence;
        long x$117 = 1L;
        long x$118 = 1L;
        boolean x$119 = false;
        boolean x$120 = this.append$default$7();
        this.append(x$113, x$114, x$115, x$116, x$117, x$118, x$120, x$119);
        Assert.assertEquals((long)outOfOrderSequence, (long)((ProducerStateEntry)this.stateManager().activeProducers().apply((Object)BoxesRunTime.boxToLong((long)this.producerId()))).lastSeq());
    }

    @Test
    public void testDeleteSnapshotsBefore() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)2L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.currentSnapshotOffsets());
        this.stateManager().deleteSnapshotsBefore(3L);
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.currentSnapshotOffsets());
        this.stateManager().deleteSnapshotsBefore(4L);
        Assert.assertEquals((long)0L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
    }

    @Test
    public void testTruncate() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)2L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.currentSnapshotOffsets());
        this.stateManager().truncate();
        Assert.assertEquals((long)0L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
    }

    @Test
    public void testFirstUnstableOffsetAfterTruncation() {
        short epoch = (short)0;
        int sequence = 0;
        ProducerStateManager x$121 = this.stateManager();
        long x$122 = this.producerId();
        short x$123 = epoch;
        int x$124 = sequence;
        long x$125 = 99L;
        boolean x$126 = true;
        long x$127 = this.append$default$6();
        boolean x$128 = this.append$default$8();
        this.append(x$121, x$122, x$123, x$124, x$125, x$127, x$126, x$128);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)99)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.messageOffset())));
        this.stateManager().takeSnapshot();
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 105L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        this.stateManager().onHighWatermarkUpdated(106L);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.messageOffset())));
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, sequence + 1, 106L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().truncateAndReload(0L, 106L, this.time().milliseconds());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.messageOffset())));
        this.stateManager().truncateAndReload(0L, 100L, this.time().milliseconds());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)99)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.messageOffset())));
    }

    @Test
    public void testFirstUnstableOffsetAfterEviction() {
        short epoch = (short)0;
        int sequence = 0;
        ProducerStateManager x$129 = this.stateManager();
        long x$130 = this.producerId();
        short x$131 = epoch;
        int x$132 = sequence;
        long x$133 = 99L;
        boolean x$134 = true;
        long x$135 = this.append$default$6();
        boolean x$136 = this.append$default$8();
        this.append(x$129, x$130, x$131, x$132, x$133, x$135, x$134, x$136);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)99)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.messageOffset())));
        ProducerStateManager x$137 = this.stateManager();
        long x$138 = 2L;
        short x$139 = epoch;
        int x$140 = 0;
        long x$141 = 106L;
        boolean x$142 = true;
        long x$143 = this.append$default$6();
        boolean x$144 = this.append$default$8();
        this.append(x$137, x$138, x$139, x$140, x$141, x$143, x$142, x$144);
        this.stateManager().truncateHead(100L);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)106)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.messageOffset())));
    }

    @Test
    public void testTruncateHead() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        long anotherPid = 2L;
        this.append(this.stateManager(), anotherPid, epoch, 0, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), anotherPid, epoch, 1, 3L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4})), this.currentSnapshotOffsets());
        this.stateManager().truncateHead(2L);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4})), this.currentSnapshotOffsets());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{anotherPid})), (Object)this.stateManager().activeProducers().keySet());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().lastEntry(this.producerId()));
        Option maybeEntry = this.stateManager().lastEntry(anotherPid);
        Assert.assertTrue((boolean)maybeEntry.isDefined());
        Assert.assertEquals((long)3L, (long)((ProducerStateEntry)maybeEntry.get()).lastDataOffset());
        this.stateManager().truncateHead(3L);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{anotherPid})), (Object)this.stateManager().activeProducers().keySet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4})), this.currentSnapshotOffsets());
        Assert.assertEquals((long)4L, (long)this.stateManager().mapEndOffset());
        this.stateManager().truncateHead(5L);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)this.stateManager().activeProducers().keySet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
        Assert.assertEquals((long)5L, (long)this.stateManager().mapEndOffset());
    }

    @Test
    public void testLoadFromSnapshotRemovesNonRetainedProducers() {
        short epoch = (short)0;
        long pid1 = 1L;
        long pid2 = 2L;
        this.append(this.stateManager(), pid1, epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), pid2, epoch, 0, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)2L, (long)this.stateManager().activeProducers().size());
        this.stateManager().truncateAndReload(1L, 2L, this.time().milliseconds());
        Assert.assertEquals((long)1L, (long)this.stateManager().activeProducers().size());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().lastEntry(pid1));
        Option entry = this.stateManager().lastEntry(pid2);
        Assert.assertTrue((boolean)entry.isDefined());
        Assert.assertEquals((long)0L, (long)((ProducerStateEntry)entry.get()).lastSeq());
        Assert.assertEquals((long)1L, (long)((ProducerStateEntry)entry.get()).lastDataOffset());
    }

    @Test
    public void testSkipSnapshotIfOffsetUnchanged() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
    }

    @Test
    public void testStartOffset() {
        short epoch = (short)0;
        long pid2 = 2L;
        this.append(this.stateManager(), pid2, epoch, 0, 0L, 1L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 0, 1L, 2L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 2L, 3L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 2, 3L, 4L, this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
            recoveredMapping.truncateAndReload(0L, 1L, this.time().milliseconds());
            this.append(recoveredMapping, pid2, epoch, 1, 4L, 5L, this.append$default$7(), this.append$default$8());
        }, ClassTag$.MODULE$.apply(UnknownProducerIdException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 564));
    }

    @Test(expected=UnknownProducerIdException.class)
    public void testPidExpirationTimeout() {
        short epoch = (short)5;
        int sequence = 37;
        this.append(this.stateManager(), this.producerId(), epoch, sequence, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.time().sleep((long)(this.maxPidExpirationMs() + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        this.append(this.stateManager(), this.producerId(), epoch, sequence + 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
    }

    @Test
    public void testFirstUnstableOffset() {
        short epoch = (short)5;
        int sequence = 0;
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        ProducerStateManager x$145 = this.stateManager();
        long x$146 = this.producerId();
        short x$147 = epoch;
        int x$148 = sequence;
        long x$149 = 99L;
        boolean x$150 = true;
        long x$151 = this.append$default$6();
        boolean x$152 = this.append$default$8();
        this.append(x$145, x$146, x$147, x$148, x$149, x$151, x$150, x$152);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.messageOffset())));
        long anotherPid = 2L;
        ProducerStateManager x$153 = this.stateManager();
        long x$154 = anotherPid;
        short x$155 = epoch;
        int x$156 = sequence;
        long x$157 = 105L;
        boolean x$158 = true;
        long x$159 = this.append$default$6();
        boolean x$160 = this.append$default$8();
        this.append(x$153, x$154, x$155, x$156, x$157, x$159, x$158, x$160);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.messageOffset())));
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 109L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)this.stateManager().firstUndecidedOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.messageOffset())));
        this.stateManager().onHighWatermarkUpdated(100L);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.messageOffset())));
        this.stateManager().onHighWatermarkUpdated(110L);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.messageOffset())));
        this.appendEndTxnMarker(this.stateManager(), anotherPid, epoch, ControlRecordType.ABORT, 112L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)x$14.messageOffset())));
        this.stateManager().onHighWatermarkUpdated(113L);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToLong((long)x$15.messageOffset())));
    }

    @Test
    public void testProducersWithOngoingTransactionsDontExpire() {
        short epoch = (short)5;
        int sequence = 0;
        ProducerStateManager x$161 = this.stateManager();
        long x$162 = this.producerId();
        short x$163 = epoch;
        int x$164 = sequence;
        long x$165 = 99L;
        boolean x$166 = true;
        long x$167 = this.append$default$6();
        boolean x$168 = this.append$default$8();
        this.append(x$161, x$162, x$163, x$164, x$165, x$167, x$166, x$168);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        this.time().sleep((long)(this.maxPidExpirationMs() + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
    }

    @Test
    public void testSequenceNotValidatedForGroupMetadataTopic() {
        TopicPartition partition = new TopicPartition("__consumer_offsets", 0);
        ProducerStateManager stateManager = new ProducerStateManager(partition, this.logDir(), this.maxPidExpirationMs());
        short epoch = (short)0;
        ProducerStateManager x$169 = stateManager;
        long x$170 = this.producerId();
        short x$171 = epoch;
        int x$172 = -1;
        long x$173 = 99L;
        boolean x$174 = true;
        long x$175 = this.append$default$6();
        boolean x$176 = this.append$default$8();
        this.append(x$169, x$170, x$171, x$172, x$173, x$175, x$174, x$176);
        ProducerStateManager x$177 = stateManager;
        long x$178 = this.producerId();
        short x$179 = epoch;
        int x$180 = -1;
        long x$181 = 100L;
        boolean x$182 = true;
        long x$183 = this.append$default$6();
        boolean x$184 = this.append$default$8();
        this.append(x$177, x$178, x$179, x$180, x$181, x$183, x$182, x$184);
    }

    @Test(expected=ProducerFencedException.class)
    public void testOldEpochForControlRecord() {
        short epoch = (short)5;
        int sequence = 0;
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        ProducerStateManager x$185 = this.stateManager();
        long x$186 = this.producerId();
        short x$187 = epoch;
        int x$188 = sequence;
        long x$189 = 99L;
        boolean x$190 = true;
        long x$191 = this.append$default$6();
        boolean x$192 = this.append$default$8();
        this.append(x$185, x$186, x$187, x$188, x$189, x$191, x$190, x$192);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), (short)3, ControlRecordType.COMMIT, 100L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
    }

    @Test
    public void testCoordinatorFencing() {
        short epoch = (short)5;
        int sequence = 0;
        ProducerStateManager x$193 = this.stateManager();
        long x$194 = this.producerId();
        short x$195 = epoch;
        int x$196 = sequence;
        long x$197 = 99L;
        boolean x$198 = true;
        long x$199 = this.append$default$6();
        boolean x$200 = this.append$default$8();
        this.append(x$193, x$194, x$195, x$196, x$197, x$199, x$198, x$200);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 100L, 1, this.appendEndTxnMarker$default$7());
        Option lastEntry = this.stateManager().lastEntry(this.producerId());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)lastEntry.map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToInteger((int)x$16.coordinatorEpoch())));
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 101L, 1, this.appendEndTxnMarker$default$7());
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 102L, 2, this.appendEndTxnMarker$default$7());
        try {
            this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 103L, 1, this.appendEndTxnMarker$default$7());
            throw this.fail("Expected coordinator to be fenced", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 675));
        }
        catch (TransactionCoordinatorFencedException e) {
            return;
        }
    }

    @Test(expected=TransactionCoordinatorFencedException.class)
    public void testCoordinatorFencedAfterReload() {
        short producerEpoch = (short)0;
        ProducerStateManager x$201 = this.stateManager();
        long x$202 = this.producerId();
        short x$203 = producerEpoch;
        int x$204 = 0;
        long x$205 = 99L;
        boolean x$206 = true;
        long x$207 = this.append$default$6();
        boolean x$208 = this.append$default$8();
        this.append(x$201, x$202, x$203, x$204, x$205, x$207, x$206, x$208);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 100L, 1, this.appendEndTxnMarker$default$7());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 2L, 70000L);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 100L, 0, this.appendEndTxnMarker$default$7());
    }

    @Test
    public void testLoadFromEmptySnapshotFile() {
        this.testLoadFromCorruptSnapshot((Function1<FileChannel, BoxedUnit>)(Function1 & Serializable & scala.Serializable)file -> {
            file.truncate(0L);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testLoadFromTruncatedSnapshotFile() {
        this.testLoadFromCorruptSnapshot((Function1<FileChannel, BoxedUnit>)(Function1 & Serializable & scala.Serializable)file -> {
            ProducerStateManagerTest.$anonfun$testLoadFromTruncatedSnapshotFile$1(file);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testLoadFromCorruptSnapshotFile() {
        this.testLoadFromCorruptSnapshot((Function1<FileChannel, BoxedUnit>)(Function1 & Serializable & scala.Serializable)file -> {
            ProducerStateManagerTest.$anonfun$testLoadFromCorruptSnapshotFile$1(file);
            return BoxedUnit.UNIT;
        });
    }

    private void testLoadFromCorruptSnapshot(Function1<FileChannel, BoxedUnit> makeFileCorrupt) {
        short epoch = (short)0;
        long producerId = 1L;
        this.append(this.stateManager(), producerId, epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), producerId, epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Option latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)latestSnapshotOffset);
        File snapshotToTruncate = Log$.MODULE$.producerSnapshotFile(this.logDir(), BoxesRunTime.unboxToLong((Object)latestSnapshotOffset.get()));
        try (FileChannel channel = FileChannel.open(snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            makeFileCorrupt.apply((Object)channel);
        }
        ProducerStateManager reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assert.assertFalse((boolean)snapshotToTruncate.exists());
        ProducerStateEntry loadedProducerState = (ProducerStateEntry)reloadedStateManager.activeProducers().apply((Object)BoxesRunTime.boxToLong((long)producerId));
        Assert.assertEquals((long)0L, (long)loadedProducerState.lastDataOffset());
    }

    private Tuple2<CompletedTxn, Object> appendEndTxnMarker(ProducerStateManager mapping, long producerId, short producerEpoch, ControlRecordType controlType, long offset, int coordinatorEpoch, long timestamp) {
        ProducerAppendInfo producerAppendInfo = this.stateManager().prepareUpdate(producerId, true);
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(controlType, coordinatorEpoch);
        CompletedTxn completedTxn = producerAppendInfo.appendEndTxnMarker(endTxnMarker, producerEpoch, offset, timestamp);
        mapping.update(producerAppendInfo);
        long lastStableOffset = mapping.completeTxn(completedTxn);
        mapping.updateMapEndOffset(offset + 1L);
        return new Tuple2((Object)completedTxn, (Object)BoxesRunTime.boxToLong((long)lastStableOffset));
    }

    private void append(ProducerStateManager stateManager, long producerId, short producerEpoch, int seq, long offset, long timestamp, boolean isTransactional, boolean isFromClient) {
        ProducerAppendInfo producerAppendInfo = stateManager.prepareUpdate(producerId, isFromClient);
        producerAppendInfo.append(producerEpoch, seq, seq, timestamp, offset, isTransactional);
        stateManager.update(producerAppendInfo);
        stateManager.updateMapEndOffset(offset + 1L);
    }

    private long append$default$6() {
        return this.time().milliseconds();
    }

    private boolean append$default$7() {
        return false;
    }

    private boolean append$default$8() {
        return true;
    }

    private int appendEndTxnMarker$default$6() {
        return 0;
    }

    private long appendEndTxnMarker$default$7() {
        return this.time().milliseconds();
    }

    private Set<Object> currentSnapshotOffsets() {
        return new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).map((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToLong((long)Log$.MODULE$.offsetFromFile(file)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).toSet();
    }

    public static final /* synthetic */ void $anonfun$testLoadFromTruncatedSnapshotFile$1(FileChannel file) {
        Assert.assertTrue((file.size() > 2L ? 1 : 0) != 0);
        file.truncate(file.size() / 2L);
    }

    public static final /* synthetic */ void $anonfun$testLoadFromCorruptSnapshotFile$1(FileChannel file) {
        Assert.assertTrue((file.size() > 2L ? 1 : 0) != 0);
        file.write(ByteBuffer.wrap((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{37}), ClassTag$.MODULE$.Byte())), file.size() / 2L);
    }

    public ProducerStateManagerTest() {
        this.producerId = 1L;
        this.maxPidExpirationMs = 60000;
    }
}

