/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.streams.errors.DeserializationExceptionHandler;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.internals.SourceNode;
import org.slf4j.Logger;

class RecordDeserializer {
    private final SourceNode sourceNode;
    private final DeserializationExceptionHandler deserializationExceptionHandler;
    private final Logger log;

    RecordDeserializer(SourceNode sourceNode, DeserializationExceptionHandler deserializationExceptionHandler, LogContext logContext) {
        this.sourceNode = sourceNode;
        this.deserializationExceptionHandler = deserializationExceptionHandler;
        this.log = logContext.logger(RecordDeserializer.class);
    }

    ConsumerRecord<Object, Object> deserialize(ProcessorContext processorContext, ConsumerRecord<byte[], byte[]> rawRecord) {
        try {
            return new ConsumerRecord(rawRecord.topic(), rawRecord.partition(), rawRecord.offset(), rawRecord.timestamp(), TimestampType.CREATE_TIME, rawRecord.checksum(), rawRecord.serializedKeySize(), rawRecord.serializedValueSize(), this.sourceNode.deserializeKey(rawRecord.topic(), rawRecord.headers(), (byte[])rawRecord.key()), this.sourceNode.deserializeValue(rawRecord.topic(), rawRecord.headers(), (byte[])rawRecord.value()));
        }
        catch (Exception deserializationException) {
            DeserializationExceptionHandler.DeserializationHandlerResponse response;
            try {
                response = this.deserializationExceptionHandler.handle(processorContext, rawRecord, deserializationException);
            }
            catch (Exception fatalUserException) {
                this.log.error("Deserialization error callback failed after deserialization error for record {}", rawRecord, (Object)deserializationException);
                throw new StreamsException("Fatal user code error in deserialization error callback", fatalUserException);
            }
            if (response == DeserializationExceptionHandler.DeserializationHandlerResponse.FAIL) {
                throw new StreamsException("Deserialization exception handler is set to fail upon a deserialization error. If you would rather have the streaming pipeline continue after a deserialization error, please set the default.deserialization.exception.handler appropriately.", deserializationException);
            }
            this.sourceNode.nodeMetrics.sourceNodeSkippedDueToDeserializationError.record();
            return null;
        }
    }

    SourceNode sourceNode() {
        return this.sourceNode;
    }
}

