/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.trogdor.common.JsonUtil;
import org.apache.kafka.trogdor.common.Platform;
import org.apache.kafka.trogdor.common.ThreadUtils;
import org.apache.kafka.trogdor.common.WorkerUtils;
import org.apache.kafka.trogdor.task.TaskWorker;
import org.apache.kafka.trogdor.workload.Histogram;
import org.apache.kafka.trogdor.workload.ProduceBenchSpec;
import org.apache.kafka.trogdor.workload.Throttle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProduceBenchWorker
implements TaskWorker {
    private static final Logger log = LoggerFactory.getLogger(ProduceBenchWorker.class);
    private static final short NUM_PARTITIONS = 1;
    private static final short REPLICATION_FACTOR = 3;
    private static final int MESSAGE_SIZE = 512;
    private static final int THROTTLE_PERIOD_MS = 100;
    private final String id;
    private final ProduceBenchSpec spec;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private ScheduledExecutorService executor;
    private AtomicReference<String> status;
    private KafkaFutureImpl<String> doneFuture;

    public static String topicIndexToName(int topicIndex) {
        return String.format("topic%05d", topicIndex);
    }

    public ProduceBenchWorker(String id, ProduceBenchSpec spec) {
        this.id = id;
        this.spec = spec;
    }

    @Override
    public void start(Platform platform, AtomicReference<String> status, KafkaFutureImpl<String> doneFuture) throws Exception {
        if (!this.running.compareAndSet(false, true)) {
            throw new IllegalStateException("ProducerBenchWorker is already running.");
        }
        log.info("{}: Activating ProduceBenchWorker.", (Object)this.id);
        this.executor = Executors.newScheduledThreadPool(1, ThreadUtils.createThreadFactory("ProduceBenchWorkerThread%d", false));
        this.status = status;
        this.doneFuture = doneFuture;
        this.executor.submit(new Prepare());
    }

    @Override
    public void stop(Platform platform) throws Exception {
        if (!this.running.compareAndSet(true, false)) {
            throw new IllegalStateException("ProduceBenchWorker is not running.");
        }
        log.info("{}: Deactivating ProduceBenchWorker.", (Object)this.id);
        this.doneFuture.complete((Object)"");
        this.executor.shutdownNow();
        this.executor.awaitTermination(1L, TimeUnit.DAYS);
        this.executor = null;
        this.status = null;
        this.doneFuture = null;
    }

    public static class StatusData {
        private final long totalSent;
        private final float averageLatencyMs;
        private final int p50LatencyMs;
        private final int p90LatencyMs;
        private final int p99LatencyMs;

        @JsonCreator
        StatusData(@JsonProperty(value="totalSent") long totalSent, @JsonProperty(value="averageLatencyMs") float averageLatencyMs, @JsonProperty(value="p50LatencyMs") int p50latencyMs, @JsonProperty(value="p90LatencyMs") int p90latencyMs, @JsonProperty(value="p99LatencyMs") int p99latencyMs) {
            this.totalSent = totalSent;
            this.averageLatencyMs = averageLatencyMs;
            this.p50LatencyMs = p50latencyMs;
            this.p90LatencyMs = p90latencyMs;
            this.p99LatencyMs = p99latencyMs;
        }

        @JsonProperty
        public long totalSent() {
            return this.totalSent;
        }

        @JsonProperty
        public float averageLatencyMs() {
            return this.averageLatencyMs;
        }

        @JsonProperty
        public int p50LatencyMs() {
            return this.p50LatencyMs;
        }

        @JsonProperty
        public int p90LatencyMs() {
            return this.p90LatencyMs;
        }

        @JsonProperty
        public int p99LatencyMs() {
            return this.p99LatencyMs;
        }
    }

    public class StatusUpdater
    implements Runnable {
        private final Histogram histogram;
        private final float[] percentiles;

        StatusUpdater(Histogram histogram) {
            this.histogram = histogram;
            this.percentiles = new float[]{0.5f, 0.95f, 0.99f};
        }

        @Override
        public void run() {
            try {
                Histogram.Summary summary = this.histogram.summarize(this.percentiles);
                StatusData statusData = new StatusData(summary.numSamples(), summary.average(), summary.percentiles().get(0).value(), summary.percentiles().get(1).value(), summary.percentiles().get(2).value());
                String statusDataString = JsonUtil.toJsonString(statusData);
                ProduceBenchWorker.this.status.set(statusDataString);
            }
            catch (Exception e) {
                WorkerUtils.abort(log, "StatusUpdater", e, (KafkaFutureImpl<String>)ProduceBenchWorker.this.doneFuture);
            }
        }
    }

    public class SendRecords
    implements Callable<Void> {
        private final Histogram histogram = new Histogram(5000);
        private final Future<?> statusUpdaterFuture;
        private final KafkaProducer<byte[], byte[]> producer;
        private final Throttle throttle;

        SendRecords() {
            int perPeriod = WorkerUtils.perSecToPerPeriod(ProduceBenchWorker.this.spec.targetMessagesPerSec(), 100L);
            this.statusUpdaterFuture = ProduceBenchWorker.this.executor.scheduleWithFixedDelay(new StatusUpdater(this.histogram), 1L, 1L, TimeUnit.MINUTES);
            Properties props = new Properties();
            props.put("bootstrap.servers", ProduceBenchWorker.this.spec.bootstrapServers());
            for (Map.Entry<String, String> entry : ProduceBenchWorker.this.spec.producerConf().entrySet()) {
                props.setProperty(entry.getKey(), entry.getValue());
            }
            this.producer = new KafkaProducer(props, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());
            this.throttle = new SendRecordsThrottle(perPeriod, this.producer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            long startTimeMs = Time.SYSTEM.milliseconds();
            try {
                byte[] key = new byte[512];
                byte[] value = new byte[512];
                Future future = null;
                try {
                    for (int m = 0; m < ProduceBenchWorker.this.spec.maxMessages(); ++m) {
                        for (int i = 0; i < ProduceBenchWorker.this.spec.activeTopics(); ++i) {
                            ProducerRecord record = new ProducerRecord(ProduceBenchWorker.topicIndexToName(i), (Object)key, (Object)value);
                            future = this.producer.send(record, (Callback)new SendRecordsCallback(this, Time.SYSTEM.milliseconds()));
                        }
                        this.throttle.increment();
                    }
                }
                finally {
                    if (future != null) {
                        future.get();
                    }
                    this.producer.close();
                }
                this.statusUpdaterFuture.cancel(false);
            }
            catch (Exception e) {
                try {
                    WorkerUtils.abort(log, "SendRecords", e, (KafkaFutureImpl<String>)ProduceBenchWorker.this.doneFuture);
                    this.statusUpdaterFuture.cancel(false);
                }
                catch (Throwable throwable) {
                    this.statusUpdaterFuture.cancel(false);
                    new StatusUpdater(this.histogram).run();
                    long curTimeMs = Time.SYSTEM.milliseconds();
                    log.info("Sent {} total record(s) in {} ms.  status: {}", new Object[]{this.histogram.summarize().numSamples(), curTimeMs - startTimeMs, ProduceBenchWorker.this.status.get()});
                    throw throwable;
                }
                new StatusUpdater(this.histogram).run();
                long curTimeMs = Time.SYSTEM.milliseconds();
                log.info("Sent {} total record(s) in {} ms.  status: {}", new Object[]{this.histogram.summarize().numSamples(), curTimeMs - startTimeMs, ProduceBenchWorker.this.status.get()});
            }
            new StatusUpdater(this.histogram).run();
            long curTimeMs = Time.SYSTEM.milliseconds();
            log.info("Sent {} total record(s) in {} ms.  status: {}", new Object[]{this.histogram.summarize().numSamples(), curTimeMs - startTimeMs, ProduceBenchWorker.this.status.get()});
            ProduceBenchWorker.this.doneFuture.complete((Object)"");
            return null;
        }

        void recordDuration(long durationMs) {
            this.histogram.add(durationMs);
        }
    }

    private static class SendRecordsThrottle
    extends Throttle {
        private final KafkaProducer<?, ?> producer;

        SendRecordsThrottle(int maxPerPeriod, KafkaProducer<?, ?> producer) {
            super(maxPerPeriod, 100);
            this.producer = producer;
        }

        @Override
        protected synchronized void delay(long amount) throws InterruptedException {
            long startMs = this.time().milliseconds();
            this.producer.flush();
            long endMs = this.time().milliseconds();
            long delta = endMs - startMs;
            super.delay(amount - delta);
        }
    }

    private static class SendRecordsCallback
    implements Callback {
        private final SendRecords sendRecords;
        private final long startMs;

        SendRecordsCallback(SendRecords sendRecords, long startMs) {
            this.sendRecords = sendRecords;
            this.startMs = startMs;
        }

        public void onCompletion(RecordMetadata metadata, Exception exception) {
            long now = Time.SYSTEM.milliseconds();
            long durationMs = now - this.startMs;
            this.sendRecords.recordDuration(durationMs);
            if (exception != null) {
                log.error("SendRecordsCallback: error", (Throwable)exception);
            }
        }
    }

    public class Prepare
    implements Runnable {
        @Override
        public void run() {
            try {
                if (ProduceBenchWorker.this.spec.activeTopics() == 0) {
                    throw new ConfigException("Can't have activeTopics == 0.");
                }
                if (ProduceBenchWorker.this.spec.totalTopics() < ProduceBenchWorker.this.spec.activeTopics()) {
                    throw new ConfigException(String.format("activeTopics was %d, but totalTopics was only %d.  activeTopics must be less than or equal to totalTopics.", ProduceBenchWorker.this.spec.activeTopics(), ProduceBenchWorker.this.spec.totalTopics()));
                }
                ArrayList<NewTopic> newTopics = new ArrayList<NewTopic>();
                for (int i = 0; i < ProduceBenchWorker.this.spec.totalTopics(); ++i) {
                    newTopics.add(new NewTopic(ProduceBenchWorker.topicIndexToName(i), 1, 3));
                }
                WorkerUtils.createTopics(log, ProduceBenchWorker.this.spec.bootstrapServers(), newTopics);
                ProduceBenchWorker.this.executor.submit(new SendRecords());
            }
            catch (Throwable e) {
                WorkerUtils.abort(log, "Prepare", e, (KafkaFutureImpl<String>)ProduceBenchWorker.this.doneFuture);
            }
        }
    }
}

