/*
 * Decompiled with CFR 0.152.
 */
package liquibase.datatype.core;

import java.util.Arrays;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.datatype.DatabaseDataType;
import liquibase.datatype.LiquibaseDataType;
import liquibase.statement.DatabaseFunction;

public class UnknownType
extends LiquibaseDataType {
    private boolean autoIncrement;

    public UnknownType() {
        super("UNKNOWN", 0, 2);
    }

    public UnknownType(String name) {
        super(name, 0, 2);
    }

    public UnknownType(String name, int minParameters, int maxParameters) {
        super(name, minParameters, maxParameters);
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public void setAutoIncrement(boolean autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    @Override
    public DatabaseDataType toDatabaseDataType(Database database) {
        int dataTypeMaxParameters = this.getName().equalsIgnoreCase("enum") || this.getName().equalsIgnoreCase("set") ? Integer.MAX_VALUE : database.getDataTypeMaxParameters(this.getName());
        Object[] parameters = this.getParameters();
        if (database instanceof OracleDatabase) {
            if (this.getName().equalsIgnoreCase("LONG") || this.getName().equalsIgnoreCase("BFILE") || this.getName().equalsIgnoreCase("ROWID") || this.getName().equalsIgnoreCase("ANYDATA") || this.getName().equalsIgnoreCase("SDO_GEOMETRY")) {
                parameters = new Object[]{};
            } else {
                if (this.getName().toUpperCase().startsWith("INTERVAL ")) {
                    return new DatabaseDataType(this.getName().replaceAll("\\(\\d+\\)", ""));
                }
                if (((OracleDatabase)database).getUserDefinedTypes().contains(this.getName().toUpperCase())) {
                    return new DatabaseDataType(this.getName().toUpperCase());
                }
            }
        }
        if (dataTypeMaxParameters < parameters.length) {
            parameters = Arrays.copyOfRange(parameters, 0, dataTypeMaxParameters);
        }
        DatabaseDataType type = database instanceof MSSQLDatabase ? new DatabaseDataType(database.escapeDataTypeName(this.getName()), parameters) : new DatabaseDataType(this.getName().toUpperCase(), parameters);
        type.addAdditionalInformation(this.getAdditionalInformation());
        return type;
    }

    @Override
    public String objectToSql(Object value, Database database) {
        if (value instanceof DatabaseFunction) {
            return super.objectToSql(value, database);
        }
        return "'" + super.objectToSql(value, database) + "'";
    }
}

