/* Autogenerated by mlir-tblgen; don't manually edit */

#ifdef GEN_PASS_DECL
// Generate declarations for all passes.
#define GEN_PASS_DECL_OPTREDUCTION
#define GEN_PASS_DECL_REDUCTIONTREE
#undef GEN_PASS_DECL
#endif // GEN_PASS_DECL

//===----------------------------------------------------------------------===//
// OptReduction
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_OPTREDUCTION
struct OptReductionOptions {
  std::string optPass;
  std::string testerName;
  ::llvm::ArrayRef<std::string> testerArgs;
};
#undef GEN_PASS_DECL_OPTREDUCTION
#endif // GEN_PASS_DECL_OPTREDUCTION
#ifdef GEN_PASS_DEF_OPTREDUCTION
namespace impl {

template <typename DerivedT>
class OptReductionBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = OptReductionBase;

  OptReductionBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  OptReductionBase(const OptReductionBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}
  OptReductionBase& operator=(const OptReductionBase &) = delete;
  OptReductionBase(OptReductionBase &&) = delete;
  OptReductionBase& operator=(OptReductionBase &&) = delete;
  ~OptReductionBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("opt-reduction-pass");
  }
  ::llvm::StringRef getArgument() const override { return "opt-reduction-pass"; }

  ::llvm::StringRef getDescription() const override { return "A wrapper pass that reduces the file with optimization passes"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("OptReduction");
  }
  ::llvm::StringRef getName() const override { return "OptReduction"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(OptReductionBase<DerivedT>)

  OptReductionBase(const OptReductionOptions &options) : OptReductionBase() {
    optPass = options.optPass;
    testerName = options.testerName;
    testerArgs = options.testerArgs;
  }
protected:
  ::mlir::Pass::Option<std::string> optPass{*this, "opt-pass", ::llvm::cl::desc("The optimization passes used for reduction, e.g., symbol-dce")};
  ::mlir::Pass::Option<std::string> testerName{*this, "test", ::llvm::cl::desc("The location of the tester which tests the file interestingness")};
  ::mlir::Pass::ListOption<std::string> testerArgs{*this, "test-arg", ::llvm::cl::desc("arguments of the tester")};
private:
};
} // namespace impl
#undef GEN_PASS_DEF_OPTREDUCTION
#endif // GEN_PASS_DEF_OPTREDUCTION

//===----------------------------------------------------------------------===//
// ReductionTree
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_REDUCTIONTREE
struct ReductionTreeOptions {
  unsigned traversalModeId = 0;
  std::string testerName;
  ::llvm::ArrayRef<std::string> testerArgs;
};
#undef GEN_PASS_DECL_REDUCTIONTREE
#endif // GEN_PASS_DECL_REDUCTIONTREE
#ifdef GEN_PASS_DEF_REDUCTIONTREE
namespace impl {

template <typename DerivedT>
class ReductionTreeBase : public ::mlir::OperationPass<> {
public:
  using Base = ReductionTreeBase;

  ReductionTreeBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  ReductionTreeBase(const ReductionTreeBase &other) : ::mlir::OperationPass<>(other) {}
  ReductionTreeBase& operator=(const ReductionTreeBase &) = delete;
  ReductionTreeBase(ReductionTreeBase &&) = delete;
  ReductionTreeBase& operator=(ReductionTreeBase &&) = delete;
  ~ReductionTreeBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("reduction-tree");
  }
  ::llvm::StringRef getArgument() const override { return "reduction-tree"; }

  ::llvm::StringRef getDescription() const override { return "Reduce the input with reduction-tree algorithm"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ReductionTree");
  }
  ::llvm::StringRef getName() const override { return "ReductionTree"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ReductionTreeBase<DerivedT>)

  ReductionTreeBase(const ReductionTreeOptions &options) : ReductionTreeBase() {
    traversalModeId = options.traversalModeId;
    testerName = options.testerName;
    testerArgs = options.testerArgs;
  }
protected:
  ::mlir::Pass::Option<unsigned> traversalModeId{*this, "traversal-mode", ::llvm::cl::desc("The graph traversal mode, the default is single-path mode"), ::llvm::cl::init(0)};
  ::mlir::Pass::Option<std::string> testerName{*this, "test", ::llvm::cl::desc("The location of the tester which tests the file interestingness")};
  ::mlir::Pass::ListOption<std::string> testerArgs{*this, "test-arg", ::llvm::cl::desc("arguments of the tester")};
private:
};
} // namespace impl
#undef GEN_PASS_DEF_REDUCTIONTREE
#endif // GEN_PASS_DEF_REDUCTIONTREE
#ifdef GEN_PASS_REGISTRATION

//===----------------------------------------------------------------------===//
// OptReduction Registration
//===----------------------------------------------------------------------===//

inline void registerOptReduction() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createOptReductionPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerOptReductionPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createOptReductionPass();
  });
}

//===----------------------------------------------------------------------===//
// ReductionTree Registration
//===----------------------------------------------------------------------===//

inline void registerReductionTree() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createReductionTreePass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerReductionTreePass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createReductionTreePass();
  });
}

//===----------------------------------------------------------------------===//
// Reducer Registration
//===----------------------------------------------------------------------===//

inline void registerReducerPasses() {
  registerOptReduction();
  registerReductionTree();
}
#undef GEN_PASS_REGISTRATION
#endif // GEN_PASS_REGISTRATION
// Deprecated. Please use the new per-pass macros.
#ifdef GEN_PASS_CLASSES

template <typename DerivedT>
class OptReductionBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = OptReductionBase;

  OptReductionBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  OptReductionBase(const OptReductionBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}
  OptReductionBase& operator=(const OptReductionBase &) = delete;
  OptReductionBase(OptReductionBase &&) = delete;
  OptReductionBase& operator=(OptReductionBase &&) = delete;
  ~OptReductionBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("opt-reduction-pass");
  }
  ::llvm::StringRef getArgument() const override { return "opt-reduction-pass"; }

  ::llvm::StringRef getDescription() const override { return "A wrapper pass that reduces the file with optimization passes"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("OptReduction");
  }
  ::llvm::StringRef getName() const override { return "OptReduction"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(OptReductionBase<DerivedT>)

protected:
  ::mlir::Pass::Option<std::string> optPass{*this, "opt-pass", ::llvm::cl::desc("The optimization passes used for reduction, e.g., symbol-dce")};
  ::mlir::Pass::Option<std::string> testerName{*this, "test", ::llvm::cl::desc("The location of the tester which tests the file interestingness")};
  ::mlir::Pass::ListOption<std::string> testerArgs{*this, "test-arg", ::llvm::cl::desc("arguments of the tester")};
};

template <typename DerivedT>
class ReductionTreeBase : public ::mlir::OperationPass<> {
public:
  using Base = ReductionTreeBase;

  ReductionTreeBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  ReductionTreeBase(const ReductionTreeBase &other) : ::mlir::OperationPass<>(other) {}
  ReductionTreeBase& operator=(const ReductionTreeBase &) = delete;
  ReductionTreeBase(ReductionTreeBase &&) = delete;
  ReductionTreeBase& operator=(ReductionTreeBase &&) = delete;
  ~ReductionTreeBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("reduction-tree");
  }
  ::llvm::StringRef getArgument() const override { return "reduction-tree"; }

  ::llvm::StringRef getDescription() const override { return "Reduce the input with reduction-tree algorithm"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ReductionTree");
  }
  ::llvm::StringRef getName() const override { return "ReductionTree"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ReductionTreeBase<DerivedT>)

protected:
  ::mlir::Pass::Option<unsigned> traversalModeId{*this, "traversal-mode", ::llvm::cl::desc("The graph traversal mode, the default is single-path mode"), ::llvm::cl::init(0)};
  ::mlir::Pass::Option<std::string> testerName{*this, "test", ::llvm::cl::desc("The location of the tester which tests the file interestingness")};
  ::mlir::Pass::ListOption<std::string> testerArgs{*this, "test-arg", ::llvm::cl::desc("arguments of the tester")};
};
#undef GEN_PASS_CLASSES
#endif // GEN_PASS_CLASSES
