/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner.plugin;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.parosproxy.paros.core.scanner.AbstractAppPlugin;
import org.parosproxy.paros.network.HttpMessage;

public class TestInfoPrivateAddressDisclosure
extends AbstractAppPlugin {
    public static final Pattern patternPrivateIP = Pattern.compile("(10\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}|172\\.\\d{2,2}\\.\\d{1,3}\\.\\d{1,3}|192\\.168\\.\\d{1,3}\\.\\d{1,3})", 10);

    public int getId() {
        return 3;
    }

    public String getName() {
        return "Private IP disclosure";
    }

    public String[] getDependency() {
        return null;
    }

    public String getDescription() {
        return "Private IP such as 10.x.x.x, 172.x.x.x, 192.168.x.x is found in the HTTP response body.  This can be used in exploits on internal system.";
    }

    public int getCategory() {
        return 0;
    }

    public String getSolution() {
        return "Remove the private IP address from the HTTP response body.  For comments, use jsp/asp comment instead of HTML/javascript comment which can be seen by client browsers.";
    }

    public String getReference() {
        return null;
    }

    public void init() {
    }

    public void scan() {
        HttpMessage httpMessage = this.getBaseMsg();
        String string = httpMessage.getResponseBody().toString();
        String string2 = null;
        Matcher matcher = patternPrivateIP.matcher(string);
        while (matcher.find()) {
            string2 = matcher.group();
            if (string2 == null) continue;
            this.bingo(1, 1, null, null, string2, httpMessage);
        }
    }
}

